/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.vertex;

import com.mojang.blaze3d.vertex.DefaultedVertexConsumer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.core.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;

@OnlyIn(value=Dist.CLIENT)
public class SheetedDecalTextureGenerator
extends DefaultedVertexConsumer {
    private final VertexConsumer delegate;
    private final Matrix4f cameraInversePose;
    private final Matrix3f normalInversePose;
    private final float textureScale;
    private float x;
    private float y;
    private float z;
    private int overlayU;
    private int overlayV;
    private int lightCoords;
    private float nx;
    private float ny;
    private float nz;

    public SheetedDecalTextureGenerator(VertexConsumer p_260211_, Matrix4f p_259178_, Matrix3f p_259698_, float p_259312_) {
        this.delegate = p_260211_;
        this.cameraInversePose = new Matrix4f((Matrix4fc)p_259178_).invert();
        this.normalInversePose = new Matrix3f((Matrix3fc)p_259698_).invert();
        this.textureScale = p_259312_;
        this.resetState();
    }

    private void resetState() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.overlayU = 0;
        this.overlayV = 10;
        this.lightCoords = 0xF000F0;
        this.nx = 0.0f;
        this.ny = 1.0f;
        this.nz = 0.0f;
    }

    @Override
    public void endVertex() {
        Vector3f vector3f = this.normalInversePose.transform(new Vector3f(this.nx, this.ny, this.nz));
        Direction direction = ForgeHooksClient.getNearestStable(vector3f.x(), vector3f.y(), vector3f.z());
        Vector4f vector4f = this.cameraInversePose.transform(new Vector4f(this.x, this.y, this.z, 1.0f));
        vector4f.rotateY((float)Math.PI);
        vector4f.rotateX(-1.5707964f);
        vector4f.rotate((Quaternionfc)direction.getRotation());
        float f = -vector4f.x() * this.textureScale;
        float f1 = -vector4f.y() * this.textureScale;
        this.delegate.vertex(this.x, this.y, this.z).color(1.0f, 1.0f, 1.0f, 1.0f).uv(f, f1).overlayCoords(this.overlayU, this.overlayV).uv2(this.lightCoords).normal(this.nx, this.ny, this.nz).endVertex();
        this.resetState();
    }

    @Override
    public VertexConsumer vertex(double p_85885_, double p_85886_, double p_85887_) {
        this.x = (float)p_85885_;
        this.y = (float)p_85886_;
        this.z = (float)p_85887_;
        return this;
    }

    @Override
    public VertexConsumer color(int p_85895_, int p_85896_, int p_85897_, int p_85898_) {
        return this;
    }

    @Override
    public VertexConsumer uv(float p_85889_, float p_85890_) {
        return this;
    }

    @Override
    public VertexConsumer overlayCoords(int p_85892_, int p_85893_) {
        this.overlayU = p_85892_;
        this.overlayV = p_85893_;
        return this;
    }

    @Override
    public VertexConsumer uv2(int p_85904_, int p_85905_) {
        this.lightCoords = p_85904_ | p_85905_ << 16;
        return this;
    }

    @Override
    public VertexConsumer normal(float p_85900_, float p_85901_, float p_85902_) {
        this.nx = p_85900_;
        this.ny = p_85901_;
        this.nz = p_85902_;
        return this;
    }
}

