/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import java.util.Arrays;
import net.minecraft.Util;
import org.joml.Matrix3f;

public enum SymmetricGroup3 {
    P123(0, 1, 2),
    P213(1, 0, 2),
    P132(0, 2, 1),
    P231(1, 2, 0),
    P312(2, 0, 1),
    P321(2, 1, 0);

    private final int[] permutation;
    private final Matrix3f transformation;
    private static final int ORDER = 3;
    private static final SymmetricGroup3[][] cayleyTable;

    private SymmetricGroup3(int p_109176_, int p_109177_, int p_109178_) {
        this.permutation = new int[]{p_109176_, p_109177_, p_109178_};
        this.transformation = new Matrix3f();
        this.transformation.set(this.permutation(0), 0, 1.0f);
        this.transformation.set(this.permutation(1), 1, 1.0f);
        this.transformation.set(this.permutation(2), 2, 1.0f);
    }

    public SymmetricGroup3 compose(SymmetricGroup3 p_109183_) {
        return cayleyTable[this.ordinal()][p_109183_.ordinal()];
    }

    public int permutation(int p_109181_) {
        return this.permutation[p_109181_];
    }

    public Matrix3f transformation() {
        return this.transformation;
    }

    static {
        cayleyTable = Util.make(new SymmetricGroup3[SymmetricGroup3.values().length][SymmetricGroup3.values().length], p_109188_ -> {
            for (SymmetricGroup3 symmetricgroup3 : SymmetricGroup3.values()) {
                for (SymmetricGroup3 symmetricgroup31 : SymmetricGroup3.values()) {
                    SymmetricGroup3 symmetricgroup32;
                    int[] aint = new int[3];
                    for (int i = 0; i < 3; ++i) {
                        aint[i] = symmetricgroup3.permutation[symmetricgroup31.permutation[i]];
                    }
                    p_109188_[symmetricgroup3.ordinal()][symmetricgroup31.ordinal()] = symmetricgroup32 = Arrays.stream(SymmetricGroup3.values()).filter(p_175577_ -> Arrays.equals(p_175577_.permutation, aint)).findFirst().get();
                }
            }
        });
    }
}

