/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.dto;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.dto.RealmsText;
import com.mojang.realmsclient.util.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class RealmsNotification {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String NOTIFICATION_UUID = "notificationUuid";
    private static final String DISMISSABLE = "dismissable";
    private static final String SEEN = "seen";
    private static final String TYPE = "type";
    private static final String VISIT_URL = "visitUrl";
    final UUID uuid;
    final boolean dismissable;
    final boolean seen;
    final String type;

    RealmsNotification(UUID p_275316_, boolean p_275303_, boolean p_275497_, String p_275401_) {
        this.uuid = p_275316_;
        this.dismissable = p_275303_;
        this.seen = p_275497_;
        this.type = p_275401_;
    }

    public boolean seen() {
        return this.seen;
    }

    public boolean dismissable() {
        return this.dismissable;
    }

    public UUID uuid() {
        return this.uuid;
    }

    public static List<RealmsNotification> parseList(String p_275464_) {
        ArrayList<RealmsNotification> list = new ArrayList<RealmsNotification>();
        try {
            for (JsonElement jsonelement : JsonParser.parseString((String)p_275464_).getAsJsonObject().get("notifications").getAsJsonArray()) {
                list.add(RealmsNotification.parse(jsonelement.getAsJsonObject()));
            }
        }
        catch (Exception exception) {
            LOGGER.error("Could not parse list of RealmsNotifications", (Throwable)exception);
        }
        return list;
    }

    private static RealmsNotification parse(JsonObject p_275549_) {
        UUID uuid = JsonUtils.getUuidOr(NOTIFICATION_UUID, p_275549_, null);
        if (uuid == null) {
            throw new IllegalStateException("Missing required property notificationUuid");
        }
        boolean flag = JsonUtils.getBooleanOr(DISMISSABLE, p_275549_, true);
        boolean flag1 = JsonUtils.getBooleanOr(SEEN, p_275549_, false);
        String s = JsonUtils.getRequiredString(TYPE, p_275549_);
        RealmsNotification realmsnotification = new RealmsNotification(uuid, flag, flag1, s);
        return VISIT_URL.equals(s) ? VisitUrl.parse(realmsnotification, p_275549_) : realmsnotification;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class VisitUrl
    extends RealmsNotification {
        private static final String URL = "url";
        private static final String BUTTON_TEXT = "buttonText";
        private static final String MESSAGE = "message";
        private final String url;
        private final RealmsText buttonText;
        private final RealmsText message;

        private VisitUrl(RealmsNotification p_275564_, String p_275312_, RealmsText p_275433_, RealmsText p_275541_) {
            super(p_275564_.uuid, p_275564_.dismissable, p_275564_.seen, p_275564_.type);
            this.url = p_275312_;
            this.buttonText = p_275433_;
            this.message = p_275541_;
        }

        public static VisitUrl parse(RealmsNotification p_275651_, JsonObject p_275278_) {
            String s = JsonUtils.getRequiredString(URL, p_275278_);
            RealmsText realmstext = JsonUtils.getRequired(BUTTON_TEXT, p_275278_, RealmsText::parse);
            RealmsText realmstext1 = JsonUtils.getRequired(MESSAGE, p_275278_, RealmsText::parse);
            return new VisitUrl(p_275651_, s, realmstext, realmstext1);
        }

        public Component getMessage() {
            return this.message.createComponent(Component.translatable("mco.notification.visitUrl.message.default"));
        }

        public Button buildOpenLinkButton(Screen p_275412_) {
            Component component = this.buttonText.createComponent(Component.translatable("mco.notification.visitUrl.buttonText.default"));
            return Button.builder(component, ConfirmLinkScreen.confirmLink(this.url, p_275412_, true)).build();
        }
    }
}

