/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import java.util.Set;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ConsumeItemTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("consume_item");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public TriggerInstance createInstance(JsonObject p_286724_, ContextAwarePredicate p_286492_, DeserializationContext p_286887_) {
        return new TriggerInstance(p_286492_, ItemPredicate.fromJson(p_286724_.get("item")));
    }

    public void trigger(ServerPlayer p_23683_, ItemStack p_23684_) {
        this.trigger(p_23683_, (T p_23687_) -> p_23687_.matches(p_23684_));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final ItemPredicate item;

        public TriggerInstance(ContextAwarePredicate p_286663_, ItemPredicate p_286533_) {
            super(ID, p_286663_);
            this.item = p_286533_;
        }

        public static TriggerInstance usedItem() {
            return new TriggerInstance(ContextAwarePredicate.ANY, ItemPredicate.ANY);
        }

        public static TriggerInstance usedItem(ItemPredicate p_148082_) {
            return new TriggerInstance(ContextAwarePredicate.ANY, p_148082_);
        }

        public static TriggerInstance usedItem(ItemLike p_23704_) {
            return new TriggerInstance(ContextAwarePredicate.ANY, new ItemPredicate(null, (Set<Item>)ImmutableSet.of((Object)p_23704_.asItem()), MinMaxBounds.Ints.ANY, MinMaxBounds.Ints.ANY, EnchantmentPredicate.NONE, EnchantmentPredicate.NONE, null, NbtPredicate.ANY));
        }

        public boolean matches(ItemStack p_23702_) {
            return this.item.matches(p_23702_);
        }

        @Override
        public JsonObject serializeToJson(SerializationContext p_23706_) {
            JsonObject jsonobject = super.serializeToJson(p_23706_);
            jsonobject.add("item", this.item.serializeToJson());
            return jsonobject;
        }
    }
}

