/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EntityVariantPredicate;
import net.minecraft.advancements.critereon.FishingHookPredicate;
import net.minecraft.advancements.critereon.LighthingBoltPredicate;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.SlimePredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.phys.Vec3;

public interface EntitySubPredicate {
    public static final EntitySubPredicate ANY = new EntitySubPredicate(){

        @Override
        public boolean matches(Entity p_218841_, ServerLevel p_218842_, @Nullable Vec3 p_218843_) {
            return true;
        }

        @Override
        public JsonObject serializeCustomData() {
            return new JsonObject();
        }

        @Override
        public Type type() {
            return Types.ANY;
        }
    };

    public static EntitySubPredicate fromJson(@Nullable JsonElement p_218836_) {
        if (p_218836_ != null && !p_218836_.isJsonNull()) {
            JsonObject jsonobject = GsonHelper.convertToJsonObject(p_218836_, "type_specific");
            String s = GsonHelper.getAsString(jsonobject, "type", null);
            if (s == null) {
                return ANY;
            }
            Type entitysubpredicate$type = (Type)Types.TYPES.get((Object)s);
            if (entitysubpredicate$type == null) {
                throw new JsonSyntaxException("Unknown sub-predicate type: " + s);
            }
            return entitysubpredicate$type.deserialize(jsonobject);
        }
        return ANY;
    }

    public boolean matches(Entity var1, ServerLevel var2, @Nullable Vec3 var3);

    public JsonObject serializeCustomData();

    default public JsonElement serialize() {
        if (this.type() == Types.ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonobject = this.serializeCustomData();
        String s = (String)Types.TYPES.inverse().get((Object)this.type());
        jsonobject.addProperty("type", s);
        return jsonobject;
    }

    public Type type();

    public static EntitySubPredicate variant(CatVariant p_218832_) {
        return Types.CAT.createPredicate(p_218832_);
    }

    public static EntitySubPredicate variant(FrogVariant p_218834_) {
        return Types.FROG.createPredicate(p_218834_);
    }

    public static final class Types {
        public static final Type ANY = p_218860_ -> ANY;
        public static final Type LIGHTNING = LighthingBoltPredicate::fromJson;
        public static final Type FISHING_HOOK = FishingHookPredicate::fromJson;
        public static final Type PLAYER = PlayerPredicate::fromJson;
        public static final Type SLIME = SlimePredicate::fromJson;
        public static final EntityVariantPredicate<CatVariant> CAT = EntityVariantPredicate.create(BuiltInRegistries.CAT_VARIANT, p_218862_ -> {
            Optional<Object> optional;
            if (p_218862_ instanceof Cat) {
                Cat cat = (Cat)p_218862_;
                optional = Optional.of(cat.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final EntityVariantPredicate<FrogVariant> FROG = EntityVariantPredicate.create(BuiltInRegistries.FROG_VARIANT, p_218858_ -> {
            Optional<Object> optional;
            if (p_218858_ instanceof Frog) {
                Frog frog = (Frog)p_218858_;
                optional = Optional.of(frog.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final EntityVariantPredicate<Axolotl.Variant> AXOLOTL = EntityVariantPredicate.create(Axolotl.Variant.CODEC, p_262508_ -> {
            Optional<Object> optional;
            if (p_262508_ instanceof Axolotl) {
                Axolotl axolotl = (Axolotl)p_262508_;
                optional = Optional.of(axolotl.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final EntityVariantPredicate<Boat.Type> BOAT = EntityVariantPredicate.create(Boat.Type.CODEC, p_262507_ -> {
            Optional<Object> optional;
            if (p_262507_ instanceof Boat) {
                Boat boat = (Boat)p_262507_;
                optional = Optional.of(boat.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final EntityVariantPredicate<Fox.Type> FOX = EntityVariantPredicate.create(Fox.Type.CODEC, p_262510_ -> {
            Optional<Object> optional;
            if (p_262510_ instanceof Fox) {
                Fox fox = (Fox)p_262510_;
                optional = Optional.of(fox.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final EntityVariantPredicate<MushroomCow.MushroomType> MOOSHROOM = EntityVariantPredicate.create(MushroomCow.MushroomType.CODEC, p_262513_ -> {
            Optional<Object> optional;
            if (p_262513_ instanceof MushroomCow) {
                MushroomCow mushroomcow = (MushroomCow)p_262513_;
                optional = Optional.of(mushroomcow.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final EntityVariantPredicate<Holder<PaintingVariant>> PAINTING = EntityVariantPredicate.create(BuiltInRegistries.PAINTING_VARIANT.holderByNameCodec(), p_262509_ -> {
            Optional<Object> optional;
            if (p_262509_ instanceof Painting) {
                Painting painting = (Painting)p_262509_;
                optional = Optional.of(painting.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final EntityVariantPredicate<Rabbit.Variant> RABBIT = EntityVariantPredicate.create(Rabbit.Variant.CODEC, p_262511_ -> {
            Optional<Object> optional;
            if (p_262511_ instanceof Rabbit) {
                Rabbit rabbit = (Rabbit)p_262511_;
                optional = Optional.of(rabbit.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final EntityVariantPredicate<Variant> HORSE = EntityVariantPredicate.create(Variant.CODEC, p_262516_ -> {
            Optional<Object> optional;
            if (p_262516_ instanceof Horse) {
                Horse horse = (Horse)p_262516_;
                optional = Optional.of(horse.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final EntityVariantPredicate<Llama.Variant> LLAMA = EntityVariantPredicate.create(Llama.Variant.CODEC, p_262515_ -> {
            Optional<Object> optional;
            if (p_262515_ instanceof Llama) {
                Llama llama = (Llama)p_262515_;
                optional = Optional.of(llama.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final EntityVariantPredicate<VillagerType> VILLAGER = EntityVariantPredicate.create(BuiltInRegistries.VILLAGER_TYPE.byNameCodec(), p_262512_ -> {
            Optional<Object> optional;
            if (p_262512_ instanceof VillagerDataHolder) {
                VillagerDataHolder villagerdataholder = (VillagerDataHolder)((Object)p_262512_);
                optional = Optional.of(villagerdataholder.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final EntityVariantPredicate<Parrot.Variant> PARROT = EntityVariantPredicate.create(Parrot.Variant.CODEC, p_262506_ -> {
            Optional<Object> optional;
            if (p_262506_ instanceof Parrot) {
                Parrot parrot = (Parrot)p_262506_;
                optional = Optional.of(parrot.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final EntityVariantPredicate<TropicalFish.Pattern> TROPICAL_FISH = EntityVariantPredicate.create(TropicalFish.Pattern.CODEC, p_262517_ -> {
            Optional<Object> optional;
            if (p_262517_ instanceof TropicalFish) {
                TropicalFish tropicalfish = (TropicalFish)p_262517_;
                optional = Optional.of(tropicalfish.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final BiMap<String, Type> TYPES = ImmutableBiMap.builder().put((Object)"any", (Object)ANY).put((Object)"lightning", (Object)LIGHTNING).put((Object)"fishing_hook", (Object)FISHING_HOOK).put((Object)"player", (Object)PLAYER).put((Object)"slime", (Object)SLIME).put((Object)"cat", (Object)CAT.type()).put((Object)"frog", (Object)FROG.type()).put((Object)"axolotl", (Object)AXOLOTL.type()).put((Object)"boat", (Object)BOAT.type()).put((Object)"fox", (Object)FOX.type()).put((Object)"mooshroom", (Object)MOOSHROOM.type()).put((Object)"painting", (Object)PAINTING.type()).put((Object)"rabbit", (Object)RABBIT.type()).put((Object)"horse", (Object)HORSE.type()).put((Object)"llama", (Object)LLAMA.type()).put((Object)"villager", (Object)VILLAGER.type()).put((Object)"parrot", (Object)PARROT.type()).put((Object)"tropical_fish", (Object)TROPICAL_FISH.type()).buildOrThrow();
    }

    public static interface Type {
        public EntitySubPredicate deserialize(JsonObject var1);
    }
}

