/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class EntityVariantPredicate<V> {
    private static final String VARIANT_KEY = "variant";
    final Codec<V> variantCodec;
    final Function<Entity, Optional<V>> getter;
    final EntitySubPredicate.Type type;

    public static <V> EntityVariantPredicate<V> create(Registry<V> p_219094_, Function<Entity, Optional<V>> p_219095_) {
        return new EntityVariantPredicate<V>(p_219094_.byNameCodec(), p_219095_);
    }

    public static <V> EntityVariantPredicate<V> create(Codec<V> p_262671_, Function<Entity, Optional<V>> p_262652_) {
        return new EntityVariantPredicate<V>(p_262671_, p_262652_);
    }

    private EntityVariantPredicate(Codec<V> p_262574_, Function<Entity, Optional<V>> p_262610_) {
        this.variantCodec = p_262574_;
        this.getter = p_262610_;
        this.type = p_262519_ -> {
            JsonElement jsonelement = p_262519_.get(VARIANT_KEY);
            if (jsonelement == null) {
                throw new JsonParseException("Missing variant field");
            }
            Object v = ((Pair)Util.getOrThrow(p_262574_.decode(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)jsonelement)), JsonParseException::new)).getFirst();
            return this.createPredicate(v);
        };
    }

    public EntitySubPredicate.Type type() {
        return this.type;
    }

    public EntitySubPredicate createPredicate(final V p_219097_) {
        return new EntitySubPredicate(){

            @Override
            public boolean matches(Entity p_219105_, ServerLevel p_219106_, @Nullable Vec3 p_219107_) {
                return EntityVariantPredicate.this.getter.apply(p_219105_).filter(p_219110_ -> p_219110_.equals(p_219097_)).isPresent();
            }

            @Override
            public JsonObject serializeCustomData() {
                JsonObject jsonobject = new JsonObject();
                jsonobject.add(EntityVariantPredicate.VARIANT_KEY, (JsonElement)Util.getOrThrow(EntityVariantPredicate.this.variantCodec.encodeStart((DynamicOps)JsonOps.INSTANCE, p_219097_), p_262521_ -> new JsonParseException("Can't serialize variant " + String.valueOf(p_219097_) + ", message " + p_262521_)));
                return jsonobject;
            }

            @Override
            public EntitySubPredicate.Type type() {
                return EntityVariantPredicate.this.type;
            }
        };
    }
}

