/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;

public class KilledTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    final ResourceLocation id;

    public KilledTrigger(ResourceLocation p_48102_) {
        this.id = p_48102_;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public TriggerInstance createInstance(JsonObject p_286718_, ContextAwarePredicate p_286909_, DeserializationContext p_286514_) {
        return new TriggerInstance(this.id, p_286909_, EntityPredicate.fromJson(p_286718_, "entity", p_286514_), DamageSourcePredicate.fromJson(p_286718_.get("killing_blow")));
    }

    public void trigger(ServerPlayer p_48105_, Entity p_48106_, DamageSource p_48107_) {
        LootContext lootcontext = EntityPredicate.createContext(p_48105_, p_48106_);
        this.trigger(p_48105_, p_48112_ -> p_48112_.matches(p_48105_, lootcontext, p_48107_));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final ContextAwarePredicate entityPredicate;
        private final DamageSourcePredicate killingBlow;

        public TriggerInstance(ResourceLocation p_286471_, ContextAwarePredicate p_286673_, ContextAwarePredicate p_286390_, DamageSourcePredicate p_286643_) {
            super(p_286471_, p_286673_);
            this.entityPredicate = p_286390_;
            this.killingBlow = p_286643_;
        }

        public static TriggerInstance playerKilledEntity(EntityPredicate p_152109_) {
            return new TriggerInstance(CriteriaTriggers.PLAYER_KILLED_ENTITY.id, ContextAwarePredicate.ANY, EntityPredicate.wrap(p_152109_), DamageSourcePredicate.ANY);
        }

        public static TriggerInstance playerKilledEntity(EntityPredicate.Builder p_48135_) {
            return new TriggerInstance(CriteriaTriggers.PLAYER_KILLED_ENTITY.id, ContextAwarePredicate.ANY, EntityPredicate.wrap(p_48135_.build()), DamageSourcePredicate.ANY);
        }

        public static TriggerInstance playerKilledEntity() {
            return new TriggerInstance(CriteriaTriggers.PLAYER_KILLED_ENTITY.id, ContextAwarePredicate.ANY, ContextAwarePredicate.ANY, DamageSourcePredicate.ANY);
        }

        public static TriggerInstance playerKilledEntity(EntityPredicate p_152114_, DamageSourcePredicate p_152115_) {
            return new TriggerInstance(CriteriaTriggers.PLAYER_KILLED_ENTITY.id, ContextAwarePredicate.ANY, EntityPredicate.wrap(p_152114_), p_152115_);
        }

        public static TriggerInstance playerKilledEntity(EntityPredicate.Builder p_152106_, DamageSourcePredicate p_152107_) {
            return new TriggerInstance(CriteriaTriggers.PLAYER_KILLED_ENTITY.id, ContextAwarePredicate.ANY, EntityPredicate.wrap(p_152106_.build()), p_152107_);
        }

        public static TriggerInstance playerKilledEntity(EntityPredicate p_152111_, DamageSourcePredicate.Builder p_152112_) {
            return new TriggerInstance(CriteriaTriggers.PLAYER_KILLED_ENTITY.id, ContextAwarePredicate.ANY, EntityPredicate.wrap(p_152111_), p_152112_.build());
        }

        public static TriggerInstance playerKilledEntity(EntityPredicate.Builder p_48137_, DamageSourcePredicate.Builder p_48138_) {
            return new TriggerInstance(CriteriaTriggers.PLAYER_KILLED_ENTITY.id, ContextAwarePredicate.ANY, EntityPredicate.wrap(p_48137_.build()), p_48138_.build());
        }

        public static TriggerInstance playerKilledEntityNearSculkCatalyst() {
            return new TriggerInstance(CriteriaTriggers.KILL_MOB_NEAR_SCULK_CATALYST.id, ContextAwarePredicate.ANY, ContextAwarePredicate.ANY, DamageSourcePredicate.ANY);
        }

        public static TriggerInstance entityKilledPlayer(EntityPredicate p_152125_) {
            return new TriggerInstance(CriteriaTriggers.ENTITY_KILLED_PLAYER.id, ContextAwarePredicate.ANY, EntityPredicate.wrap(p_152125_), DamageSourcePredicate.ANY);
        }

        public static TriggerInstance entityKilledPlayer(EntityPredicate.Builder p_152117_) {
            return new TriggerInstance(CriteriaTriggers.ENTITY_KILLED_PLAYER.id, ContextAwarePredicate.ANY, EntityPredicate.wrap(p_152117_.build()), DamageSourcePredicate.ANY);
        }

        public static TriggerInstance entityKilledPlayer() {
            return new TriggerInstance(CriteriaTriggers.ENTITY_KILLED_PLAYER.id, ContextAwarePredicate.ANY, ContextAwarePredicate.ANY, DamageSourcePredicate.ANY);
        }

        public static TriggerInstance entityKilledPlayer(EntityPredicate p_152130_, DamageSourcePredicate p_152131_) {
            return new TriggerInstance(CriteriaTriggers.ENTITY_KILLED_PLAYER.id, ContextAwarePredicate.ANY, EntityPredicate.wrap(p_152130_), p_152131_);
        }

        public static TriggerInstance entityKilledPlayer(EntityPredicate.Builder p_152122_, DamageSourcePredicate p_152123_) {
            return new TriggerInstance(CriteriaTriggers.ENTITY_KILLED_PLAYER.id, ContextAwarePredicate.ANY, EntityPredicate.wrap(p_152122_.build()), p_152123_);
        }

        public static TriggerInstance entityKilledPlayer(EntityPredicate p_152127_, DamageSourcePredicate.Builder p_152128_) {
            return new TriggerInstance(CriteriaTriggers.ENTITY_KILLED_PLAYER.id, ContextAwarePredicate.ANY, EntityPredicate.wrap(p_152127_), p_152128_.build());
        }

        public static TriggerInstance entityKilledPlayer(EntityPredicate.Builder p_152119_, DamageSourcePredicate.Builder p_152120_) {
            return new TriggerInstance(CriteriaTriggers.ENTITY_KILLED_PLAYER.id, ContextAwarePredicate.ANY, EntityPredicate.wrap(p_152119_.build()), p_152120_.build());
        }

        public boolean matches(ServerPlayer p_48131_, LootContext p_48132_, DamageSource p_48133_) {
            return !this.killingBlow.matches(p_48131_, p_48133_) ? false : this.entityPredicate.matches(p_48132_);
        }

        @Override
        public JsonObject serializeToJson(SerializationContext p_48140_) {
            JsonObject jsonobject = super.serializeToJson(p_48140_);
            jsonobject.add("entity", this.entityPredicate.toJson(p_48140_));
            jsonobject.add("killing_blow", this.killingBlow.serializeToJson());
            return jsonobject;
        }
    }
}

