/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.BuiltInExceptionProvider;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;

public abstract class MinMaxBounds<T extends Number> {
    public static final SimpleCommandExceptionType ERROR_EMPTY = new SimpleCommandExceptionType((Message)Component.translatable("argument.range.empty"));
    public static final SimpleCommandExceptionType ERROR_SWAPPED = new SimpleCommandExceptionType((Message)Component.translatable("argument.range.swapped"));
    @Nullable
    protected final T min;
    @Nullable
    protected final T max;

    protected MinMaxBounds(@Nullable T p_55303_, @Nullable T p_55304_) {
        this.min = p_55303_;
        this.max = p_55304_;
    }

    @Nullable
    public T getMin() {
        return this.min;
    }

    @Nullable
    public T getMax() {
        return this.max;
    }

    public boolean isAny() {
        return this.min == null && this.max == null;
    }

    public JsonElement serializeToJson() {
        if (this.isAny()) {
            return JsonNull.INSTANCE;
        }
        if (this.min != null && this.min.equals(this.max)) {
            return new JsonPrimitive(this.min);
        }
        JsonObject jsonobject = new JsonObject();
        if (this.min != null) {
            jsonobject.addProperty("min", this.min);
        }
        if (this.max != null) {
            jsonobject.addProperty("max", this.max);
        }
        return jsonobject;
    }

    protected static <T extends Number, R extends MinMaxBounds<T>> R fromJson(@Nullable JsonElement p_55307_, R p_55308_, BiFunction<JsonElement, String, T> p_55309_, BoundsFactory<T, R> p_55310_) {
        if (p_55307_ != null && !p_55307_.isJsonNull()) {
            if (GsonHelper.isNumberValue(p_55307_)) {
                Number t2 = (Number)p_55309_.apply(p_55307_, "value");
                return p_55310_.create(t2, t2);
            }
            JsonObject jsonobject = GsonHelper.convertToJsonObject(p_55307_, "value");
            Number t = jsonobject.has("min") ? (Number)((Number)p_55309_.apply(jsonobject.get("min"), "min")) : (Number)null;
            Number t1 = jsonobject.has("max") ? (Number)((Number)p_55309_.apply(jsonobject.get("max"), "max")) : (Number)null;
            return p_55310_.create(t, t1);
        }
        return p_55308_;
    }

    protected static <T extends Number, R extends MinMaxBounds<T>> R fromReader(StringReader p_55314_, BoundsFromReaderFactory<T, R> p_55315_, Function<String, T> p_55316_, Supplier<DynamicCommandExceptionType> p_55317_, Function<T, T> p_55318_) throws CommandSyntaxException {
        if (!p_55314_.canRead()) {
            throw ERROR_EMPTY.createWithContext((ImmutableStringReader)p_55314_);
        }
        int i = p_55314_.getCursor();
        try {
            Number t1;
            Number t = (Number)MinMaxBounds.optionallyFormat(MinMaxBounds.readNumber(p_55314_, p_55316_, p_55317_), p_55318_);
            if (p_55314_.canRead(2) && p_55314_.peek() == '.' && p_55314_.peek(1) == '.') {
                p_55314_.skip();
                p_55314_.skip();
                t1 = (Number)MinMaxBounds.optionallyFormat(MinMaxBounds.readNumber(p_55314_, p_55316_, p_55317_), p_55318_);
                if (t == null && t1 == null) {
                    throw ERROR_EMPTY.createWithContext((ImmutableStringReader)p_55314_);
                }
            } else {
                t1 = t;
            }
            if (t == null && t1 == null) {
                throw ERROR_EMPTY.createWithContext((ImmutableStringReader)p_55314_);
            }
            return p_55315_.create(p_55314_, t, t1);
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            p_55314_.setCursor(i);
            throw new CommandSyntaxException(commandsyntaxexception.getType(), commandsyntaxexception.getRawMessage(), commandsyntaxexception.getInput(), i);
        }
    }

    @Nullable
    private static <T extends Number> T readNumber(StringReader p_55320_, Function<String, T> p_55321_, Supplier<DynamicCommandExceptionType> p_55322_) throws CommandSyntaxException {
        int i = p_55320_.getCursor();
        while (p_55320_.canRead() && MinMaxBounds.isAllowedInputChat(p_55320_)) {
            p_55320_.skip();
        }
        String s = p_55320_.getString().substring(i, p_55320_.getCursor());
        if (s.isEmpty()) {
            return (T)((Number)null);
        }
        try {
            return (T)((Number)p_55321_.apply(s));
        }
        catch (NumberFormatException numberformatexception) {
            throw p_55322_.get().createWithContext((ImmutableStringReader)p_55320_, (Object)s);
        }
    }

    private static boolean isAllowedInputChat(StringReader p_55312_) {
        char c0 = p_55312_.peek();
        if ((c0 < '0' || c0 > '9') && c0 != '-') {
            if (c0 != '.') {
                return false;
            }
            return !p_55312_.canRead(2) || p_55312_.peek(1) != '.';
        }
        return true;
    }

    @Nullable
    private static <T> T optionallyFormat(@Nullable T p_55324_, Function<T, T> p_55325_) {
        return p_55324_ == null ? null : (T)p_55325_.apply(p_55324_);
    }

    @FunctionalInterface
    protected static interface BoundsFactory<T extends Number, R extends MinMaxBounds<T>> {
        public R create(@Nullable T var1, @Nullable T var2);
    }

    @FunctionalInterface
    protected static interface BoundsFromReaderFactory<T extends Number, R extends MinMaxBounds<T>> {
        public R create(StringReader var1, @Nullable T var2, @Nullable T var3) throws CommandSyntaxException;
    }

    public static class Ints
    extends MinMaxBounds<Integer> {
        public static final Ints ANY = new Ints((Integer)null, (Integer)null);
        @Nullable
        private final Long minSq;
        @Nullable
        private final Long maxSq;

        private static Ints create(StringReader p_55378_, @Nullable Integer p_55379_, @Nullable Integer p_55380_) throws CommandSyntaxException {
            if (p_55379_ != null && p_55380_ != null && p_55379_ > p_55380_) {
                throw ERROR_SWAPPED.createWithContext((ImmutableStringReader)p_55378_);
            }
            return new Ints(p_55379_, p_55380_);
        }

        @Nullable
        private static Long squareOpt(@Nullable Integer p_55385_) {
            return p_55385_ == null ? null : Long.valueOf(p_55385_.longValue() * p_55385_.longValue());
        }

        private Ints(@Nullable Integer p_55369_, @Nullable Integer p_55370_) {
            super(p_55369_, p_55370_);
            this.minSq = Ints.squareOpt(p_55369_);
            this.maxSq = Ints.squareOpt(p_55370_);
        }

        public static Ints exactly(int p_55372_) {
            return new Ints(p_55372_, p_55372_);
        }

        public static Ints between(int p_154815_, int p_154816_) {
            return new Ints(p_154815_, p_154816_);
        }

        public static Ints atLeast(int p_55387_) {
            return new Ints(p_55387_, (Integer)null);
        }

        public static Ints atMost(int p_154820_) {
            return new Ints((Integer)null, p_154820_);
        }

        public boolean matches(int p_55391_) {
            if (this.min != null && (Integer)this.min > p_55391_) {
                return false;
            }
            return this.max == null || (Integer)this.max >= p_55391_;
        }

        public boolean matchesSqr(long p_154818_) {
            if (this.minSq != null && this.minSq > p_154818_) {
                return false;
            }
            return this.maxSq == null || this.maxSq >= p_154818_;
        }

        public static Ints fromJson(@Nullable JsonElement p_55374_) {
            return Ints.fromJson(p_55374_, ANY, GsonHelper::convertToInt, Ints::new);
        }

        public static Ints fromReader(StringReader p_55376_) throws CommandSyntaxException {
            return Ints.fromReader(p_55376_, p_55389_ -> p_55389_);
        }

        public static Ints fromReader(StringReader p_55382_, Function<Integer, Integer> p_55383_) throws CommandSyntaxException {
            return Ints.fromReader(p_55382_, Ints::create, Integer::parseInt, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidInt(), p_55383_);
        }
    }

    public static class Doubles
    extends MinMaxBounds<Double> {
        public static final Doubles ANY = new Doubles((Double)null, (Double)null);
        @Nullable
        private final Double minSq;
        @Nullable
        private final Double maxSq;

        private static Doubles create(StringReader p_154796_, @Nullable Double p_154797_, @Nullable Double p_154798_) throws CommandSyntaxException {
            if (p_154797_ != null && p_154798_ != null && p_154797_ > p_154798_) {
                throw ERROR_SWAPPED.createWithContext((ImmutableStringReader)p_154796_);
            }
            return new Doubles(p_154797_, p_154798_);
        }

        @Nullable
        private static Double squareOpt(@Nullable Double p_154803_) {
            return p_154803_ == null ? null : Double.valueOf(p_154803_ * p_154803_);
        }

        private Doubles(@Nullable Double p_154784_, @Nullable Double p_154785_) {
            super(p_154784_, p_154785_);
            this.minSq = Doubles.squareOpt(p_154784_);
            this.maxSq = Doubles.squareOpt(p_154785_);
        }

        public static Doubles exactly(double p_154787_) {
            return new Doubles(p_154787_, p_154787_);
        }

        public static Doubles between(double p_154789_, double p_154790_) {
            return new Doubles(p_154789_, p_154790_);
        }

        public static Doubles atLeast(double p_154805_) {
            return new Doubles(p_154805_, (Double)null);
        }

        public static Doubles atMost(double p_154809_) {
            return new Doubles((Double)null, p_154809_);
        }

        public boolean matches(double p_154811_) {
            if (this.min != null && (Double)this.min > p_154811_) {
                return false;
            }
            return this.max == null || !((Double)this.max < p_154811_);
        }

        public boolean matchesSqr(double p_154813_) {
            if (this.minSq != null && this.minSq > p_154813_) {
                return false;
            }
            return this.maxSq == null || !(this.maxSq < p_154813_);
        }

        public static Doubles fromJson(@Nullable JsonElement p_154792_) {
            return Doubles.fromJson(p_154792_, ANY, GsonHelper::convertToDouble, Doubles::new);
        }

        public static Doubles fromReader(StringReader p_154794_) throws CommandSyntaxException {
            return Doubles.fromReader(p_154794_, p_154807_ -> p_154807_);
        }

        public static Doubles fromReader(StringReader p_154800_, Function<Double, Double> p_154801_) throws CommandSyntaxException {
            return Doubles.fromReader(p_154800_, Doubles::create, Double::parseDouble, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidDouble(), p_154801_);
        }
    }
}

