/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class MobEffectsPredicate {
    public static final MobEffectsPredicate ANY = new MobEffectsPredicate(Collections.emptyMap());
    private final Map<MobEffect, MobEffectInstancePredicate> effects;

    public MobEffectsPredicate(Map<MobEffect, MobEffectInstancePredicate> p_56551_) {
        this.effects = p_56551_;
    }

    public static MobEffectsPredicate effects() {
        return new MobEffectsPredicate(Maps.newLinkedHashMap());
    }

    public MobEffectsPredicate and(MobEffect p_56554_) {
        this.effects.put(p_56554_, new MobEffectInstancePredicate());
        return this;
    }

    public MobEffectsPredicate and(MobEffect p_154978_, MobEffectInstancePredicate p_154979_) {
        this.effects.put(p_154978_, p_154979_);
        return this;
    }

    public boolean matches(Entity p_56556_) {
        if (this == ANY) {
            return true;
        }
        return p_56556_ instanceof LivingEntity ? this.matches(((LivingEntity)p_56556_).getActiveEffectsMap()) : false;
    }

    public boolean matches(LivingEntity p_56558_) {
        return this == ANY ? true : this.matches(p_56558_.getActiveEffectsMap());
    }

    public boolean matches(Map<MobEffect, MobEffectInstance> p_56562_) {
        if (this == ANY) {
            return true;
        }
        for (Map.Entry<MobEffect, MobEffectInstancePredicate> entry : this.effects.entrySet()) {
            MobEffectInstance mobeffectinstance = p_56562_.get(entry.getKey());
            if (entry.getValue().matches(mobeffectinstance)) continue;
            return false;
        }
        return true;
    }

    public static MobEffectsPredicate fromJson(@Nullable JsonElement p_56560_) {
        if (p_56560_ != null && !p_56560_.isJsonNull()) {
            JsonObject jsonobject = GsonHelper.convertToJsonObject(p_56560_, "effects");
            LinkedHashMap map = Maps.newLinkedHashMap();
            for (Map.Entry entry : jsonobject.entrySet()) {
                ResourceLocation resourcelocation = new ResourceLocation((String)entry.getKey());
                MobEffect mobeffect = BuiltInRegistries.MOB_EFFECT.getOptional(resourcelocation).orElseThrow(() -> new JsonSyntaxException("Unknown effect '" + String.valueOf(resourcelocation) + "'"));
                MobEffectInstancePredicate mobeffectspredicate$mobeffectinstancepredicate = MobEffectInstancePredicate.fromJson(GsonHelper.convertToJsonObject((JsonElement)entry.getValue(), (String)entry.getKey()));
                map.put(mobeffect, mobeffectspredicate$mobeffectinstancepredicate);
            }
            return new MobEffectsPredicate(map);
        }
        return ANY;
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonobject = new JsonObject();
        for (Map.Entry<MobEffect, MobEffectInstancePredicate> entry : this.effects.entrySet()) {
            jsonobject.add(BuiltInRegistries.MOB_EFFECT.getKey(entry.getKey()).toString(), entry.getValue().serializeToJson());
        }
        return jsonobject;
    }

    public static class MobEffectInstancePredicate {
        private final MinMaxBounds.Ints amplifier;
        private final MinMaxBounds.Ints duration;
        @Nullable
        private final Boolean ambient;
        @Nullable
        private final Boolean visible;

        public MobEffectInstancePredicate(MinMaxBounds.Ints p_56572_, MinMaxBounds.Ints p_56573_, @Nullable Boolean p_56574_, @Nullable Boolean p_56575_) {
            this.amplifier = p_56572_;
            this.duration = p_56573_;
            this.ambient = p_56574_;
            this.visible = p_56575_;
        }

        public MobEffectInstancePredicate() {
            this(MinMaxBounds.Ints.ANY, MinMaxBounds.Ints.ANY, null, null);
        }

        public boolean matches(@Nullable MobEffectInstance p_56578_) {
            if (p_56578_ == null) {
                return false;
            }
            if (!this.amplifier.matches(p_56578_.getAmplifier())) {
                return false;
            }
            if (!this.duration.matches(p_56578_.getDuration())) {
                return false;
            }
            if (this.ambient != null && this.ambient.booleanValue() != p_56578_.isAmbient()) {
                return false;
            }
            return this.visible == null || this.visible.booleanValue() == p_56578_.isVisible();
        }

        public JsonElement serializeToJson() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.add("amplifier", this.amplifier.serializeToJson());
            jsonobject.add("duration", this.duration.serializeToJson());
            jsonobject.addProperty("ambient", this.ambient);
            jsonobject.addProperty("visible", this.visible);
            return jsonobject;
        }

        public static MobEffectInstancePredicate fromJson(JsonObject p_56580_) {
            MinMaxBounds.Ints minmaxbounds$ints = MinMaxBounds.Ints.fromJson(p_56580_.get("amplifier"));
            MinMaxBounds.Ints minmaxbounds$ints1 = MinMaxBounds.Ints.fromJson(p_56580_.get("duration"));
            Boolean obool = p_56580_.has("ambient") ? Boolean.valueOf(GsonHelper.getAsBoolean(p_56580_, "ambient")) : null;
            Boolean obool1 = p_56580_.has("visible") ? Boolean.valueOf(GsonHelper.getAsBoolean(p_56580_, "visible")) : null;
            return new MobEffectInstancePredicate(minmaxbounds$ints, minmaxbounds$ints1, obool, obool1);
        }
    }
}

