/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class SlideDownBlockTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("slide_down_block");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public TriggerInstance createInstance(JsonObject p_286879_, ContextAwarePredicate p_286565_, DeserializationContext p_286581_) {
        Block block = SlideDownBlockTrigger.deserializeBlock(p_286879_);
        StatePropertiesPredicate statepropertiespredicate = StatePropertiesPredicate.fromJson(p_286879_.get("state"));
        if (block != null) {
            statepropertiespredicate.checkState(block.getStateDefinition(), p_66983_ -> {
                throw new JsonSyntaxException("Block " + String.valueOf(block) + " has no property " + p_66983_);
            });
        }
        return new TriggerInstance(p_286565_, block, statepropertiespredicate);
    }

    @Nullable
    private static Block deserializeBlock(JsonObject p_66988_) {
        if (p_66988_.has("block")) {
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.getAsString(p_66988_, "block"));
            return (Block)BuiltInRegistries.BLOCK.getOptional(resourcelocation).orElseThrow(() -> new JsonSyntaxException("Unknown block type '" + String.valueOf(resourcelocation) + "'"));
        }
        return null;
    }

    public void trigger(ServerPlayer p_66979_, BlockState p_66980_) {
        this.trigger(p_66979_, (T p_66986_) -> p_66986_.matches(p_66980_));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        @Nullable
        private final Block block;
        private final StatePropertiesPredicate state;

        public TriggerInstance(ContextAwarePredicate p_286920_, @Nullable Block p_286622_, StatePropertiesPredicate p_286692_) {
            super(ID, p_286920_);
            this.block = p_286622_;
            this.state = p_286692_;
        }

        public static TriggerInstance slidesDownBlock(Block p_67007_) {
            return new TriggerInstance(ContextAwarePredicate.ANY, p_67007_, StatePropertiesPredicate.ANY);
        }

        @Override
        public JsonObject serializeToJson(SerializationContext p_67011_) {
            JsonObject jsonobject = super.serializeToJson(p_67011_);
            if (this.block != null) {
                jsonobject.addProperty("block", BuiltInRegistries.BLOCK.getKey(this.block).toString());
            }
            jsonobject.add("state", this.state.serializeToJson());
            return jsonobject;
        }

        public boolean matches(BlockState p_67009_) {
            if (this.block != null && !p_67009_.is(this.block)) {
                return false;
            }
            return this.state.matches(p_67009_);
        }
    }
}

