/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;

public class StatePropertiesPredicate {
    public static final StatePropertiesPredicate ANY = new StatePropertiesPredicate((List<PropertyMatcher>)ImmutableList.of());
    private final List<PropertyMatcher> properties;

    private static PropertyMatcher fromJson(String p_67687_, JsonElement p_67688_) {
        if (p_67688_.isJsonPrimitive()) {
            String s2 = p_67688_.getAsString();
            return new ExactPropertyMatcher(p_67687_, s2);
        }
        JsonObject jsonobject = GsonHelper.convertToJsonObject(p_67688_, "value");
        String s = jsonobject.has("min") ? StatePropertiesPredicate.getStringOrNull(jsonobject.get("min")) : null;
        String s1 = jsonobject.has("max") ? StatePropertiesPredicate.getStringOrNull(jsonobject.get("max")) : null;
        return s != null && s.equals(s1) ? new ExactPropertyMatcher(p_67687_, s) : new RangedPropertyMatcher(p_67687_, s, s1);
    }

    @Nullable
    private static String getStringOrNull(JsonElement p_67690_) {
        return p_67690_.isJsonNull() ? null : p_67690_.getAsString();
    }

    StatePropertiesPredicate(List<PropertyMatcher> p_67662_) {
        this.properties = ImmutableList.copyOf(p_67662_);
    }

    public <S extends StateHolder<?, S>> boolean matches(StateDefinition<?, S> p_67670_, S p_67671_) {
        for (PropertyMatcher statepropertiespredicate$propertymatcher : this.properties) {
            if (statepropertiespredicate$propertymatcher.match(p_67670_, p_67671_)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(BlockState p_67668_) {
        return this.matches(p_67668_.getBlock().getStateDefinition(), p_67668_);
    }

    public boolean matches(FluidState p_67685_) {
        return this.matches(p_67685_.getType().getStateDefinition(), p_67685_);
    }

    public void checkState(StateDefinition<?, ?> p_67673_, Consumer<String> p_67674_) {
        this.properties.forEach(p_67678_ -> p_67678_.checkState(p_67673_, p_67674_));
    }

    public static StatePropertiesPredicate fromJson(@Nullable JsonElement p_67680_) {
        if (p_67680_ != null && !p_67680_.isJsonNull()) {
            JsonObject jsonobject = GsonHelper.convertToJsonObject(p_67680_, "properties");
            ArrayList list = Lists.newArrayList();
            for (Map.Entry entry : jsonobject.entrySet()) {
                list.add(StatePropertiesPredicate.fromJson((String)entry.getKey(), (JsonElement)entry.getValue()));
            }
            return new StatePropertiesPredicate(list);
        }
        return ANY;
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonobject = new JsonObject();
        if (!this.properties.isEmpty()) {
            this.properties.forEach(p_67683_ -> jsonobject.add(p_67683_.getName(), p_67683_.toJson()));
        }
        return jsonobject;
    }

    static class ExactPropertyMatcher
    extends PropertyMatcher {
        private final String value;

        public ExactPropertyMatcher(String p_67709_, String p_67710_) {
            super(p_67709_);
            this.value = p_67710_;
        }

        @Override
        protected <T extends Comparable<T>> boolean match(StateHolder<?, ?> p_67713_, Property<T> p_67714_) {
            Comparable t = p_67713_.getValue(p_67714_);
            Optional<T> optional = p_67714_.getValue(this.value);
            return optional.isPresent() && t.compareTo((Comparable)((Comparable)optional.get())) == 0;
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive(this.value);
        }
    }

    static class RangedPropertyMatcher
    extends PropertyMatcher {
        @Nullable
        private final String minValue;
        @Nullable
        private final String maxValue;

        public RangedPropertyMatcher(String p_67730_, @Nullable String p_67731_, @Nullable String p_67732_) {
            super(p_67730_);
            this.minValue = p_67731_;
            this.maxValue = p_67732_;
        }

        @Override
        protected <T extends Comparable<T>> boolean match(StateHolder<?, ?> p_67735_, Property<T> p_67736_) {
            Optional<T> optional1;
            Optional<T> optional;
            Comparable t = p_67735_.getValue(p_67736_);
            if (!(this.minValue == null || (optional = p_67736_.getValue(this.minValue)).isPresent() && t.compareTo((Comparable)((Comparable)optional.get())) >= 0)) {
                return false;
            }
            return this.maxValue == null || (optional1 = p_67736_.getValue(this.maxValue)).isPresent() && t.compareTo((Comparable)((Comparable)optional1.get())) <= 0;
        }

        @Override
        public JsonElement toJson() {
            JsonObject jsonobject = new JsonObject();
            if (this.minValue != null) {
                jsonobject.addProperty("min", this.minValue);
            }
            if (this.maxValue != null) {
                jsonobject.addProperty("max", this.maxValue);
            }
            return jsonobject;
        }
    }

    static abstract class PropertyMatcher {
        private final String name;

        public PropertyMatcher(String p_67717_) {
            this.name = p_67717_;
        }

        public <S extends StateHolder<?, S>> boolean match(StateDefinition<?, S> p_67719_, S p_67720_) {
            Property<?> property = p_67719_.getProperty(this.name);
            return property == null ? false : this.match(p_67720_, property);
        }

        protected abstract <T extends Comparable<T>> boolean match(StateHolder<?, ?> var1, Property<T> var2);

        public abstract JsonElement toJson();

        public String getName() {
            return this.name;
        }

        public void checkState(StateDefinition<?, ?> p_67722_, Consumer<String> p_67723_) {
            Property<?> property = p_67722_.getProperty(this.name);
            if (property == null) {
                p_67723_.accept(this.name);
            }
        }
    }

    public static class Builder {
        private final List<PropertyMatcher> matchers = Lists.newArrayList();

        private Builder() {
        }

        public static Builder properties() {
            return new Builder();
        }

        public Builder hasProperty(Property<?> p_67701_, String p_67702_) {
            this.matchers.add(new ExactPropertyMatcher(p_67701_.getName(), p_67702_));
            return this;
        }

        public Builder hasProperty(Property<Integer> p_67695_, int p_67696_) {
            return this.hasProperty((Property)p_67695_, (Comparable<T> & StringRepresentable)Integer.toString(p_67696_));
        }

        public Builder hasProperty(Property<Boolean> p_67704_, boolean p_67705_) {
            return this.hasProperty((Property)p_67704_, (Comparable<T> & StringRepresentable)Boolean.toString(p_67705_));
        }

        public <T extends Comparable<T> & StringRepresentable> Builder hasProperty(Property<T> p_67698_, T p_67699_) {
            return this.hasProperty(p_67698_, (T)((StringRepresentable)p_67699_).getSerializedName());
        }

        public StatePropertiesPredicate build() {
            return new StatePropertiesPredicate(this.matchers);
        }
    }
}

