/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.math.LongMath;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2BooleanFunction;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class PeriodicNotificationManager
extends SimplePreparableReloadListener<Map<String, List<Notification>>>
implements AutoCloseable {
    private static final Codec<Map<String, List<Notification>>> CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)RecordCodecBuilder.create(p_205303_ -> p_205303_.group((App)Codec.LONG.optionalFieldOf("delay", (Object)0L).forGetter(Notification::delay), (App)Codec.LONG.fieldOf("period").forGetter(Notification::period), (App)Codec.STRING.fieldOf("title").forGetter(Notification::title), (App)Codec.STRING.fieldOf("message").forGetter(Notification::message)).apply((Applicative)p_205303_, Notification::new)).listOf());
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ResourceLocation notifications;
    private final Object2BooleanFunction<String> selector;
    @Nullable
    private Timer timer;
    @Nullable
    private NotificationTask notificationTask;

    public PeriodicNotificationManager(ResourceLocation p_205293_, Object2BooleanFunction<String> p_205294_) {
        this.notifications = p_205293_;
        this.selector = p_205294_;
    }

    @Override
    protected Map<String, List<Notification>> prepare(ResourceManager p_205300_, ProfilerFiller p_205301_) {
        Map map;
        block8: {
            BufferedReader reader = p_205300_.openAsReader(this.notifications);
            try {
                map = (Map)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader)).result().orElseThrow();
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    LOGGER.warn("Failed to load {}", (Object)this.notifications, (Object)exception);
                    return ImmutableMap.of();
                }
            }
            ((Reader)reader).close();
        }
        return map;
    }

    @Override
    protected void apply(Map<String, List<Notification>> p_205318_, ResourceManager p_205319_, ProfilerFiller p_205320_) {
        List<Notification> list = p_205318_.entrySet().stream().filter(p_205316_ -> (Boolean)this.selector.apply((Object)((String)p_205316_.getKey()))).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList());
        if (list.isEmpty()) {
            this.stopTimer();
        } else if (list.stream().anyMatch(p_205326_ -> p_205326_.period == 0L)) {
            Util.logAndPauseIfInIde("A periodic notification in " + String.valueOf(this.notifications) + " has a period of zero minutes");
            this.stopTimer();
        } else {
            long i = this.calculateInitialDelay(list);
            long j = this.calculateOptimalPeriod(list, i);
            if (this.timer == null) {
                this.timer = new Timer();
            }
            this.notificationTask = this.notificationTask == null ? new NotificationTask(list, i, j) : this.notificationTask.reset(list, j);
            this.timer.scheduleAtFixedRate((TimerTask)this.notificationTask, TimeUnit.MINUTES.toMillis(i), TimeUnit.MINUTES.toMillis(j));
        }
    }

    @Override
    public void close() {
        this.stopTimer();
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private long calculateOptimalPeriod(List<Notification> p_205313_, long p_205314_) {
        return p_205313_.stream().mapToLong(p_205298_ -> {
            long i = p_205298_.delay - p_205314_;
            return LongMath.gcd((long)i, (long)p_205298_.period);
        }).reduce(LongMath::gcd).orElseThrow(() -> new IllegalStateException("Empty notifications from: " + String.valueOf(this.notifications)));
    }

    private long calculateInitialDelay(List<Notification> p_205311_) {
        return p_205311_.stream().mapToLong(p_205305_ -> p_205305_.delay).min().orElse(0L);
    }

    @OnlyIn(value=Dist.CLIENT)
    static class NotificationTask
    extends TimerTask {
        private final Minecraft minecraft = Minecraft.getInstance();
        private final List<Notification> notifications;
        private final long period;
        private final AtomicLong elapsed;

        public NotificationTask(List<Notification> p_205350_, long p_205351_, long p_205352_) {
            this.notifications = p_205350_;
            this.period = p_205352_;
            this.elapsed = new AtomicLong(p_205351_);
        }

        public NotificationTask reset(List<Notification> p_205357_, long p_205358_) {
            this.cancel();
            return new NotificationTask(p_205357_, this.elapsed.get(), p_205358_);
        }

        @Override
        public void run() {
            long i = this.elapsed.getAndAdd(this.period);
            long j = this.elapsed.get();
            for (Notification periodicnotificationmanager$notification : this.notifications) {
                long l;
                long k;
                if (i < periodicnotificationmanager$notification.delay || (k = i / periodicnotificationmanager$notification.period) == (l = j / periodicnotificationmanager$notification.period)) continue;
                this.minecraft.execute(() -> SystemToast.add(Minecraft.getInstance().getToasts(), SystemToast.SystemToastIds.PERIODIC_NOTIFICATION, Component.translatable(periodicnotificationmanager$notification.title, k), Component.translatable(periodicnotificationmanager$notification.message, k)));
                return;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Notification(long delay, long period, String title, String message) {
        public Notification(long delay, long period, String title, String message) {
            this.delay = delay != 0L ? delay : period;
            this.period = period;
            this.title = title;
            this.message = message;
        }
    }
}

