/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.color.block;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BlockTintCache {
    private static final int MAX_CACHE_ENTRIES = 256;
    private final ThreadLocal<LatestCacheInfo> latestChunkOnThread = ThreadLocal.withInitial(LatestCacheInfo::new);
    private final Long2ObjectLinkedOpenHashMap<CacheData> cache = new Long2ObjectLinkedOpenHashMap(256, 0.25f);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ToIntFunction<BlockPos> source;

    public BlockTintCache(ToIntFunction<BlockPos> p_193811_) {
        this.source = p_193811_;
    }

    public int getColor(BlockPos p_193813_) {
        int k1;
        int i = SectionPos.blockToSectionCoord(p_193813_.getX());
        int j = SectionPos.blockToSectionCoord(p_193813_.getZ());
        LatestCacheInfo blocktintcache$latestcacheinfo = this.latestChunkOnThread.get();
        if (blocktintcache$latestcacheinfo.x != i || blocktintcache$latestcacheinfo.z != j || blocktintcache$latestcacheinfo.cache == null || blocktintcache$latestcacheinfo.cache.isInvalidated()) {
            blocktintcache$latestcacheinfo.x = i;
            blocktintcache$latestcacheinfo.z = j;
            blocktintcache$latestcacheinfo.cache = this.findOrCreateChunkCache(i, j);
        }
        int[] aint = blocktintcache$latestcacheinfo.cache.getLayer(p_193813_.getY());
        int k = p_193813_.getX() & 0xF;
        int l = p_193813_.getZ() & 0xF;
        int i1 = l << 4 | k;
        int j1 = aint[i1];
        if (j1 != -1) {
            return j1;
        }
        aint[i1] = k1 = this.source.applyAsInt(p_193813_);
        return k1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateForChunk(int p_92656_, int p_92657_) {
        try {
            this.lock.writeLock().lock();
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    long k = ChunkPos.asLong(p_92656_ + i, p_92657_ + j);
                    CacheData blocktintcache$cachedata = (CacheData)this.cache.remove(k);
                    if (blocktintcache$cachedata == null) continue;
                    blocktintcache$cachedata.invalidate();
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void invalidateAll() {
        try {
            this.lock.writeLock().lock();
            this.cache.values().forEach(CacheData::invalidate);
            this.cache.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheData findOrCreateChunkCache(int p_193815_, int p_193816_) {
        CacheData blocktintcache$cachedata3;
        long i = ChunkPos.asLong(p_193815_, p_193816_);
        this.lock.readLock().lock();
        try {
            CacheData blocktintcache$cachedata = (CacheData)this.cache.get(i);
            if (blocktintcache$cachedata != null) {
                CacheData cacheData = blocktintcache$cachedata;
                return cacheData;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            CacheData blocktintcache$cachedata2 = (CacheData)this.cache.get(i);
            if (blocktintcache$cachedata2 == null) {
                CacheData blocktintcache$cachedata1;
                blocktintcache$cachedata3 = new CacheData();
                if (this.cache.size() >= 256 && (blocktintcache$cachedata1 = (CacheData)this.cache.removeFirst()) != null) {
                    blocktintcache$cachedata1.invalidate();
                }
                this.cache.put(i, (Object)blocktintcache$cachedata3);
                CacheData cacheData = blocktintcache$cachedata3;
                return cacheData;
            }
            blocktintcache$cachedata3 = blocktintcache$cachedata2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return blocktintcache$cachedata3;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class LatestCacheInfo {
        public int x = Integer.MIN_VALUE;
        public int z = Integer.MIN_VALUE;
        @Nullable
        CacheData cache;

        private LatestCacheInfo() {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class CacheData {
        private final Int2ObjectArrayMap<int[]> cache = new Int2ObjectArrayMap(16);
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private static final int BLOCKS_PER_LAYER = Mth.square(16);
        private volatile boolean invalidated;

        CacheData() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int[] getLayer(int p_193824_) {
            int[] aint1;
            this.lock.readLock().lock();
            try {
                int[] aint = (int[])this.cache.get(p_193824_);
                if (aint != null) {
                    int[] nArray = aint;
                    return nArray;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            this.lock.writeLock().lock();
            try {
                aint1 = (int[])this.cache.computeIfAbsent(p_193824_, p_193826_ -> this.allocateLayer());
            }
            finally {
                this.lock.writeLock().unlock();
            }
            return aint1;
        }

        private int[] allocateLayer() {
            int[] aint = new int[BLOCKS_PER_LAYER];
            Arrays.fill(aint, -1);
            return aint;
        }

        public boolean isInvalidated() {
            return this.invalidated;
        }

        public void invalidate() {
            this.invalidated = true;
        }
    }
}

