/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.font;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.AllMissingGlyphProvider;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.font.providers.GlyphProviderDefinition;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.DependencySorter;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class FontManager
implements PreparableReloadListener,
AutoCloseable {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final String FONTS_PATH = "fonts.json";
    public static final ResourceLocation MISSING_FONT = new ResourceLocation("minecraft", "missing");
    private static final FileToIdConverter FONT_DEFINITIONS = FileToIdConverter.json("font");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final FontSet missingFontSet;
    private final List<GlyphProvider> providersToClose = new ArrayList<GlyphProvider>();
    private final Map<ResourceLocation, FontSet> fontSets = new HashMap<ResourceLocation, FontSet>();
    private final TextureManager textureManager;
    private Map<ResourceLocation, ResourceLocation> renames = ImmutableMap.of();

    public FontManager(TextureManager p_95005_) {
        this.textureManager = p_95005_;
        this.missingFontSet = Util.make(new FontSet(p_95005_, MISSING_FONT), p_95010_ -> p_95010_.reload(Lists.newArrayList((Object[])new GlyphProvider[]{new AllMissingGlyphProvider()})));
    }

    @Override
    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier p_285160_, ResourceManager p_285231_, ProfilerFiller p_285232_, ProfilerFiller p_285262_, Executor p_284975_, Executor p_285218_) {
        p_285232_.startTick();
        p_285232_.endTick();
        return ((CompletableFuture)this.prepare(p_285231_, p_284975_).thenCompose(p_285160_::wait)).thenAcceptAsync(p_284609_ -> this.apply((Preparation)p_284609_, p_285262_), p_285218_);
    }

    private CompletableFuture<Preparation> prepare(ResourceManager p_285252_, Executor p_284969_) {
        ArrayList<CompletableFuture<UnresolvedBuilderBundle>> list = new ArrayList<CompletableFuture<UnresolvedBuilderBundle>>();
        for (Map.Entry<ResourceLocation, List<Resource>> entry : FONT_DEFINITIONS.listMatchingResourceStacks(p_285252_).entrySet()) {
            ResourceLocation resourcelocation = FONT_DEFINITIONS.fileToId(entry.getKey());
            list.add(CompletableFuture.supplyAsync(() -> {
                List<Pair<BuilderId, GlyphProviderDefinition>> list1 = FontManager.loadResourceStack((List)entry.getValue(), resourcelocation);
                UnresolvedBuilderBundle fontmanager$unresolvedbuilderbundle = new UnresolvedBuilderBundle(resourcelocation);
                for (Pair<BuilderId, GlyphProviderDefinition> pair : list1) {
                    BuilderId fontmanager$builderid = (BuilderId)pair.getFirst();
                    ((GlyphProviderDefinition)pair.getSecond()).unpack().ifLeft(p_286126_ -> {
                        CompletableFuture<Optional<GlyphProvider>> completablefuture = this.safeLoad(fontmanager$builderid, (GlyphProviderDefinition.Loader)p_286126_, p_285252_, p_284969_);
                        fontmanager$unresolvedbuilderbundle.add(fontmanager$builderid, completablefuture);
                    }).ifRight(p_286129_ -> fontmanager$unresolvedbuilderbundle.add(fontmanager$builderid, (GlyphProviderDefinition.Reference)p_286129_));
                }
                return fontmanager$unresolvedbuilderbundle;
            }, p_284969_));
        }
        return Util.sequence(list).thenCompose(p_284592_ -> {
            List list1 = p_284592_.stream().flatMap(UnresolvedBuilderBundle::listBuilders).collect(Collectors.toCollection(ArrayList::new));
            AllMissingGlyphProvider glyphprovider = new AllMissingGlyphProvider();
            list1.add(CompletableFuture.completedFuture(Optional.of(glyphprovider)));
            return Util.sequence(list1).thenCompose(p_284618_ -> {
                Map<ResourceLocation, List<GlyphProvider>> map = this.resolveProviders((List<UnresolvedBuilderBundle>)p_284592_);
                CompletableFuture[] completablefuture = (CompletableFuture[])map.values().stream().map(p_284585_ -> CompletableFuture.runAsync(() -> this.finalizeProviderLoading((List<GlyphProvider>)p_284585_, glyphprovider), p_284969_)).toArray(CompletableFuture[]::new);
                return CompletableFuture.allOf(completablefuture).thenApply(p_284595_ -> {
                    List<GlyphProvider> list2 = p_284618_.stream().flatMap(Optional::stream).toList();
                    return new Preparation(map, list2);
                });
            });
        });
    }

    private CompletableFuture<Optional<GlyphProvider>> safeLoad(BuilderId p_285113_, GlyphProviderDefinition.Loader p_286561_, ResourceManager p_285424_, Executor p_285371_) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return Optional.of(p_286561_.load(p_285424_));
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to load builder {}, rejecting", (Object)p_285113_, (Object)exception);
                return Optional.empty();
            }
        }, p_285371_);
    }

    private Map<ResourceLocation, List<GlyphProvider>> resolveProviders(List<UnresolvedBuilderBundle> p_285282_) {
        HashMap<ResourceLocation, List<GlyphProvider>> map = new HashMap<ResourceLocation, List<GlyphProvider>>();
        DependencySorter<ResourceLocation, UnresolvedBuilderBundle> dependencysorter = new DependencySorter<ResourceLocation, UnresolvedBuilderBundle>();
        p_285282_.forEach(p_284626_ -> dependencysorter.addEntry(p_284626_.fontId, (UnresolvedBuilderBundle)p_284626_));
        dependencysorter.orderByDependencies((p_284620_, p_284621_) -> p_284621_.resolve(map::get).ifPresent(p_284590_ -> map.put((ResourceLocation)p_284620_, (List<GlyphProvider>)p_284590_)));
        return map;
    }

    private void finalizeProviderLoading(List<GlyphProvider> p_285520_, GlyphProvider p_285397_) {
        p_285520_.add(0, p_285397_);
        IntOpenHashSet intset = new IntOpenHashSet();
        for (GlyphProvider glyphprovider : p_285520_) {
            intset.addAll((IntCollection)glyphprovider.getSupportedGlyphs());
        }
        intset.forEach(p_284614_ -> {
            block1: {
                GlyphProvider glyphprovider1;
                if (p_284614_ == 32) break block1;
                Iterator iterator = Lists.reverse((List)p_285520_).iterator();
                while (iterator.hasNext() && (glyphprovider1 = (GlyphProvider)iterator.next()).getGlyph(p_284614_) == null) {
                }
            }
        });
    }

    private void apply(Preparation p_284939_, ProfilerFiller p_285407_) {
        p_285407_.startTick();
        p_285407_.push("closing");
        this.fontSets.values().forEach(FontSet::close);
        this.fontSets.clear();
        this.providersToClose.forEach(GlyphProvider::close);
        this.providersToClose.clear();
        p_285407_.popPush("reloading");
        p_284939_.providers().forEach((p_284627_, p_284628_) -> {
            FontSet fontset = new FontSet(this.textureManager, (ResourceLocation)p_284627_);
            fontset.reload(Lists.reverse((List)p_284628_));
            this.fontSets.put((ResourceLocation)p_284627_, fontset);
        });
        this.providersToClose.addAll(p_284939_.allProviders);
        p_285407_.pop();
        p_285407_.endTick();
        if (!this.fontSets.containsKey(this.getActualId(Minecraft.DEFAULT_FONT))) {
            throw new IllegalStateException("Default font failed to load");
        }
    }

    private static List<Pair<BuilderId, GlyphProviderDefinition>> loadResourceStack(List<Resource> p_284976_, ResourceLocation p_285272_) {
        ArrayList<Pair<BuilderId, GlyphProviderDefinition>> list = new ArrayList<Pair<BuilderId, GlyphProviderDefinition>>();
        for (Resource resource : p_284976_) {
            try {
                BufferedReader reader = resource.openAsReader();
                try {
                    JsonElement jsonelement = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                    FontDefinitionFile fontmanager$fontdefinitionfile = (FontDefinitionFile)Util.getOrThrow(FontDefinitionFile.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonelement), JsonParseException::new);
                    List<GlyphProviderDefinition> list1 = fontmanager$fontdefinitionfile.providers;
                    for (int i = list1.size() - 1; i >= 0; --i) {
                        BuilderId fontmanager$builderid = new BuilderId(p_285272_, resource.sourcePackId(), i);
                        list.add((Pair<BuilderId, GlyphProviderDefinition>)Pair.of((Object)fontmanager$builderid, (Object)list1.get(i)));
                    }
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Unable to load font '{}' in {} in resourcepack: '{}'", new Object[]{p_285272_, FONTS_PATH, resource.sourcePackId(), exception});
            }
        }
        return list;
    }

    public void setRenames(Map<ResourceLocation, ResourceLocation> p_95012_) {
        this.renames = p_95012_;
    }

    private ResourceLocation getActualId(ResourceLocation p_285141_) {
        return this.renames.getOrDefault(p_285141_, p_285141_);
    }

    public Font createFont() {
        return new Font(p_284586_ -> this.fontSets.getOrDefault(this.getActualId((ResourceLocation)p_284586_), this.missingFontSet), false);
    }

    public Font createFontFilterFishy() {
        return new Font(p_284596_ -> this.fontSets.getOrDefault(this.getActualId((ResourceLocation)p_284596_), this.missingFontSet), true);
    }

    @Override
    public void close() {
        this.fontSets.values().forEach(FontSet::close);
        this.providersToClose.forEach(GlyphProvider::close);
        this.missingFontSet.close();
    }

    @OnlyIn(value=Dist.CLIENT)
    record BuilderId(ResourceLocation fontId, String pack, int index) {
        @Override
        public String toString() {
            return "(" + String.valueOf(this.fontId) + ": builder #" + this.index + " from pack " + this.pack + ")";
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    record Preparation(Map<ResourceLocation, List<GlyphProvider>> providers, List<GlyphProvider> allProviders) {
    }

    @OnlyIn(value=Dist.CLIENT)
    record FontDefinitionFile(List<GlyphProviderDefinition> providers) {
        public static final Codec<FontDefinitionFile> CODEC = RecordCodecBuilder.create(p_286425_ -> p_286425_.group((App)GlyphProviderDefinition.CODEC.listOf().fieldOf("providers").forGetter(FontDefinitionFile::providers)).apply((Applicative)p_286425_, FontDefinitionFile::new));
    }

    @OnlyIn(value=Dist.CLIENT)
    record UnresolvedBuilderBundle(ResourceLocation fontId, List<BuilderResult> builders, Set<ResourceLocation> dependencies) implements DependencySorter.Entry<ResourceLocation>
    {
        public UnresolvedBuilderBundle(ResourceLocation p_284984_) {
            this(p_284984_, new ArrayList<BuilderResult>(), new HashSet<ResourceLocation>());
        }

        public void add(BuilderId p_286837_, GlyphProviderDefinition.Reference p_286500_) {
            this.builders.add(new BuilderResult(p_286837_, (Either<CompletableFuture<Optional<GlyphProvider>>, ResourceLocation>)Either.right((Object)p_286500_.id())));
            this.dependencies.add(p_286500_.id());
        }

        public void add(BuilderId p_284935_, CompletableFuture<Optional<GlyphProvider>> p_284966_) {
            this.builders.add(new BuilderResult(p_284935_, (Either<CompletableFuture<Optional<GlyphProvider>>, ResourceLocation>)Either.left(p_284966_)));
        }

        private Stream<CompletableFuture<Optional<GlyphProvider>>> listBuilders() {
            return this.builders.stream().flatMap(p_285041_ -> p_285041_.result.left().stream());
        }

        public Optional<List<GlyphProvider>> resolve(Function<ResourceLocation, List<GlyphProvider>> p_285118_) {
            ArrayList list = new ArrayList();
            for (BuilderResult fontmanager$builderresult : this.builders) {
                Optional<List<GlyphProvider>> optional = fontmanager$builderresult.resolve(p_285118_);
                if (!optional.isPresent()) {
                    return Optional.empty();
                }
                list.addAll(optional.get());
            }
            return Optional.of(list);
        }

        @Override
        public void visitRequiredDependencies(Consumer<ResourceLocation> p_285391_) {
            this.dependencies.forEach(p_285391_);
        }

        @Override
        public void visitOptionalDependencies(Consumer<ResourceLocation> p_285405_) {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    record BuilderResult(BuilderId id, Either<CompletableFuture<Optional<GlyphProvider>>, ResourceLocation> result) {
        public Optional<List<GlyphProvider>> resolve(Function<ResourceLocation, List<GlyphProvider>> p_284942_) {
            return (Optional)this.result.map(p_285332_ -> ((Optional)p_285332_.join()).map(List::of), p_285367_ -> {
                List list = (List)p_284942_.apply((ResourceLocation)p_285367_);
                if (list == null) {
                    LOGGER.warn("Can't find font {} referenced by builder {}, either because it's missing, failed to load or is part of loading cycle", p_285367_, (Object)this.id);
                    return Optional.empty();
                }
                return Optional.of(list);
            });
        }
    }
}

