/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.font.providers;

import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.blaze3d.font.TrueTypeGlyphProvider;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.gui.font.providers.GlyphProviderDefinition;
import net.minecraft.client.gui.font.providers.GlyphProviderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.stb.STBTTFontinfo;
import org.lwjgl.stb.STBTruetype;
import org.lwjgl.system.MemoryUtil;

@OnlyIn(value=Dist.CLIENT)
public record TrueTypeGlyphProviderDefinition(ResourceLocation location, float size, float oversample, Shift shift, String skip) implements GlyphProviderDefinition
{
    private static final Codec<String> SKIP_LIST_CODEC = Codec.either((Codec)Codec.STRING, (Codec)Codec.STRING.listOf()).xmap(p_286728_ -> (String)p_286728_.map(p_286306_ -> p_286306_, p_286852_ -> String.join((CharSequence)"", p_286852_)), Either::left);
    public static final MapCodec<TrueTypeGlyphProviderDefinition> CODEC = RecordCodecBuilder.mapCodec(p_286284_ -> p_286284_.group((App)ResourceLocation.CODEC.fieldOf("file").forGetter(TrueTypeGlyphProviderDefinition::location), (App)Codec.FLOAT.optionalFieldOf("size", (Object)Float.valueOf(11.0f)).forGetter(TrueTypeGlyphProviderDefinition::size), (App)Codec.FLOAT.optionalFieldOf("oversample", (Object)Float.valueOf(1.0f)).forGetter(TrueTypeGlyphProviderDefinition::oversample), (App)Shift.CODEC.optionalFieldOf("shift", (Object)Shift.NONE).forGetter(TrueTypeGlyphProviderDefinition::shift), (App)SKIP_LIST_CODEC.optionalFieldOf("skip", (Object)"").forGetter(TrueTypeGlyphProviderDefinition::skip)).apply((Applicative)p_286284_, TrueTypeGlyphProviderDefinition::new));

    @Override
    public GlyphProviderType type() {
        return GlyphProviderType.TTF;
    }

    @Override
    public Either<GlyphProviderDefinition.Loader, GlyphProviderDefinition.Reference> unpack() {
        return Either.left(this::load);
    }

    private GlyphProvider load(ResourceManager p_286229_) throws IOException {
        TrueTypeGlyphProvider trueTypeGlyphProvider;
        block10: {
            STBTTFontinfo stbttfontinfo = null;
            ByteBuffer bytebuffer = null;
            InputStream inputstream = p_286229_.open(this.location.withPrefix("font/"));
            try {
                stbttfontinfo = STBTTFontinfo.malloc();
                bytebuffer = TextureUtil.readResource(inputstream);
                bytebuffer.flip();
                if (!STBTruetype.stbtt_InitFont((STBTTFontinfo)stbttfontinfo, (ByteBuffer)bytebuffer)) {
                    throw new IOException("Invalid ttf");
                }
                trueTypeGlyphProvider = new TrueTypeGlyphProvider(bytebuffer, stbttfontinfo, this.size, this.oversample, this.shift.x, this.shift.y, this.skip);
                if (inputstream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputstream != null) {
                        try {
                            inputstream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    if (stbttfontinfo != null) {
                        stbttfontinfo.free();
                    }
                    MemoryUtil.memFree(bytebuffer);
                    throw exception;
                }
            }
            inputstream.close();
        }
        return trueTypeGlyphProvider;
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Shift(float x, float y) {
        public static final Shift NONE = new Shift(0.0f, 0.0f);
        public static final Codec<Shift> CODEC = Codec.FLOAT.listOf().comapFlatMap(p_286374_ -> Util.fixedSize(p_286374_, 2).map(p_286746_ -> new Shift(((Float)p_286746_.get(0)).floatValue(), ((Float)p_286746_.get(1)).floatValue())), p_286274_ -> List.of(Float.valueOf(p_286274_.x), Float.valueOf(p_286274_.y)));
    }
}

