/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AllayModel
extends HierarchicalModel<Allay>
implements ArmedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart right_arm;
    private final ModelPart left_arm;
    private final ModelPart right_wing;
    private final ModelPart left_wing;
    private static final float FLYING_ANIMATION_X_ROT = 0.7853982f;
    private static final float MAX_HAND_HOLDING_ITEM_X_ROT_RAD = -1.134464f;
    private static final float MIN_HAND_HOLDING_ITEM_X_ROT_RAD = -1.0471976f;

    public AllayModel(ModelPart p_233312_) {
        super(RenderType::entityTranslucent);
        this.root = p_233312_.getChild("root");
        this.head = this.root.getChild("head");
        this.body = this.root.getChild("body");
        this.right_arm = this.body.getChild("right_arm");
        this.left_arm = this.body.getChild("left_arm");
        this.right_wing = this.body.getChild("right_wing");
        this.left_wing = this.body.getChild("left_wing");
    }

    @Override
    public ModelPart root() {
        return this.root;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset(0.0f, 23.5f, 0.0f));
        partdefinition1.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -5.0f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset(0.0f, -3.99f, 0.0f));
        PartDefinition partdefinition2 = partdefinition1.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 10).addBox(-1.5f, 0.0f, -1.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 16).addBox(-1.5f, 0.0f, -1.0f, 3.0f, 5.0f, 2.0f, new CubeDeformation(-0.2f)), PartPose.offset(0.0f, -4.0f, 0.0f));
        partdefinition2.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(23, 0).addBox(-0.75f, -0.5f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(-0.01f)), PartPose.offset(-1.75f, 0.5f, 0.0f));
        partdefinition2.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(23, 6).addBox(-0.25f, -0.5f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(-0.01f)), PartPose.offset(1.75f, 0.5f, 0.0f));
        partdefinition2.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(16, 14).addBox(0.0f, 1.0f, 0.0f, 0.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset(-0.5f, 0.0f, 0.6f));
        partdefinition2.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(16, 14).addBox(0.0f, 1.0f, 0.0f, 0.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset(0.5f, 0.0f, 0.6f));
        return LayerDefinition.create(meshdefinition, 32, 32);
    }

    @Override
    public void setupAnim(Allay p_233325_, float p_233326_, float p_233327_, float p_233328_, float p_233329_, float p_233330_) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        float f = p_233328_ * 20.0f * ((float)Math.PI / 180) + p_233326_;
        float f1 = Mth.cos(f) * (float)Math.PI * 0.15f + p_233327_;
        float f2 = p_233328_ - (float)p_233325_.tickCount;
        float f3 = p_233328_ * 9.0f * ((float)Math.PI / 180);
        float f4 = Math.min(p_233327_ / 0.3f, 1.0f);
        float f5 = 1.0f - f4;
        float f6 = p_233325_.getHoldingItemAnimationProgress(f2);
        if (p_233325_.isDancing()) {
            float f7 = p_233328_ * 8.0f * ((float)Math.PI / 180) + p_233327_;
            float f8 = Mth.cos(f7) * 16.0f * ((float)Math.PI / 180);
            float f9 = p_233325_.getSpinningProgress(f2);
            float f10 = Mth.cos(f7) * 14.0f * ((float)Math.PI / 180);
            float f11 = Mth.cos(f7) * 30.0f * ((float)Math.PI / 180);
            this.root.yRot = p_233325_.isSpinning() ? (float)Math.PI * 4 * f9 : this.root.yRot;
            this.root.zRot = f8 * (1.0f - f9);
            this.head.yRot = f11 * (1.0f - f9);
            this.head.zRot = f10 * (1.0f - f9);
        } else {
            this.head.xRot = p_233330_ * ((float)Math.PI / 180);
            this.head.yRot = p_233329_ * ((float)Math.PI / 180);
        }
        this.right_wing.xRot = 0.43633232f * (1.0f - f4);
        this.right_wing.yRot = -0.7853982f + f1;
        this.left_wing.xRot = 0.43633232f * (1.0f - f4);
        this.left_wing.yRot = 0.7853982f - f1;
        this.body.xRot = f4 * 0.7853982f;
        float f12 = f6 * Mth.lerp(f4, -1.0471976f, -1.134464f);
        this.root.y += (float)Math.cos(f3) * 0.25f * f5;
        this.right_arm.xRot = f12;
        this.left_arm.xRot = f12;
        float f13 = f5 * (1.0f - f6);
        float f14 = 0.43633232f - Mth.cos(f3 + 4.712389f) * (float)Math.PI * 0.075f * f13;
        this.left_arm.zRot = -f14;
        this.right_arm.zRot = f14;
        this.right_arm.yRot = 0.27925268f * f6;
        this.left_arm.yRot = -0.27925268f * f6;
    }

    @Override
    public void translateToHand(HumanoidArm p_233322_, PoseStack p_233323_) {
        float f = 1.0f;
        float f1 = 3.0f;
        this.root.translateAndRotate(p_233323_);
        this.body.translateAndRotate(p_233323_);
        p_233323_.translate(0.0f, 0.0625f, 0.1875f);
        p_233323_.mulPose(Axis.XP.rotation(this.right_arm.xRot));
        p_233323_.scale(0.7f, 0.7f, 0.7f);
        p_233323_.translate(0.0625f, 0.0f, 0.0f);
    }
}

