/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.animation.definitions.CamelAnimation;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CamelModel<T extends Camel>
extends HierarchicalModel<T> {
    private static final float MAX_WALK_ANIMATION_SPEED = 2.0f;
    private static final float WALK_ANIMATION_SCALE_FACTOR = 2.5f;
    private static final float BABY_SCALE = 0.45f;
    private static final float BABY_Y_OFFSET = 29.35f;
    private static final String SADDLE = "saddle";
    private static final String BRIDLE = "bridle";
    private static final String REINS = "reins";
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart[] saddleParts;
    private final ModelPart[] ridingParts;

    public CamelModel(ModelPart p_251834_) {
        this.root = p_251834_;
        ModelPart modelpart = p_251834_.getChild("body");
        this.head = modelpart.getChild("head");
        this.saddleParts = new ModelPart[]{modelpart.getChild(SADDLE), this.head.getChild(BRIDLE)};
        this.ridingParts = new ModelPart[]{this.head.getChild(REINS)};
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubedeformation = new CubeDeformation(0.1f);
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 25).addBox(-7.5f, -12.0f, -23.5f, 15.0f, 12.0f, 27.0f), PartPose.offset(0.0f, 4.0f, 9.5f));
        partdefinition1.addOrReplaceChild("hump", CubeListBuilder.create().texOffs(74, 0).addBox(-4.5f, -5.0f, -5.5f, 9.0f, 5.0f, 11.0f), PartPose.offset(0.0f, -12.0f, -10.0f));
        partdefinition1.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(122, 0).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 14.0f, 0.0f), PartPose.offset(0.0f, -9.0f, 3.5f));
        PartDefinition partdefinition2 = partdefinition1.addOrReplaceChild("head", CubeListBuilder.create().texOffs(60, 24).addBox(-3.5f, -7.0f, -15.0f, 7.0f, 8.0f, 19.0f).texOffs(21, 0).addBox(-3.5f, -21.0f, -15.0f, 7.0f, 14.0f, 7.0f).texOffs(50, 0).addBox(-2.5f, -21.0f, -21.0f, 5.0f, 5.0f, 6.0f), PartPose.offset(0.0f, -3.0f, -19.5f));
        partdefinition2.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(45, 0).addBox(-0.5f, 0.5f, -1.0f, 3.0f, 1.0f, 2.0f), PartPose.offset(3.0f, -21.0f, -9.5f));
        partdefinition2.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(67, 0).addBox(-2.5f, 0.5f, -1.0f, 3.0f, 1.0f, 2.0f), PartPose.offset(-3.0f, -21.0f, -9.5f));
        partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(58, 16).addBox(-2.5f, 2.0f, -2.5f, 5.0f, 21.0f, 5.0f), PartPose.offset(4.9f, 1.0f, 9.5f));
        partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(94, 16).addBox(-2.5f, 2.0f, -2.5f, 5.0f, 21.0f, 5.0f), PartPose.offset(-4.9f, 1.0f, 9.5f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, 2.0f, -2.5f, 5.0f, 21.0f, 5.0f), PartPose.offset(4.9f, 1.0f, -10.5f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(0, 26).addBox(-2.5f, 2.0f, -2.5f, 5.0f, 21.0f, 5.0f), PartPose.offset(-4.9f, 1.0f, -10.5f));
        partdefinition1.addOrReplaceChild(SADDLE, CubeListBuilder.create().texOffs(74, 64).addBox(-4.5f, -17.0f, -15.5f, 9.0f, 5.0f, 11.0f, cubedeformation).texOffs(92, 114).addBox(-3.5f, -20.0f, -15.5f, 7.0f, 3.0f, 11.0f, cubedeformation).texOffs(0, 89).addBox(-7.5f, -12.0f, -23.5f, 15.0f, 12.0f, 27.0f, cubedeformation), PartPose.offset(0.0f, 0.0f, 0.0f));
        partdefinition2.addOrReplaceChild(REINS, CubeListBuilder.create().texOffs(98, 42).addBox(3.51f, -18.0f, -17.0f, 0.0f, 7.0f, 15.0f).texOffs(84, 57).addBox(-3.5f, -18.0f, -2.0f, 7.0f, 7.0f, 0.0f).texOffs(98, 42).addBox(-3.51f, -18.0f, -17.0f, 0.0f, 7.0f, 15.0f), PartPose.offset(0.0f, 0.0f, 0.0f));
        partdefinition2.addOrReplaceChild(BRIDLE, CubeListBuilder.create().texOffs(60, 87).addBox(-3.5f, -7.0f, -15.0f, 7.0f, 8.0f, 19.0f, cubedeformation).texOffs(21, 64).addBox(-3.5f, -21.0f, -15.0f, 7.0f, 14.0f, 7.0f, cubedeformation).texOffs(50, 64).addBox(-2.5f, -21.0f, -21.0f, 5.0f, 5.0f, 6.0f, cubedeformation).texOffs(74, 70).addBox(2.5f, -19.0f, -18.0f, 1.0f, 2.0f, 2.0f).texOffs(74, 70).mirror().addBox(-3.5f, -19.0f, -18.0f, 1.0f, 2.0f, 2.0f), PartPose.offset(0.0f, 0.0f, 0.0f));
        return LayerDefinition.create(meshdefinition, 128, 128);
    }

    @Override
    public void setupAnim(T p_250657_, float p_250501_, float p_249554_, float p_249527_, float p_248774_, float p_250710_) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(p_250657_, p_248774_, p_250710_, p_249527_);
        this.toggleInvisibleParts(p_250657_);
        this.animateWalk(CamelAnimation.CAMEL_WALK, p_250501_, p_249554_, 2.0f, 2.5f);
        this.animate(((Camel)p_250657_).sitAnimationState, CamelAnimation.CAMEL_SIT, p_249527_, 1.0f);
        this.animate(((Camel)p_250657_).sitPoseAnimationState, CamelAnimation.CAMEL_SIT_POSE, p_249527_, 1.0f);
        this.animate(((Camel)p_250657_).sitUpAnimationState, CamelAnimation.CAMEL_STANDUP, p_249527_, 1.0f);
        this.animate(((Camel)p_250657_).idleAnimationState, CamelAnimation.CAMEL_IDLE, p_249527_, 1.0f);
        this.animate(((Camel)p_250657_).dashAnimationState, CamelAnimation.CAMEL_DASH, p_249527_, 1.0f);
    }

    private void applyHeadRotation(T p_250436_, float p_249176_, float p_251814_, float p_248796_) {
        p_249176_ = Mth.clamp(p_249176_, -30.0f, 30.0f);
        p_251814_ = Mth.clamp(p_251814_, -25.0f, 45.0f);
        if (((Camel)p_250436_).getJumpCooldown() > 0) {
            float f = p_248796_ - (float)((Camel)p_250436_).tickCount;
            float f1 = 45.0f * ((float)((Camel)p_250436_).getJumpCooldown() - f) / 55.0f;
            p_251814_ = Mth.clamp(p_251814_ + f1, -25.0f, 70.0f);
        }
        this.head.yRot = p_249176_ * ((float)Math.PI / 180);
        this.head.xRot = p_251814_ * ((float)Math.PI / 180);
    }

    private void toggleInvisibleParts(T p_251765_) {
        boolean flag = ((AbstractHorse)p_251765_).isSaddled();
        boolean flag1 = ((Entity)p_251765_).isVehicle();
        for (ModelPart modelpart : this.saddleParts) {
            modelpart.visible = flag;
        }
        for (ModelPart modelpart1 : this.ridingParts) {
            modelpart1.visible = flag1 && flag;
        }
    }

    @Override
    public void renderToBuffer(PoseStack p_250278_, VertexConsumer p_251678_, int p_249298_, int p_251841_, float p_250541_, float p_248890_, float p_250527_, float p_250536_) {
        if (this.young) {
            p_250278_.pushPose();
            p_250278_.scale(0.45f, 0.45f, 0.45f);
            p_250278_.translate(0.0f, 1.834375f, 0.0f);
            this.root().render(p_250278_, p_251678_, p_249298_, p_251841_, p_250541_, p_248890_, p_250527_, p_250536_);
            p_250278_.popPose();
        } else {
            this.root().render(p_250278_, p_251678_, p_249298_, p_251841_, p_250541_, p_248890_, p_250527_, p_250536_);
        }
    }

    @Override
    public ModelPart root() {
        return this.root;
    }
}

