/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.animation.definitions.SnifferAnimation;
import net.minecraft.client.model.AgeableHierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SnifferModel<T extends Sniffer>
extends AgeableHierarchicalModel<T> {
    private static final float WALK_ANIMATION_SPEED_MAX = 9.0f;
    private static final float WALK_ANIMATION_SCALE_FACTOR = 100.0f;
    private final ModelPart root;
    private final ModelPart head;

    public SnifferModel(ModelPart p_272867_) {
        super(0.5f, 24.0f);
        this.root = p_272867_.getChild("root");
        this.head = this.root.getChild("bone").getChild("body").getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot().addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset(0.0f, 5.0f, 0.0f));
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offset(0.0f, 0.0f, 0.0f));
        PartDefinition partdefinition2 = partdefinition1.addOrReplaceChild("body", CubeListBuilder.create().texOffs(62, 68).addBox(-12.5f, -14.0f, -20.0f, 25.0f, 29.0f, 40.0f, new CubeDeformation(0.0f)).texOffs(62, 0).addBox(-12.5f, -14.0f, -20.0f, 25.0f, 24.0f, 40.0f, new CubeDeformation(0.5f)).texOffs(87, 68).addBox(-12.5f, 12.0f, -20.0f, 25.0f, 0.0f, 40.0f, new CubeDeformation(0.0f)), PartPose.offset(0.0f, 0.0f, 0.0f));
        partdefinition1.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(32, 87).addBox(-3.5f, -1.0f, -4.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset(-7.5f, 10.0f, -15.0f));
        partdefinition1.addOrReplaceChild("right_mid_leg", CubeListBuilder.create().texOffs(32, 105).addBox(-3.5f, -1.0f, -4.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset(-7.5f, 10.0f, 0.0f));
        partdefinition1.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(32, 123).addBox(-3.5f, -1.0f, -4.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset(-7.5f, 10.0f, 15.0f));
        partdefinition1.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 87).addBox(-3.5f, -1.0f, -4.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset(7.5f, 10.0f, -15.0f));
        partdefinition1.addOrReplaceChild("left_mid_leg", CubeListBuilder.create().texOffs(0, 105).addBox(-3.5f, -1.0f, -4.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset(7.5f, 10.0f, 0.0f));
        partdefinition1.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(0, 123).addBox(-3.5f, -1.0f, -4.0f, 7.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset(7.5f, 10.0f, 15.0f));
        PartDefinition partdefinition3 = partdefinition2.addOrReplaceChild("head", CubeListBuilder.create().texOffs(8, 15).addBox(-6.5f, -7.5f, -11.5f, 13.0f, 18.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(8, 4).addBox(-6.5f, 7.5f, -11.5f, 13.0f, 0.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset(0.0f, 6.5f, -19.48f));
        partdefinition3.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(2, 0).addBox(0.0f, 0.0f, -3.0f, 1.0f, 19.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset(6.51f, -7.5f, -4.51f));
        partdefinition3.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(48, 0).addBox(-1.0f, 0.0f, -3.0f, 1.0f, 19.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset(-6.51f, -7.5f, -4.51f));
        partdefinition3.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(10, 45).addBox(-6.5f, -2.0f, -9.0f, 13.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset(0.0f, -4.5f, -11.5f));
        partdefinition3.addOrReplaceChild("lower_beak", CubeListBuilder.create().texOffs(10, 57).addBox(-6.5f, -7.0f, -8.0f, 13.0f, 12.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset(0.0f, 2.5f, -12.5f));
        return LayerDefinition.create(meshdefinition, 192, 192);
    }

    @Override
    public void setupAnim(T p_273213_, float p_273252_, float p_273344_, float p_272633_, float p_272774_, float p_273206_) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.xRot = p_273206_ * ((float)Math.PI / 180);
        this.head.yRot = p_272774_ * ((float)Math.PI / 180);
        if (((Sniffer)p_273213_).isSearching()) {
            this.animateWalk(SnifferAnimation.SNIFFER_SNIFF_SEARCH, p_273252_, p_273344_, 9.0f, 100.0f);
        } else {
            this.animateWalk(SnifferAnimation.SNIFFER_WALK, p_273252_, p_273344_, 9.0f, 100.0f);
        }
        this.animate(((Sniffer)p_273213_).diggingAnimationState, SnifferAnimation.SNIFFER_DIG, p_272633_);
        this.animate(((Sniffer)p_273213_).sniffingAnimationState, SnifferAnimation.SNIFFER_LONGSNIFF, p_272633_);
        this.animate(((Sniffer)p_273213_).risingAnimationState, SnifferAnimation.SNIFFER_STAND_UP, p_272633_);
        this.animate(((Sniffer)p_273213_).feelingHappyAnimationState, SnifferAnimation.SNIFFER_HAPPY, p_272633_);
        this.animate(((Sniffer)p_273213_).scentingAnimationState, SnifferAnimation.SNIFFER_SNIFFSNIFF, p_272633_);
        if (this.young) {
            this.applyStatic(SnifferAnimation.BABY_TRANSFORM);
        }
    }

    @Override
    public ModelPart root() {
        return this.root;
    }
}

