/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import java.util.Arrays;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SquidModel<T extends Entity>
extends HierarchicalModel<T> {
    private final ModelPart[] tentacles = new ModelPart[8];
    private final ModelPart root;

    public SquidModel(ModelPart p_170989_) {
        this.root = p_170989_;
        Arrays.setAll(this.tentacles, p_170995_ -> p_170989_.getChild(SquidModel.createTentacleName(p_170995_)));
    }

    private static String createTentacleName(int p_170992_) {
        return "tentacle" + p_170992_;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubedeformation = new CubeDeformation(0.02f);
        int i = -16;
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -8.0f, -6.0f, 12.0f, 16.0f, 12.0f, cubedeformation), PartPose.offset(0.0f, 8.0f, 0.0f));
        int j = 8;
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(48, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 18.0f, 2.0f);
        for (int k = 0; k < 8; ++k) {
            double d0 = (double)k * Math.PI * 2.0 / 8.0;
            float f = (float)Math.cos(d0) * 5.0f;
            float f1 = 15.0f;
            float f2 = (float)Math.sin(d0) * 5.0f;
            d0 = (double)k * Math.PI * -2.0 / 8.0 + 1.5707963267948966;
            float f3 = (float)d0;
            partdefinition.addOrReplaceChild(SquidModel.createTentacleName(k), cubelistbuilder, PartPose.offsetAndRotation(f, 15.0f, f2, 0.0f, f3, 0.0f));
        }
        return LayerDefinition.create(meshdefinition, 64, 32);
    }

    @Override
    public void setupAnim(T p_103878_, float p_103879_, float p_103880_, float p_103881_, float p_103882_, float p_103883_) {
        for (ModelPart modelpart : this.tentacles) {
            modelpart.xRot = p_103881_;
        }
    }

    @Override
    public ModelPart root() {
        return this.root;
    }
}

