/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TurtleModel<T extends Turtle>
extends QuadrupedModel<T> {
    private static final String EGG_BELLY = "egg_belly";
    private final ModelPart eggBelly;

    public TurtleModel(ModelPart p_171042_) {
        super(p_171042_, true, 120.0f, 0.0f, 9.0f, 6.0f, 120);
        this.eggBelly = p_171042_.getChild(EGG_BELLY);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(3, 0).addBox(-3.0f, -1.0f, -3.0f, 6.0f, 5.0f, 6.0f), PartPose.offset(0.0f, 19.0f, -10.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(7, 37).addBox("shell", -9.5f, 3.0f, -10.0f, 19.0f, 20.0f, 6.0f).texOffs(31, 1).addBox("belly", -5.5f, 3.0f, -13.0f, 11.0f, 18.0f, 3.0f), PartPose.offsetAndRotation(0.0f, 11.0f, -10.0f, 1.5707964f, 0.0f, 0.0f));
        partdefinition.addOrReplaceChild(EGG_BELLY, CubeListBuilder.create().texOffs(70, 33).addBox(-4.5f, 3.0f, -14.0f, 9.0f, 18.0f, 1.0f), PartPose.offsetAndRotation(0.0f, 11.0f, -10.0f, 1.5707964f, 0.0f, 0.0f));
        boolean i = true;
        partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(1, 23).addBox(-2.0f, 0.0f, 0.0f, 4.0f, 1.0f, 10.0f), PartPose.offset(-3.5f, 22.0f, 11.0f));
        partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(1, 12).addBox(-2.0f, 0.0f, 0.0f, 4.0f, 1.0f, 10.0f), PartPose.offset(3.5f, 22.0f, 11.0f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(27, 30).addBox(-13.0f, 0.0f, -2.0f, 13.0f, 1.0f, 5.0f), PartPose.offset(-5.0f, 21.0f, -4.0f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(27, 24).addBox(0.0f, 0.0f, -2.0f, 13.0f, 1.0f, 5.0f), PartPose.offset(5.0f, 21.0f, -4.0f));
        return LayerDefinition.create(meshdefinition, 128, 64);
    }

    @Override
    protected Iterable<ModelPart> bodyParts() {
        return Iterables.concat(super.bodyParts(), (Iterable)ImmutableList.of((Object)this.eggBelly));
    }

    @Override
    public void setupAnim(T p_103994_, float p_103995_, float p_103996_, float p_103997_, float p_103998_, float p_103999_) {
        super.setupAnim(p_103994_, p_103995_, p_103996_, p_103997_, p_103998_, p_103999_);
        this.rightHindLeg.xRot = Mth.cos(p_103995_ * 0.6662f * 0.6f) * 0.5f * p_103996_;
        this.leftHindLeg.xRot = Mth.cos(p_103995_ * 0.6662f * 0.6f + (float)Math.PI) * 0.5f * p_103996_;
        this.rightFrontLeg.zRot = Mth.cos(p_103995_ * 0.6662f * 0.6f + (float)Math.PI) * 0.5f * p_103996_;
        this.leftFrontLeg.zRot = Mth.cos(p_103995_ * 0.6662f * 0.6f) * 0.5f * p_103996_;
        this.rightFrontLeg.xRot = 0.0f;
        this.leftFrontLeg.xRot = 0.0f;
        this.rightFrontLeg.yRot = 0.0f;
        this.leftFrontLeg.yRot = 0.0f;
        this.rightHindLeg.yRot = 0.0f;
        this.leftHindLeg.yRot = 0.0f;
        if (!((Entity)p_103994_).isInWater() && ((Entity)p_103994_).onGround()) {
            float f = ((Turtle)p_103994_).isLayingEgg() ? 4.0f : 1.0f;
            float f1 = ((Turtle)p_103994_).isLayingEgg() ? 2.0f : 1.0f;
            float f2 = 5.0f;
            this.rightFrontLeg.yRot = Mth.cos(f * p_103995_ * 5.0f + (float)Math.PI) * 8.0f * p_103996_ * f1;
            this.rightFrontLeg.zRot = 0.0f;
            this.leftFrontLeg.yRot = Mth.cos(f * p_103995_ * 5.0f) * 8.0f * p_103996_ * f1;
            this.leftFrontLeg.zRot = 0.0f;
            this.rightHindLeg.yRot = Mth.cos(p_103995_ * 5.0f + (float)Math.PI) * 3.0f * p_103996_;
            this.rightHindLeg.xRot = 0.0f;
            this.leftHindLeg.yRot = Mth.cos(p_103995_ * 5.0f) * 3.0f * p_103996_;
            this.leftHindLeg.xRot = 0.0f;
        }
        this.eggBelly.visible = !this.young && ((Turtle)p_103994_).hasEgg();
    }

    @Override
    public void renderToBuffer(PoseStack p_104001_, VertexConsumer p_104002_, int p_104003_, int p_104004_, float p_104005_, float p_104006_, float p_104007_, float p_104008_) {
        boolean flag = this.eggBelly.visible;
        if (flag) {
            p_104001_.pushPose();
            p_104001_.translate(0.0f, -0.08f, 0.0f);
        }
        super.renderToBuffer(p_104001_, p_104002_, p_104003_, p_104004_, p_104005_, p_104006_, p_104007_, p_104008_);
        if (flag) {
            p_104001_.popPose();
        }
    }
}

