/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer.chat.report;

import com.mojang.authlib.yggdrasil.request.AbuseReportRequest;
import com.mojang.realmsclient.dto.RealmsServer;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public record ReportEnvironment(String clientVersion, @Nullable Server server) {
    public static ReportEnvironment local() {
        return ReportEnvironment.create(null);
    }

    public static ReportEnvironment thirdParty(String p_238999_) {
        return ReportEnvironment.create(new Server.ThirdParty(p_238999_));
    }

    public static ReportEnvironment realm(RealmsServer p_239765_) {
        return ReportEnvironment.create(new Server.Realm(p_239765_));
    }

    public static ReportEnvironment create(@Nullable Server p_239956_) {
        return new ReportEnvironment(ReportEnvironment.getClientVersion(), p_239956_);
    }

    public AbuseReportRequest.ClientInfo clientInfo() {
        return new AbuseReportRequest.ClientInfo(this.clientVersion, Locale.getDefault().toLanguageTag());
    }

    @Nullable
    public AbuseReportRequest.ThirdPartyServerInfo thirdPartyServerInfo() {
        Server reportenvironment$server = this.server;
        if (reportenvironment$server instanceof Server.ThirdParty) {
            Server.ThirdParty reportenvironment$server$thirdparty = (Server.ThirdParty)reportenvironment$server;
            return new AbuseReportRequest.ThirdPartyServerInfo(reportenvironment$server$thirdparty.ip);
        }
        return null;
    }

    @Nullable
    public AbuseReportRequest.RealmInfo realmInfo() {
        Server reportenvironment$server = this.server;
        if (reportenvironment$server instanceof Server.Realm) {
            Server.Realm reportenvironment$server$realm = (Server.Realm)reportenvironment$server;
            return new AbuseReportRequest.RealmInfo(String.valueOf(reportenvironment$server$realm.realmId()), reportenvironment$server$realm.slotId());
        }
        return null;
    }

    private static String getClientVersion() {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append("1.20.1");
        if (Minecraft.checkModStatus().shouldReportAsModified()) {
            stringbuilder.append(" (modded)");
        }
        return stringbuilder.toString();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface Server {

        @OnlyIn(value=Dist.CLIENT)
        public record ThirdParty(String ip) implements Server
        {
        }

        @OnlyIn(value=Dist.CLIENT)
        public record Realm(long realmId, int slotId) implements Server
        {
            public Realm(RealmsServer p_239068_) {
                this(p_239068_.id, p_239068_.activeSlot);
            }
        }
    }
}

