/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class FogRenderer {
    private static final int WATER_FOG_DISTANCE = 96;
    private static final List<MobEffectFogFunction> MOB_EFFECT_FOG = Lists.newArrayList((Object[])new MobEffectFogFunction[]{new BlindnessFogFunction(), new DarknessFogFunction()});
    public static final float BIOME_FOG_TRANSITION_TIME = 5000.0f;
    private static float fogRed;
    private static float fogGreen;
    private static float fogBlue;
    private static int targetBiomeFog;
    private static int previousBiomeFog;
    private static long biomeChangedTime;

    public static void setupColor(Camera p_109019_, float p_109020_, ClientLevel p_109021_, int p_109022_, float p_109023_) {
        LivingEntity livingentity1;
        FogType fogtype = p_109019_.getFluidInCamera();
        Entity entity = p_109019_.getEntity();
        if (fogtype == FogType.WATER) {
            long i = Util.getMillis();
            int j = p_109021_.getBiome(BlockPos.containing(p_109019_.getPosition())).value().getWaterFogColor();
            if (biomeChangedTime < 0L) {
                targetBiomeFog = j;
                previousBiomeFog = j;
                biomeChangedTime = i;
            }
            int k = targetBiomeFog >> 16 & 0xFF;
            int l = targetBiomeFog >> 8 & 0xFF;
            int i1 = targetBiomeFog & 0xFF;
            int j1 = previousBiomeFog >> 16 & 0xFF;
            int k1 = previousBiomeFog >> 8 & 0xFF;
            int l1 = previousBiomeFog & 0xFF;
            float f = Mth.clamp((float)(i - biomeChangedTime) / 5000.0f, 0.0f, 1.0f);
            float f1 = Mth.lerp(f, j1, k);
            float f2 = Mth.lerp(f, k1, l);
            float f3 = Mth.lerp(f, l1, i1);
            fogRed = f1 / 255.0f;
            fogGreen = f2 / 255.0f;
            fogBlue = f3 / 255.0f;
            if (targetBiomeFog != j) {
                targetBiomeFog = j;
                previousBiomeFog = Mth.floor(f1) << 16 | Mth.floor(f2) << 8 | Mth.floor(f3);
                biomeChangedTime = i;
            }
        } else if (fogtype == FogType.LAVA) {
            fogRed = 0.6f;
            fogGreen = 0.1f;
            fogBlue = 0.0f;
            biomeChangedTime = -1L;
        } else if (fogtype == FogType.POWDER_SNOW) {
            fogRed = 0.623f;
            fogGreen = 0.734f;
            fogBlue = 0.785f;
            biomeChangedTime = -1L;
            RenderSystem.clearColor(fogRed, fogGreen, fogBlue, 0.0f);
        } else {
            float f15;
            float f4 = 0.25f + 0.75f * (float)p_109022_ / 32.0f;
            f4 = 1.0f - (float)Math.pow(f4, 0.25);
            Vec3 vec3 = p_109021_.getSkyColor(p_109019_.getPosition(), p_109020_);
            float f6 = (float)vec3.x;
            float f8 = (float)vec3.y;
            float f10 = (float)vec3.z;
            float f11 = Mth.clamp(Mth.cos(p_109021_.getTimeOfDay(p_109020_) * ((float)Math.PI * 2)) * 2.0f + 0.5f, 0.0f, 1.0f);
            BiomeManager biomemanager = p_109021_.getBiomeManager();
            Vec3 vec31 = p_109019_.getPosition().subtract(2.0, 2.0, 2.0).scale(0.25);
            Vec3 vec32 = CubicSampler.gaussianSampleVec3(vec31, (p_109033_, p_109034_, p_109035_) -> p_109021_.effects().getBrightnessDependentFogColor(Vec3.fromRGB24(biomemanager.getNoiseBiomeAtQuart(p_109033_, p_109034_, p_109035_).value().getFogColor()), f11));
            fogRed = (float)vec32.x();
            fogGreen = (float)vec32.y();
            fogBlue = (float)vec32.z();
            if (p_109022_ >= 4) {
                float[] afloat;
                float f12 = Mth.sin(p_109021_.getSunAngle(p_109020_)) > 0.0f ? -1.0f : 1.0f;
                Vector3f vector3f = new Vector3f(f12, 0.0f, 0.0f);
                float f16 = p_109019_.getLookVector().dot((Vector3fc)vector3f);
                if (f16 < 0.0f) {
                    f16 = 0.0f;
                }
                if (f16 > 0.0f && (afloat = p_109021_.effects().getSunriseColor(p_109021_.getTimeOfDay(p_109020_), p_109020_)) != null) {
                    fogRed = fogRed * (1.0f - (f16 *= afloat[3])) + afloat[0] * f16;
                    fogGreen = fogGreen * (1.0f - f16) + afloat[1] * f16;
                    fogBlue = fogBlue * (1.0f - f16) + afloat[2] * f16;
                }
            }
            fogRed += (f6 - fogRed) * f4;
            fogGreen += (f8 - fogGreen) * f4;
            fogBlue += (f10 - fogBlue) * f4;
            float f13 = p_109021_.getRainLevel(p_109020_);
            if (f13 > 0.0f) {
                float f14 = 1.0f - f13 * 0.5f;
                float f17 = 1.0f - f13 * 0.4f;
                fogRed *= f14;
                fogGreen *= f14;
                fogBlue *= f17;
            }
            if ((f15 = p_109021_.getThunderLevel(p_109020_)) > 0.0f) {
                float f18 = 1.0f - f15 * 0.5f;
                fogRed *= f18;
                fogGreen *= f18;
                fogBlue *= f18;
            }
            biomeChangedTime = -1L;
        }
        float f5 = ((float)p_109019_.getPosition().y - (float)p_109021_.getMinBuildHeight()) * p_109021_.getLevelData().getClearColorScale();
        MobEffectFogFunction fogrenderer$mobeffectfogfunction = FogRenderer.getPriorityFogFunction(entity, p_109020_);
        if (fogrenderer$mobeffectfogfunction != null) {
            LivingEntity livingentity = (LivingEntity)entity;
            f5 = fogrenderer$mobeffectfogfunction.getModifiedVoidDarkness(livingentity, livingentity.getEffect(fogrenderer$mobeffectfogfunction.getMobEffect()), f5, p_109020_);
        }
        if (f5 < 1.0f && fogtype != FogType.LAVA && fogtype != FogType.POWDER_SNOW) {
            if (f5 < 0.0f) {
                f5 = 0.0f;
            }
            f5 *= f5;
            fogRed *= f5;
            fogGreen *= f5;
            fogBlue *= f5;
        }
        if (p_109023_ > 0.0f) {
            fogRed = fogRed * (1.0f - p_109023_) + fogRed * 0.7f * p_109023_;
            fogGreen = fogGreen * (1.0f - p_109023_) + fogGreen * 0.6f * p_109023_;
            fogBlue = fogBlue * (1.0f - p_109023_) + fogBlue * 0.6f * p_109023_;
        }
        float f7 = fogtype == FogType.WATER ? (entity instanceof LocalPlayer ? ((LocalPlayer)entity).getWaterVision() : 1.0f) : (entity instanceof LivingEntity && (livingentity1 = (LivingEntity)entity).hasEffect(MobEffects.NIGHT_VISION) && !livingentity1.hasEffect(MobEffects.DARKNESS) ? GameRenderer.getNightVisionScale(livingentity1, p_109020_) : 0.0f);
        if (fogRed != 0.0f && fogGreen != 0.0f && fogBlue != 0.0f) {
            float f9 = Math.min(1.0f / fogRed, Math.min(1.0f / fogGreen, 1.0f / fogBlue));
            fogRed = fogRed * (1.0f - f7) + fogRed * f9 * f7;
            fogGreen = fogGreen * (1.0f - f7) + fogGreen * f9 * f7;
            fogBlue = fogBlue * (1.0f - f7) + fogBlue * f9 * f7;
        }
        Vector3f fogColor = ForgeHooksClient.getFogColor(p_109019_, p_109020_, p_109021_, p_109022_, p_109023_, fogRed, fogGreen, fogBlue);
        fogRed = fogColor.x();
        fogGreen = fogColor.y();
        fogBlue = fogColor.z();
        RenderSystem.clearColor(fogRed, fogGreen, fogBlue, 0.0f);
    }

    public static void setupNoFog() {
        RenderSystem.setShaderFogStart(Float.MAX_VALUE);
    }

    @Nullable
    private static MobEffectFogFunction getPriorityFogFunction(Entity p_234166_, float p_234167_) {
        if (p_234166_ instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)p_234166_;
            return MOB_EFFECT_FOG.stream().filter(p_234171_ -> p_234171_.isEnabled(livingentity, p_234167_)).findFirst().orElse(null);
        }
        return null;
    }

    public static void setupFog(Camera p_234173_, FogMode p_234174_, float p_234175_, boolean p_234176_, float p_234177_) {
        FogType fogtype = p_234173_.getFluidInCamera();
        Entity entity = p_234173_.getEntity();
        FogData fogrenderer$fogdata = new FogData(p_234174_);
        MobEffectFogFunction fogrenderer$mobeffectfogfunction = FogRenderer.getPriorityFogFunction(entity, p_234177_);
        if (fogtype == FogType.LAVA) {
            if (entity.isSpectator()) {
                fogrenderer$fogdata.start = -8.0f;
                fogrenderer$fogdata.end = p_234175_ * 0.5f;
            } else if (entity instanceof LivingEntity && ((LivingEntity)entity).hasEffect(MobEffects.FIRE_RESISTANCE)) {
                fogrenderer$fogdata.start = 0.0f;
                fogrenderer$fogdata.end = 3.0f;
            } else {
                fogrenderer$fogdata.start = 0.25f;
                fogrenderer$fogdata.end = 1.0f;
            }
        } else if (fogtype == FogType.POWDER_SNOW) {
            if (entity.isSpectator()) {
                fogrenderer$fogdata.start = -8.0f;
                fogrenderer$fogdata.end = p_234175_ * 0.5f;
            } else {
                fogrenderer$fogdata.start = 0.0f;
                fogrenderer$fogdata.end = 2.0f;
            }
        } else if (fogrenderer$mobeffectfogfunction != null) {
            LivingEntity livingentity = (LivingEntity)entity;
            MobEffectInstance mobeffectinstance = livingentity.getEffect(fogrenderer$mobeffectfogfunction.getMobEffect());
            if (mobeffectinstance != null) {
                fogrenderer$mobeffectfogfunction.setupFog(fogrenderer$fogdata, livingentity, mobeffectinstance, p_234175_, p_234177_);
            }
        } else if (fogtype == FogType.WATER) {
            fogrenderer$fogdata.start = -8.0f;
            fogrenderer$fogdata.end = 96.0f;
            if (entity instanceof LocalPlayer) {
                LocalPlayer localplayer = (LocalPlayer)entity;
                fogrenderer$fogdata.end *= Math.max(0.25f, localplayer.getWaterVision());
                Holder<Biome> holder = localplayer.level().getBiome(localplayer.blockPosition());
                if (holder.is(BiomeTags.HAS_CLOSER_WATER_FOG)) {
                    fogrenderer$fogdata.end *= 0.85f;
                }
            }
            if (fogrenderer$fogdata.end > p_234175_) {
                fogrenderer$fogdata.end = p_234175_;
                fogrenderer$fogdata.shape = FogShape.CYLINDER;
            }
        } else if (p_234176_) {
            fogrenderer$fogdata.start = p_234175_ * 0.05f;
            fogrenderer$fogdata.end = Math.min(p_234175_, 192.0f) * 0.5f;
        } else if (p_234174_ == FogMode.FOG_SKY) {
            fogrenderer$fogdata.start = 0.0f;
            fogrenderer$fogdata.end = p_234175_;
            fogrenderer$fogdata.shape = FogShape.CYLINDER;
        } else {
            float f = Mth.clamp(p_234175_ / 10.0f, 4.0f, 64.0f);
            fogrenderer$fogdata.start = p_234175_ - f;
            fogrenderer$fogdata.end = p_234175_;
            fogrenderer$fogdata.shape = FogShape.CYLINDER;
        }
        RenderSystem.setShaderFogStart(fogrenderer$fogdata.start);
        RenderSystem.setShaderFogEnd(fogrenderer$fogdata.end);
        RenderSystem.setShaderFogShape(fogrenderer$fogdata.shape);
        ForgeHooksClient.onFogRender(p_234174_, fogtype, p_234173_, p_234177_, p_234175_, fogrenderer$fogdata.start, fogrenderer$fogdata.end, fogrenderer$fogdata.shape);
    }

    public static void levelFogColor() {
        RenderSystem.setShaderFogColor(fogRed, fogGreen, fogBlue);
    }

    static {
        targetBiomeFog = -1;
        previousBiomeFog = -1;
        biomeChangedTime = -1L;
    }

    @OnlyIn(value=Dist.CLIENT)
    static interface MobEffectFogFunction {
        public MobEffect getMobEffect();

        public void setupFog(FogData var1, LivingEntity var2, MobEffectInstance var3, float var4, float var5);

        default public boolean isEnabled(LivingEntity p_234206_, float p_234207_) {
            return p_234206_.hasEffect(this.getMobEffect());
        }

        default public float getModifiedVoidDarkness(LivingEntity p_234208_, MobEffectInstance p_234209_, float p_234210_, float p_234211_) {
            MobEffectInstance mobeffectinstance = p_234208_.getEffect(this.getMobEffect());
            if (mobeffectinstance != null) {
                p_234210_ = mobeffectinstance.endsWithin(19) ? 1.0f - (float)mobeffectinstance.getDuration() / 20.0f : 0.0f;
            }
            return p_234210_;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class FogData {
        public final FogMode mode;
        public float start;
        public float end;
        public FogShape shape = FogShape.SPHERE;

        public FogData(FogMode p_234204_) {
            this.mode = p_234204_;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum FogMode {
        FOG_SKY,
        FOG_TERRAIN;

    }

    @OnlyIn(value=Dist.CLIENT)
    static class BlindnessFogFunction
    implements MobEffectFogFunction {
        BlindnessFogFunction() {
        }

        @Override
        public MobEffect getMobEffect() {
            return MobEffects.BLINDNESS;
        }

        @Override
        public void setupFog(FogData p_234181_, LivingEntity p_234182_, MobEffectInstance p_234183_, float p_234184_, float p_234185_) {
            float f;
            float f2 = f = p_234183_.isInfiniteDuration() ? 5.0f : Mth.lerp(Math.min(1.0f, (float)p_234183_.getDuration() / 20.0f), p_234184_, 5.0f);
            if (p_234181_.mode == FogMode.FOG_SKY) {
                p_234181_.start = 0.0f;
                p_234181_.end = f * 0.8f;
            } else {
                p_234181_.start = f * 0.25f;
                p_234181_.end = f;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class DarknessFogFunction
    implements MobEffectFogFunction {
        DarknessFogFunction() {
        }

        @Override
        public MobEffect getMobEffect() {
            return MobEffects.DARKNESS;
        }

        @Override
        public void setupFog(FogData p_234194_, LivingEntity p_234195_, MobEffectInstance p_234196_, float p_234197_, float p_234198_) {
            if (!p_234196_.getFactorData().isEmpty()) {
                float f = Mth.lerp(p_234196_.getFactorData().get().getFactor(p_234195_, p_234198_), p_234197_, 15.0f);
                p_234194_.start = p_234194_.mode == FogMode.FOG_SKY ? 0.0f : f * 0.75f;
                p_234194_.end = f;
            }
        }

        @Override
        public float getModifiedVoidDarkness(LivingEntity p_234189_, MobEffectInstance p_234190_, float p_234191_, float p_234192_) {
            return p_234190_.getFactorData().isEmpty() ? 0.0f : 1.0f - p_234190_.getFactorData().get().getFactor(p_234189_, p_234192_);
        }
    }
}

