/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.levelgen.DebugLevelSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
class RenderChunk {
    private final Map<BlockPos, BlockEntity> blockEntities;
    @Nullable
    private final List<PalettedContainer<BlockState>> sections;
    private final boolean debug;
    private final LevelChunk wrapped;

    RenderChunk(LevelChunk p_200446_) {
        this.wrapped = p_200446_;
        this.debug = p_200446_.getLevel().isDebug();
        this.blockEntities = ImmutableMap.copyOf(p_200446_.getBlockEntities());
        if (p_200446_ instanceof EmptyLevelChunk) {
            this.sections = null;
        } else {
            LevelChunkSection[] alevelchunksection = p_200446_.getSections();
            this.sections = new ArrayList<PalettedContainer<BlockState>>(alevelchunksection.length);
            for (LevelChunkSection levelchunksection : alevelchunksection) {
                this.sections.add(levelchunksection.hasOnlyAir() ? null : levelchunksection.getStates().copy());
            }
        }
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos p_200452_) {
        return this.blockEntities.get(p_200452_);
    }

    public BlockState getBlockState(BlockPos p_200454_) {
        int i = p_200454_.getX();
        int j = p_200454_.getY();
        int k = p_200454_.getZ();
        if (this.debug) {
            BlockState blockstate = null;
            if (j == 60) {
                blockstate = Blocks.BARRIER.defaultBlockState();
            }
            if (j == 70) {
                blockstate = DebugLevelSource.getBlockStateFor(i, k);
            }
            return blockstate == null ? Blocks.AIR.defaultBlockState() : blockstate;
        }
        if (this.sections == null) {
            return Blocks.AIR.defaultBlockState();
        }
        try {
            PalettedContainer<BlockState> palettedcontainer;
            int l = this.wrapped.getSectionIndex(j);
            if (l >= 0 && l < this.sections.size() && (palettedcontainer = this.sections.get(l)) != null) {
                return palettedcontainer.get(i & 0xF, j & 0xF, k & 0xF);
            }
            return Blocks.AIR.defaultBlockState();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Getting block state");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Block being got");
            crashreportcategory.setDetail("Location", () -> CrashReportCategory.formatLocation((LevelHeightAccessor)this.wrapped, i, j, k));
            throw new ReportedException(crashreport);
        }
    }
}

