/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LightLayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LightDebugRenderer
implements DebugRenderer.SimpleDebugRenderer {
    private final Minecraft minecraft;
    private static final int MAX_RENDER_DIST = 10;

    public LightDebugRenderer(Minecraft p_113585_) {
        this.minecraft = p_113585_;
    }

    @Override
    public void render(PoseStack p_113587_, MultiBufferSource p_113588_, double p_113589_, double p_113590_, double p_113591_) {
        ClientLevel level = this.minecraft.level;
        BlockPos blockpos = BlockPos.containing(p_113589_, p_113590_, p_113591_);
        LongOpenHashSet longset = new LongOpenHashSet();
        for (BlockPos blockpos1 : BlockPos.betweenClosed(blockpos.offset(-10, -10, -10), blockpos.offset(10, 10, 10))) {
            int i = level.getBrightness(LightLayer.SKY, blockpos1);
            float f = (float)(15 - i) / 15.0f * 0.5f + 0.16f;
            int j = Mth.hsvToRgb(f, 0.9f, 0.9f);
            long k = SectionPos.blockToSection(blockpos1.asLong());
            if (longset.add(k)) {
                DebugRenderer.renderFloatingText(p_113587_, p_113588_, level.getChunkSource().getLightEngine().getDebugData(LightLayer.SKY, SectionPos.of(k)), SectionPos.sectionToBlockCoord(SectionPos.x(k), 8), SectionPos.sectionToBlockCoord(SectionPos.y(k), 8), SectionPos.sectionToBlockCoord(SectionPos.z(k), 8), 0xFF0000, 0.3f);
            }
            if (i == 15) continue;
            DebugRenderer.renderFloatingText(p_113587_, p_113588_, String.valueOf(i), (double)blockpos1.getX() + 0.5, (double)blockpos1.getY() + 0.25, (double)blockpos1.getZ() + 0.5, j);
        }
    }
}

