/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WaterDebugRenderer
implements DebugRenderer.SimpleDebugRenderer {
    private final Minecraft minecraft;

    public WaterDebugRenderer(Minecraft p_113717_) {
        this.minecraft = p_113717_;
    }

    @Override
    public void render(PoseStack p_113719_, MultiBufferSource p_113720_, double p_113721_, double p_113722_, double p_113723_) {
        BlockPos blockpos = this.minecraft.player.blockPosition();
        Level levelreader = this.minecraft.player.level();
        for (BlockPos blockpos1 : BlockPos.betweenClosed(blockpos.offset(-10, -10, -10), blockpos.offset(10, 10, 10))) {
            FluidState fluidstate = levelreader.getFluidState(blockpos1);
            if (!fluidstate.is(FluidTags.WATER)) continue;
            double d0 = (float)blockpos1.getY() + fluidstate.getHeight(levelreader, blockpos1);
            DebugRenderer.renderFilledBox(p_113719_, p_113720_, new AABB((float)blockpos1.getX() + 0.01f, (float)blockpos1.getY() + 0.01f, (float)blockpos1.getZ() + 0.01f, (float)blockpos1.getX() + 0.99f, d0, (float)blockpos1.getZ() + 0.99f).move(-p_113721_, -p_113722_, -p_113723_), 0.0f, 1.0f, 0.0f, 0.15f);
        }
        for (BlockPos blockpos2 : BlockPos.betweenClosed(blockpos.offset(-10, -10, -10), blockpos.offset(10, 10, 10))) {
            FluidState fluidstate1 = levelreader.getFluidState(blockpos2);
            if (!fluidstate1.is(FluidTags.WATER)) continue;
            DebugRenderer.renderFloatingText(p_113719_, p_113720_, String.valueOf(fluidstate1.getAmount()), (double)blockpos2.getX() + 0.5, (float)blockpos2.getY() + fluidstate1.getHeight(levelreader, blockpos2), (double)blockpos2.getZ() + 0.5, -16777216);
        }
    }
}

