/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.model.ArmorStandArmorModel;
import net.minecraft.client.model.ArmorStandModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmorStandRenderer
extends LivingEntityRenderer<ArmorStand, ArmorStandArmorModel> {
    public static final ResourceLocation DEFAULT_SKIN_LOCATION = new ResourceLocation("textures/entity/armorstand/wood.png");

    public ArmorStandRenderer(EntityRendererProvider.Context p_173915_) {
        super(p_173915_, new ArmorStandModel(p_173915_.bakeLayer(ModelLayers.ARMOR_STAND)), 0.0f);
        this.addLayer(new HumanoidArmorLayer<ArmorStand, ArmorStandArmorModel, ArmorStandArmorModel>(this, new ArmorStandArmorModel(p_173915_.bakeLayer(ModelLayers.ARMOR_STAND_INNER_ARMOR)), new ArmorStandArmorModel(p_173915_.bakeLayer(ModelLayers.ARMOR_STAND_OUTER_ARMOR)), p_173915_.getModelManager()));
        this.addLayer(new ItemInHandLayer<ArmorStand, ArmorStandArmorModel>(this, p_173915_.getItemInHandRenderer()));
        this.addLayer(new ElytraLayer<ArmorStand, ArmorStandArmorModel>(this, p_173915_.getModelSet()));
        this.addLayer(new CustomHeadLayer<ArmorStand, ArmorStandArmorModel>(this, p_173915_.getModelSet(), p_173915_.getItemInHandRenderer()));
    }

    @Override
    public ResourceLocation getTextureLocation(ArmorStand p_113798_) {
        return DEFAULT_SKIN_LOCATION;
    }

    @Override
    protected void setupRotations(ArmorStand p_113800_, PoseStack p_113801_, float p_113802_, float p_113803_, float p_113804_) {
        p_113801_.mulPose(Axis.YP.rotationDegrees(180.0f - p_113803_));
        float f = (float)(p_113800_.level().getGameTime() - p_113800_.lastHit) + p_113804_;
        if (f < 5.0f) {
            p_113801_.mulPose(Axis.YP.rotationDegrees(Mth.sin(f / 1.5f * (float)Math.PI) * 3.0f));
        }
    }

    @Override
    protected boolean shouldShowName(ArmorStand p_113815_) {
        double d0 = this.entityRenderDispatcher.distanceToSqr(p_113815_);
        float f = p_113815_.isCrouching() ? 32.0f : 64.0f;
        return d0 >= (double)(f * f) ? false : p_113815_.isCustomNameVisible();
    }

    @Override
    @Nullable
    protected RenderType getRenderType(ArmorStand p_113806_, boolean p_113807_, boolean p_113808_, boolean p_113809_) {
        if (!p_113806_.isMarker()) {
            return super.getRenderType(p_113806_, p_113807_, p_113808_, p_113809_);
        }
        ResourceLocation resourcelocation = this.getTextureLocation(p_113806_);
        if (p_113808_) {
            return RenderType.entityTranslucent(resourcelocation, false);
        }
        return p_113807_ ? RenderType.entityCutoutNoCull(resourcelocation, false) : null;
    }
}

