/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public abstract class ArrowRenderer<T extends AbstractArrow>
extends EntityRenderer<T> {
    public ArrowRenderer(EntityRendererProvider.Context p_173917_) {
        super(p_173917_);
    }

    @Override
    public void render(T p_113839_, float p_113840_, float p_113841_, PoseStack p_113842_, MultiBufferSource p_113843_, int p_113844_) {
        p_113842_.pushPose();
        p_113842_.mulPose(Axis.YP.rotationDegrees(Mth.lerp(p_113841_, ((AbstractArrow)p_113839_).yRotO, ((Entity)p_113839_).getYRot()) - 90.0f));
        p_113842_.mulPose(Axis.ZP.rotationDegrees(Mth.lerp(p_113841_, ((AbstractArrow)p_113839_).xRotO, ((Entity)p_113839_).getXRot())));
        boolean i = false;
        float f = 0.0f;
        float f1 = 0.5f;
        float f2 = 0.0f;
        float f3 = 0.15625f;
        float f4 = 0.0f;
        float f5 = 0.15625f;
        float f6 = 0.15625f;
        float f7 = 0.3125f;
        float f8 = 0.05625f;
        float f9 = (float)((AbstractArrow)p_113839_).shakeTime - p_113841_;
        if (f9 > 0.0f) {
            float f10 = -Mth.sin(f9 * 3.0f) * f9;
            p_113842_.mulPose(Axis.ZP.rotationDegrees(f10));
        }
        p_113842_.mulPose(Axis.XP.rotationDegrees(45.0f));
        p_113842_.scale(0.05625f, 0.05625f, 0.05625f);
        p_113842_.translate(-4.0f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = p_113843_.getBuffer(RenderType.entityCutout(this.getTextureLocation(p_113839_)));
        PoseStack.Pose posestack$pose = p_113842_.last();
        Matrix4f matrix4f = posestack$pose.pose();
        Matrix3f matrix3f = posestack$pose.normal();
        this.vertex(matrix4f, matrix3f, vertexconsumer, -7, -2, -2, 0.0f, 0.15625f, -1, 0, 0, p_113844_);
        this.vertex(matrix4f, matrix3f, vertexconsumer, -7, -2, 2, 0.15625f, 0.15625f, -1, 0, 0, p_113844_);
        this.vertex(matrix4f, matrix3f, vertexconsumer, -7, 2, 2, 0.15625f, 0.3125f, -1, 0, 0, p_113844_);
        this.vertex(matrix4f, matrix3f, vertexconsumer, -7, 2, -2, 0.0f, 0.3125f, -1, 0, 0, p_113844_);
        this.vertex(matrix4f, matrix3f, vertexconsumer, -7, 2, -2, 0.0f, 0.15625f, 1, 0, 0, p_113844_);
        this.vertex(matrix4f, matrix3f, vertexconsumer, -7, 2, 2, 0.15625f, 0.15625f, 1, 0, 0, p_113844_);
        this.vertex(matrix4f, matrix3f, vertexconsumer, -7, -2, 2, 0.15625f, 0.3125f, 1, 0, 0, p_113844_);
        this.vertex(matrix4f, matrix3f, vertexconsumer, -7, -2, -2, 0.0f, 0.3125f, 1, 0, 0, p_113844_);
        for (int j = 0; j < 4; ++j) {
            p_113842_.mulPose(Axis.XP.rotationDegrees(90.0f));
            this.vertex(matrix4f, matrix3f, vertexconsumer, -8, -2, 0, 0.0f, 0.0f, 0, 1, 0, p_113844_);
            this.vertex(matrix4f, matrix3f, vertexconsumer, 8, -2, 0, 0.5f, 0.0f, 0, 1, 0, p_113844_);
            this.vertex(matrix4f, matrix3f, vertexconsumer, 8, 2, 0, 0.5f, 0.15625f, 0, 1, 0, p_113844_);
            this.vertex(matrix4f, matrix3f, vertexconsumer, -8, 2, 0, 0.0f, 0.15625f, 0, 1, 0, p_113844_);
        }
        p_113842_.popPose();
        super.render(p_113839_, p_113840_, p_113841_, p_113842_, p_113843_, p_113844_);
    }

    public void vertex(Matrix4f p_254392_, Matrix3f p_254011_, VertexConsumer p_253902_, int p_254058_, int p_254338_, int p_254196_, float p_254003_, float p_254165_, int p_253982_, int p_254037_, int p_254038_, int p_254271_) {
        p_253902_.vertex(p_254392_, p_254058_, p_254338_, p_254196_).color(255, 255, 255, 255).uv(p_254003_, p_254165_).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(p_254271_).normal(p_254011_, p_253982_, p_254038_, p_254037_).endVertex();
    }
}

