/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.CodModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Cod;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CodRenderer
extends MobRenderer<Cod, CodModel<Cod>> {
    private static final ResourceLocation COD_LOCATION = new ResourceLocation("textures/entity/fish/cod.png");

    public CodRenderer(EntityRendererProvider.Context p_173954_) {
        super(p_173954_, new CodModel(p_173954_.bakeLayer(ModelLayers.COD)), 0.3f);
    }

    @Override
    public ResourceLocation getTextureLocation(Cod p_114015_) {
        return COD_LOCATION;
    }

    @Override
    protected void setupRotations(Cod p_114017_, PoseStack p_114018_, float p_114019_, float p_114020_, float p_114021_) {
        super.setupRotations(p_114017_, p_114018_, p_114019_, p_114020_, p_114021_);
        float f = 4.3f * Mth.sin(0.6f * p_114019_);
        p_114018_.mulPose(Axis.YP.rotationDegrees(f));
        if (!p_114017_.isInWater()) {
            p_114018_.translate(0.1f, 0.1f, -0.1f);
            p_114018_.mulPose(Axis.ZP.rotationDegrees(90.0f));
        }
    }
}

