/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderItemInFrameEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class ItemFrameRenderer<T extends ItemFrame>
extends EntityRenderer<T> {
    private static final ModelResourceLocation FRAME_LOCATION = ModelResourceLocation.vanilla("item_frame", "map=false");
    private static final ModelResourceLocation MAP_FRAME_LOCATION = ModelResourceLocation.vanilla("item_frame", "map=true");
    private static final ModelResourceLocation GLOW_FRAME_LOCATION = ModelResourceLocation.vanilla("glow_item_frame", "map=false");
    private static final ModelResourceLocation GLOW_MAP_FRAME_LOCATION = ModelResourceLocation.vanilla("glow_item_frame", "map=true");
    public static final int GLOW_FRAME_BRIGHTNESS = 5;
    public static final int BRIGHT_MAP_LIGHT_ADJUSTMENT = 30;
    private final ItemRenderer itemRenderer;
    private final BlockRenderDispatcher blockRenderer;

    public ItemFrameRenderer(EntityRendererProvider.Context p_174204_) {
        super(p_174204_);
        this.itemRenderer = p_174204_.getItemRenderer();
        this.blockRenderer = p_174204_.getBlockRenderDispatcher();
    }

    @Override
    protected int getBlockLightLevel(T p_174216_, BlockPos p_174217_) {
        return ((Entity)p_174216_).getType() == EntityType.GLOW_ITEM_FRAME ? Math.max(5, super.getBlockLightLevel(p_174216_, p_174217_)) : super.getBlockLightLevel(p_174216_, p_174217_);
    }

    @Override
    public void render(T p_115076_, float p_115077_, float p_115078_, PoseStack p_115079_, MultiBufferSource p_115080_, int p_115081_) {
        super.render(p_115076_, p_115077_, p_115078_, p_115079_, p_115080_, p_115081_);
        p_115079_.pushPose();
        Direction direction = ((HangingEntity)p_115076_).getDirection();
        Vec3 vec3 = this.getRenderOffset(p_115076_, p_115078_);
        p_115079_.translate(-vec3.x(), -vec3.y(), -vec3.z());
        double d0 = 0.46875;
        p_115079_.translate((double)direction.getStepX() * 0.46875, (double)direction.getStepY() * 0.46875, (double)direction.getStepZ() * 0.46875);
        p_115079_.mulPose(Axis.XP.rotationDegrees(((Entity)p_115076_).getXRot()));
        p_115079_.mulPose(Axis.YP.rotationDegrees(180.0f - ((Entity)p_115076_).getYRot()));
        boolean flag = ((Entity)p_115076_).isInvisible();
        ItemStack itemstack = ((ItemFrame)p_115076_).getItem();
        if (!flag) {
            ModelManager modelmanager = this.blockRenderer.getBlockModelShaper().getModelManager();
            ModelResourceLocation modelresourcelocation = this.getFrameModelResourceLoc(p_115076_, itemstack);
            p_115079_.pushPose();
            p_115079_.translate(-0.5f, -0.5f, -0.5f);
            this.blockRenderer.getModelRenderer().renderModel(p_115079_.last(), p_115080_.getBuffer(Sheets.solidBlockSheet()), null, modelmanager.getModel(modelresourcelocation), 1.0f, 1.0f, 1.0f, p_115081_, OverlayTexture.NO_OVERLAY);
            p_115079_.popPose();
        }
        if (!itemstack.isEmpty()) {
            MapItemSavedData mapitemsaveddata = MapItem.getSavedData(itemstack, ((Entity)p_115076_).level());
            if (flag) {
                p_115079_.translate(0.0f, 0.0f, 0.5f);
            } else {
                p_115079_.translate(0.0f, 0.0f, 0.4375f);
            }
            int j = mapitemsaveddata != null ? ((ItemFrame)p_115076_).getRotation() % 4 * 2 : ((ItemFrame)p_115076_).getRotation();
            p_115079_.mulPose(Axis.ZP.rotationDegrees((float)j * 360.0f / 8.0f));
            if (!MinecraftForge.EVENT_BUS.post((Event)new RenderItemInFrameEvent((ItemFrame)p_115076_, this, p_115079_, p_115080_, p_115081_))) {
                if (mapitemsaveddata != null) {
                    p_115079_.mulPose(Axis.ZP.rotationDegrees(180.0f));
                    float f = 0.0078125f;
                    p_115079_.scale(0.0078125f, 0.0078125f, 0.0078125f);
                    p_115079_.translate(-64.0f, -64.0f, 0.0f);
                    p_115079_.translate(0.0f, 0.0f, -1.0f);
                    if (mapitemsaveddata != null) {
                        int i = this.getLightVal(p_115076_, 15728850, p_115081_);
                        Minecraft.getInstance().gameRenderer.getMapRenderer().render(p_115079_, p_115080_, ((ItemFrame)p_115076_).getFramedMapId().getAsInt(), mapitemsaveddata, true, i);
                    }
                } else {
                    int k = this.getLightVal(p_115076_, 0xF000F0, p_115081_);
                    p_115079_.scale(0.5f, 0.5f, 0.5f);
                    this.itemRenderer.renderStatic(itemstack, ItemDisplayContext.FIXED, k, OverlayTexture.NO_OVERLAY, p_115079_, p_115080_, ((Entity)p_115076_).level(), ((Entity)p_115076_).getId());
                }
            }
        }
        p_115079_.popPose();
    }

    private int getLightVal(T p_174209_, int p_174210_, int p_174211_) {
        return ((Entity)p_174209_).getType() == EntityType.GLOW_ITEM_FRAME ? p_174210_ : p_174211_;
    }

    private ModelResourceLocation getFrameModelResourceLoc(T p_174213_, ItemStack p_174214_) {
        boolean flag;
        boolean bl = flag = ((Entity)p_174213_).getType() == EntityType.GLOW_ITEM_FRAME;
        if (p_174214_.getItem() instanceof MapItem) {
            return flag ? GLOW_MAP_FRAME_LOCATION : MAP_FRAME_LOCATION;
        }
        return flag ? GLOW_FRAME_LOCATION : FRAME_LOCATION;
    }

    @Override
    public Vec3 getRenderOffset(T p_115073_, float p_115074_) {
        return new Vec3((float)((HangingEntity)p_115073_).getDirection().getStepX() * 0.3f, -0.25, (float)((HangingEntity)p_115073_).getDirection().getStepZ() * 0.3f);
    }

    @Override
    public ResourceLocation getTextureLocation(T p_115071_) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    @Override
    protected boolean shouldShowName(T p_115091_) {
        if (Minecraft.renderNames() && !((ItemFrame)p_115091_).getItem().isEmpty() && ((ItemFrame)p_115091_).getItem().hasCustomHoverName() && this.entityRenderDispatcher.crosshairPickEntity == p_115091_) {
            double d0 = this.entityRenderDispatcher.distanceToSqr((Entity)p_115091_);
            float f = ((Entity)p_115091_).isDiscrete() ? 32.0f : 64.0f;
            return d0 < (double)(f * f);
        }
        return false;
    }

    @Override
    protected void renderNameTag(T p_115083_, Component p_115084_, PoseStack p_115085_, MultiBufferSource p_115086_, int p_115087_) {
        super.renderNameTag(p_115083_, ((ItemFrame)p_115083_).getItem().getHoverName(), p_115085_, p_115086_, p_115087_);
    }
}

