/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.MinecartModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MinecartRenderer<T extends AbstractMinecart>
extends EntityRenderer<T> {
    private static final ResourceLocation MINECART_LOCATION = new ResourceLocation("textures/entity/minecart.png");
    protected final EntityModel<T> model;
    private final BlockRenderDispatcher blockRenderer;

    public MinecartRenderer(EntityRendererProvider.Context p_174300_, ModelLayerLocation p_174301_) {
        super(p_174300_);
        this.shadowRadius = 0.7f;
        this.model = new MinecartModel(p_174300_.bakeLayer(p_174301_));
        this.blockRenderer = p_174300_.getBlockRenderDispatcher();
    }

    @Override
    public void render(T p_115418_, float p_115419_, float p_115420_, PoseStack p_115421_, MultiBufferSource p_115422_, int p_115423_) {
        super.render(p_115418_, p_115419_, p_115420_, p_115421_, p_115422_, p_115423_);
        p_115421_.pushPose();
        long i = (long)((Entity)p_115418_).getId() * 493286711L;
        i = i * i * 4392167121L + i * 98761L;
        float f = (((float)(i >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f1 = (((float)(i >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f2 = (((float)(i >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        p_115421_.translate(f, f1, f2);
        double d0 = Mth.lerp((double)p_115420_, ((AbstractMinecart)p_115418_).xOld, ((Entity)p_115418_).getX());
        double d1 = Mth.lerp((double)p_115420_, ((AbstractMinecart)p_115418_).yOld, ((Entity)p_115418_).getY());
        double d2 = Mth.lerp((double)p_115420_, ((AbstractMinecart)p_115418_).zOld, ((Entity)p_115418_).getZ());
        double d3 = 0.3f;
        Vec3 vec3 = ((AbstractMinecart)p_115418_).getPos(d0, d1, d2);
        float f3 = Mth.lerp(p_115420_, ((AbstractMinecart)p_115418_).xRotO, ((Entity)p_115418_).getXRot());
        if (vec3 != null) {
            Vec3 vec31 = ((AbstractMinecart)p_115418_).getPosOffs(d0, d1, d2, 0.3f);
            Vec3 vec32 = ((AbstractMinecart)p_115418_).getPosOffs(d0, d1, d2, -0.3f);
            if (vec31 == null) {
                vec31 = vec3;
            }
            if (vec32 == null) {
                vec32 = vec3;
            }
            p_115421_.translate(vec3.x - d0, (vec31.y + vec32.y) / 2.0 - d1, vec3.z - d2);
            Vec3 vec33 = vec32.add(-vec31.x, -vec31.y, -vec31.z);
            if (vec33.length() != 0.0) {
                vec33 = vec33.normalize();
                p_115419_ = (float)(Math.atan2(vec33.z, vec33.x) * 180.0 / Math.PI);
                f3 = (float)(Math.atan(vec33.y) * 73.0);
            }
        }
        p_115421_.translate(0.0f, 0.375f, 0.0f);
        p_115421_.mulPose(Axis.YP.rotationDegrees(180.0f - p_115419_));
        p_115421_.mulPose(Axis.ZP.rotationDegrees(-f3));
        float f5 = (float)((AbstractMinecart)p_115418_).getHurtTime() - p_115420_;
        float f6 = ((AbstractMinecart)p_115418_).getDamage() - p_115420_;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f5 > 0.0f) {
            p_115421_.mulPose(Axis.XP.rotationDegrees(Mth.sin(f5) * f5 * f6 / 10.0f * (float)((AbstractMinecart)p_115418_).getHurtDir()));
        }
        int j = ((AbstractMinecart)p_115418_).getDisplayOffset();
        BlockState blockstate = ((AbstractMinecart)p_115418_).getDisplayBlockState();
        if (blockstate.getRenderShape() != RenderShape.INVISIBLE) {
            p_115421_.pushPose();
            float f4 = 0.75f;
            p_115421_.scale(0.75f, 0.75f, 0.75f);
            p_115421_.translate(-0.5f, (float)(j - 8) / 16.0f, 0.5f);
            p_115421_.mulPose(Axis.YP.rotationDegrees(90.0f));
            this.renderMinecartContents(p_115418_, p_115420_, blockstate, p_115421_, p_115422_, p_115423_);
            p_115421_.popPose();
        }
        p_115421_.scale(-1.0f, -1.0f, 1.0f);
        this.model.setupAnim(p_115418_, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = p_115422_.getBuffer(this.model.renderType(this.getTextureLocation(p_115418_)));
        this.model.renderToBuffer(p_115421_, vertexconsumer, p_115423_, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
        p_115421_.popPose();
    }

    @Override
    public ResourceLocation getTextureLocation(T p_115416_) {
        return MINECART_LOCATION;
    }

    protected void renderMinecartContents(T p_115424_, float p_115425_, BlockState p_115426_, PoseStack p_115427_, MultiBufferSource p_115428_, int p_115429_) {
        this.blockRenderer.renderSingleBlock(p_115426_, p_115427_, p_115428_, p_115429_, OverlayTexture.NO_OVERLAY);
    }
}

