/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CustomHeadLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final float scaleX;
    private final float scaleY;
    private final float scaleZ;
    private final Map<SkullBlock.Type, SkullModelBase> skullModels;
    private final ItemInHandRenderer itemInHandRenderer;

    public CustomHeadLayer(RenderLayerParent<T, M> p_234829_, EntityModelSet p_234830_, ItemInHandRenderer p_234831_) {
        this(p_234829_, p_234830_, 1.0f, 1.0f, 1.0f, p_234831_);
    }

    public CustomHeadLayer(RenderLayerParent<T, M> p_234822_, EntityModelSet p_234823_, float p_234824_, float p_234825_, float p_234826_, ItemInHandRenderer p_234827_) {
        super(p_234822_);
        this.scaleX = p_234824_;
        this.scaleY = p_234825_;
        this.scaleZ = p_234826_;
        this.skullModels = SkullBlockRenderer.createSkullRenderers(p_234823_);
        this.itemInHandRenderer = p_234827_;
    }

    @Override
    public void render(PoseStack p_116731_, MultiBufferSource p_116732_, int p_116733_, T p_116734_, float p_116735_, float p_116736_, float p_116737_, float p_116738_, float p_116739_, float p_116740_) {
        ItemStack itemstack = ((LivingEntity)p_116734_).getItemBySlot(EquipmentSlot.HEAD);
        if (!itemstack.isEmpty()) {
            ArmorItem armoritem;
            boolean flag;
            Item item = itemstack.getItem();
            p_116731_.pushPose();
            p_116731_.scale(this.scaleX, this.scaleY, this.scaleZ);
            boolean bl = flag = p_116734_ instanceof Villager || p_116734_ instanceof ZombieVillager;
            if (((LivingEntity)p_116734_).isBaby() && !(p_116734_ instanceof Villager)) {
                float f = 2.0f;
                float f1 = 1.4f;
                p_116731_.translate(0.0f, 0.03125f, 0.0f);
                p_116731_.scale(0.7f, 0.7f, 0.7f);
                p_116731_.translate(0.0f, 1.0f, 0.0f);
            }
            ((HeadedModel)this.getParentModel()).getHead().translateAndRotate(p_116731_);
            if (item instanceof BlockItem && ((BlockItem)item).getBlock() instanceof AbstractSkullBlock) {
                WalkAnimationState walkanimationstate;
                CompoundTag compoundtag;
                float f2 = 1.1875f;
                p_116731_.scale(1.1875f, -1.1875f, -1.1875f);
                if (flag) {
                    p_116731_.translate(0.0f, 0.0625f, 0.0f);
                }
                GameProfile gameprofile = null;
                if (itemstack.hasTag() && (compoundtag = itemstack.getTag()).contains("SkullOwner", 10)) {
                    gameprofile = NbtUtils.readGameProfile(compoundtag.getCompound("SkullOwner"));
                }
                p_116731_.translate(-0.5, 0.0, -0.5);
                SkullBlock.Type skullblock$type = ((AbstractSkullBlock)((BlockItem)item).getBlock()).getType();
                SkullModelBase skullmodelbase = this.skullModels.get(skullblock$type);
                RenderType rendertype = SkullBlockRenderer.getRenderType(skullblock$type, gameprofile);
                Entity entity = ((Entity)p_116734_).getVehicle();
                if (entity instanceof LivingEntity) {
                    LivingEntity livingentity = (LivingEntity)entity;
                    walkanimationstate = livingentity.walkAnimation;
                } else {
                    walkanimationstate = ((LivingEntity)p_116734_).walkAnimation;
                }
                float f3 = walkanimationstate.position(p_116737_);
                SkullBlockRenderer.renderSkull(null, 180.0f, f3, p_116731_, p_116732_, p_116733_, skullmodelbase, rendertype);
            } else if (!(item instanceof ArmorItem) || (armoritem = (ArmorItem)item).getEquipmentSlot() != EquipmentSlot.HEAD) {
                CustomHeadLayer.translateToHead(p_116731_, flag);
                this.itemInHandRenderer.renderItem((LivingEntity)p_116734_, itemstack, ItemDisplayContext.HEAD, false, p_116731_, p_116732_, p_116733_);
            }
            p_116731_.popPose();
        }
    }

    public static void translateToHead(PoseStack p_174484_, boolean p_174485_) {
        float f = 0.625f;
        p_174484_.translate(0.0f, -0.25f, 0.0f);
        p_174484_.mulPose(Axis.YP.rotationDegrees(180.0f));
        p_174484_.scale(0.625f, -0.625f, -0.625f);
        if (p_174485_) {
            p_174484_.translate(0.0f, 0.1875f, 0.0f);
        }
    }
}

