/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.item;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.CompassItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.Holder;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LightBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemProperties {
    private static final Map<ResourceLocation, ItemPropertyFunction> GENERIC_PROPERTIES = Maps.newHashMap();
    private static final String TAG_CUSTOM_MODEL_DATA = "CustomModelData";
    private static final ResourceLocation DAMAGED = new ResourceLocation("damaged");
    private static final ResourceLocation DAMAGE = new ResourceLocation("damage");
    private static final ClampedItemPropertyFunction PROPERTY_DAMAGED = (p_174660_, p_174661_, p_174662_, p_174663_) -> p_174660_.isDamaged() ? 1.0f : 0.0f;
    private static final ClampedItemPropertyFunction PROPERTY_DAMAGE = (p_174655_, p_174656_, p_174657_, p_174658_) -> Mth.clamp((float)p_174655_.getDamageValue() / (float)p_174655_.getMaxDamage(), 0.0f, 1.0f);
    private static final Map<Item, Map<ResourceLocation, ItemPropertyFunction>> PROPERTIES = Maps.newHashMap();

    private static ClampedItemPropertyFunction registerGeneric(ResourceLocation p_174582_, ClampedItemPropertyFunction p_174583_) {
        return (ClampedItemPropertyFunction)ItemProperties.registerGeneric(p_174582_, (ItemPropertyFunction)p_174583_);
    }

    public static ItemPropertyFunction registerGeneric(ResourceLocation p_174582_, ItemPropertyFunction p_174583_) {
        GENERIC_PROPERTIES.put(p_174582_, p_174583_);
        return p_174583_;
    }

    private static void registerCustomModelData(ItemPropertyFunction p_174580_) {
        GENERIC_PROPERTIES.put(new ResourceLocation("custom_model_data"), p_174580_);
    }

    private static void register(Item p_174571_, ResourceLocation p_174572_, ClampedItemPropertyFunction p_174573_) {
        ItemProperties.register(p_174571_, p_174572_, (ItemPropertyFunction)p_174573_);
    }

    public static void register(Item p_174571_, ResourceLocation p_174572_, ItemPropertyFunction p_174573_) {
        PROPERTIES.computeIfAbsent(p_174571_, p_117828_ -> Maps.newHashMap()).put(p_174572_, p_174573_);
    }

    @Nullable
    public static ItemPropertyFunction getProperty(Item p_117830_, ResourceLocation p_117831_) {
        ItemPropertyFunction itempropertyfunction;
        if (p_117830_.getMaxDamage() > 0) {
            if (DAMAGE.equals(p_117831_)) {
                return PROPERTY_DAMAGE;
            }
            if (DAMAGED.equals(p_117831_)) {
                return PROPERTY_DAMAGED;
            }
        }
        if ((itempropertyfunction = GENERIC_PROPERTIES.get(p_117831_)) != null) {
            return itempropertyfunction;
        }
        Map<ResourceLocation, ItemPropertyFunction> map = PROPERTIES.get(p_117830_);
        return map == null ? null : map.get(p_117831_);
    }

    static {
        ItemProperties.registerGeneric(new ResourceLocation("lefthanded"), (ItemStack p_174650_, ClientLevel p_174651_, LivingEntity p_174652_, int p_174653_) -> p_174652_ != null && p_174652_.getMainArm() != HumanoidArm.RIGHT ? 1.0f : 0.0f);
        ItemProperties.registerGeneric(new ResourceLocation("cooldown"), (ItemStack p_174645_, ClientLevel p_174646_, LivingEntity p_174647_, int p_174648_) -> p_174647_ instanceof Player ? ((Player)p_174647_).getCooldowns().getCooldownPercent(p_174645_.getItem(), 0.0f) : 0.0f);
        ClampedItemPropertyFunction clampeditempropertyfunction = (p_289244_, p_289245_, p_289246_, p_289247_) -> {
            if (!p_289244_.is(ItemTags.TRIMMABLE_ARMOR)) {
                return Float.NEGATIVE_INFINITY;
            }
            return p_289245_ == null ? 0.0f : ArmorTrim.getTrim(p_289245_.registryAccess(), p_289244_).map(ArmorTrim::material).map(Holder::value).map(TrimMaterial::itemModelIndex).orElse(Float.valueOf(0.0f)).floatValue();
        };
        ItemProperties.registerGeneric(ItemModelGenerators.TRIM_TYPE_PREDICATE_ID, clampeditempropertyfunction);
        ItemProperties.registerCustomModelData((p_174640_, p_174641_, p_174642_, p_174643_) -> p_174640_.hasTag() ? (float)p_174640_.getTag().getInt(TAG_CUSTOM_MODEL_DATA) : 0.0f);
        ItemProperties.register(Items.BOW, new ResourceLocation("pull"), (ItemStack p_174635_, ClientLevel p_174636_, LivingEntity p_174637_, int p_174638_) -> {
            if (p_174637_ == null) {
                return 0.0f;
            }
            return p_174637_.getUseItem() != p_174635_ ? 0.0f : (float)(p_174635_.getUseDuration() - p_174637_.getUseItemRemainingTicks()) / 20.0f;
        });
        ItemProperties.register(Items.BRUSH, new ResourceLocation("brushing"), (ItemStack p_272332_, ClientLevel p_272333_, LivingEntity p_272334_, int p_272335_) -> p_272334_ != null && p_272334_.getUseItem() == p_272332_ ? (float)(p_272334_.getUseItemRemainingTicks() % 10) / 10.0f : 0.0f);
        ItemProperties.register(Items.BOW, new ResourceLocation("pulling"), (ItemStack p_174630_, ClientLevel p_174631_, LivingEntity p_174632_, int p_174633_) -> p_174632_ != null && p_174632_.isUsingItem() && p_174632_.getUseItem() == p_174630_ ? 1.0f : 0.0f);
        ItemProperties.register(Items.BUNDLE, new ResourceLocation("filled"), (ItemStack p_174625_, ClientLevel p_174626_, LivingEntity p_174627_, int p_174628_) -> BundleItem.getFullnessDisplay(p_174625_));
        ItemProperties.register(Items.CLOCK, new ResourceLocation("time"), new ClampedItemPropertyFunction(){
            private double rotation;
            private double rota;
            private long lastUpdateTick;

            @Override
            public float unclampedCall(ItemStack p_174665_, @Nullable ClientLevel p_174666_, @Nullable LivingEntity p_174667_, int p_174668_) {
                Entity entity;
                Entity entity2 = entity = p_174667_ != null ? p_174667_ : p_174665_.getEntityRepresentation();
                if (entity == null) {
                    return 0.0f;
                }
                if (p_174666_ == null && entity.level() instanceof ClientLevel) {
                    p_174666_ = (ClientLevel)entity.level();
                }
                if (p_174666_ == null) {
                    return 0.0f;
                }
                double d0 = p_174666_.dimensionType().natural() ? (double)p_174666_.getTimeOfDay(1.0f) : Math.random();
                d0 = this.wobble(p_174666_, d0);
                return (float)d0;
            }

            private double wobble(Level p_117904_, double p_117905_) {
                if (p_117904_.getGameTime() != this.lastUpdateTick) {
                    this.lastUpdateTick = p_117904_.getGameTime();
                    double d0 = p_117905_ - this.rotation;
                    d0 = Mth.positiveModulo(d0 + 0.5, 1.0) - 0.5;
                    this.rota += d0 * 0.1;
                    this.rota *= 0.9;
                    this.rotation = Mth.positiveModulo(this.rotation + this.rota, 1.0);
                }
                return this.rotation;
            }
        });
        ItemProperties.register(Items.COMPASS, new ResourceLocation("angle"), new CompassItemPropertyFunction((p_234992_, p_234993_, p_234994_) -> CompassItem.isLodestoneCompass(p_234993_) ? CompassItem.getLodestonePosition(p_234993_.getOrCreateTag()) : CompassItem.getSpawnPosition(p_234992_)));
        ItemProperties.register(Items.RECOVERY_COMPASS, new ResourceLocation("angle"), new CompassItemPropertyFunction((p_234983_, p_234984_, p_234985_) -> {
            if (p_234985_ instanceof Player) {
                Player player = (Player)p_234985_;
                return player.getLastDeathLocation().orElse(null);
            }
            return null;
        }));
        ItemProperties.register(Items.CROSSBOW, new ResourceLocation("pull"), (ItemStack p_174610_, ClientLevel p_174611_, LivingEntity p_174612_, int p_174613_) -> {
            if (p_174612_ == null) {
                return 0.0f;
            }
            return CrossbowItem.isCharged(p_174610_) ? 0.0f : (float)(p_174610_.getUseDuration() - p_174612_.getUseItemRemainingTicks()) / (float)CrossbowItem.getChargeDuration(p_174610_);
        });
        ItemProperties.register(Items.CROSSBOW, new ResourceLocation("pulling"), (ItemStack p_174605_, ClientLevel p_174606_, LivingEntity p_174607_, int p_174608_) -> p_174607_ != null && p_174607_.isUsingItem() && p_174607_.getUseItem() == p_174605_ && !CrossbowItem.isCharged(p_174605_) ? 1.0f : 0.0f);
        ItemProperties.register(Items.CROSSBOW, new ResourceLocation("charged"), (ItemStack p_275891_, ClientLevel p_275892_, LivingEntity p_275893_, int p_275894_) -> CrossbowItem.isCharged(p_275891_) ? 1.0f : 0.0f);
        ItemProperties.register(Items.CROSSBOW, new ResourceLocation("firework"), (ItemStack p_275887_, ClientLevel p_275888_, LivingEntity p_275889_, int p_275890_) -> CrossbowItem.isCharged(p_275887_) && CrossbowItem.containsChargedProjectile(p_275887_, Items.FIREWORK_ROCKET) ? 1.0f : 0.0f);
        ItemProperties.register(Items.ELYTRA, new ResourceLocation("broken"), (ItemStack p_174590_, ClientLevel p_174591_, LivingEntity p_174592_, int p_174593_) -> ElytraItem.isFlyEnabled(p_174590_) ? 0.0f : 1.0f);
        ItemProperties.register(Items.FISHING_ROD, new ResourceLocation("cast"), (ItemStack p_174585_, ClientLevel p_174586_, LivingEntity p_174587_, int p_174588_) -> {
            boolean flag1;
            if (p_174587_ == null) {
                return 0.0f;
            }
            boolean flag = p_174587_.getMainHandItem() == p_174585_;
            boolean bl = flag1 = p_174587_.getOffhandItem() == p_174585_;
            if (p_174587_.getMainHandItem().getItem() instanceof FishingRodItem) {
                flag1 = false;
            }
            return (flag || flag1) && p_174587_ instanceof Player && ((Player)p_174587_).fishing != null ? 1.0f : 0.0f;
        });
        ItemProperties.register(Items.SHIELD, new ResourceLocation("blocking"), (ItemStack p_174575_, ClientLevel p_174576_, LivingEntity p_174577_, int p_174578_) -> p_174577_ != null && p_174577_.isUsingItem() && p_174577_.getUseItem() == p_174575_ ? 1.0f : 0.0f);
        ItemProperties.register(Items.TRIDENT, new ResourceLocation("throwing"), (ItemStack p_234996_, ClientLevel p_234997_, LivingEntity p_234998_, int p_234999_) -> p_234998_ != null && p_234998_.isUsingItem() && p_234998_.getUseItem() == p_234996_ ? 1.0f : 0.0f);
        ItemProperties.register(Items.LIGHT, new ResourceLocation("level"), (ItemStack p_234987_, ClientLevel p_234988_, LivingEntity p_234989_, int p_234990_) -> {
            CompoundTag compoundtag = p_234987_.getTagElement("BlockStateTag");
            try {
                Tag tag;
                if (compoundtag != null && (tag = compoundtag.get(LightBlock.LEVEL.getName())) != null) {
                    return (float)Integer.parseInt(tag.getAsString()) / 16.0f;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return 1.0f;
        });
        ItemProperties.register(Items.GOAT_HORN, new ResourceLocation("tooting"), (ItemStack p_234978_, ClientLevel p_234979_, LivingEntity p_234980_, int p_234981_) -> p_234980_ != null && p_234980_.isUsingItem() && p_234980_.getUseItem() == p_234978_ ? 1.0f : 0.0f);
    }
}

