/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.searchtree;

import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.client.searchtree.SuffixArray;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface PlainTextSearchTree<T> {
    public static <T> PlainTextSearchTree<T> empty() {
        return p_235196_ -> List.of();
    }

    public static <T> PlainTextSearchTree<T> create(List<T> p_235198_, Function<T, Stream<String>> p_235199_) {
        if (p_235198_.isEmpty()) {
            return PlainTextSearchTree.empty();
        }
        SuffixArray suffixarray = new SuffixArray();
        for (Object t : p_235198_) {
            p_235199_.apply(t).forEach(p_235194_ -> suffixarray.add(t, p_235194_.toLowerCase(Locale.ROOT)));
        }
        suffixarray.generate();
        return suffixarray::search;
    }

    public List<T> search(String var1);
}

