/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlagSet;

public interface CommandBuildContext {
    public <T> HolderLookup<T> holderLookup(ResourceKey<? extends Registry<T>> var1);

    public static CommandBuildContext simple(final HolderLookup.Provider p_255702_, final FeatureFlagSet p_255968_) {
        return new CommandBuildContext(){

            @Override
            public <T> HolderLookup<T> holderLookup(ResourceKey<? extends Registry<T>> p_255791_) {
                return p_255702_.lookupOrThrow(p_255791_).filterFeatures(p_255968_);
            }
        };
    }

    public static Configurable configurable(final RegistryAccess p_255925_, final FeatureFlagSet p_255945_) {
        return new Configurable(){
            MissingTagAccessPolicy missingTagAccessPolicy = MissingTagAccessPolicy.FAIL;

            @Override
            public void missingTagAccessPolicy(MissingTagAccessPolicy p_256626_) {
                this.missingTagAccessPolicy = p_256626_;
            }

            @Override
            public <T> HolderLookup<T> holderLookup(ResourceKey<? extends Registry<T>> p_256616_) {
                Registry registry = p_255925_.registryOrThrow(p_256616_);
                final HolderLookup.RegistryLookup registrylookup = registry.asLookup();
                final HolderLookup.RegistryLookup registrylookup1 = registry.asTagAddingLookup();
                HolderLookup.RegistryLookup.Delegate registrylookup2 = new HolderLookup.RegistryLookup.Delegate<T>(){

                    @Override
                    protected HolderLookup.RegistryLookup<T> parent() {
                        return switch (missingTagAccessPolicy) {
                            case MissingTagAccessPolicy.FAIL -> registrylookup;
                            case MissingTagAccessPolicy.CREATE_NEW -> registrylookup1;
                            default -> throw new IncompatibleClassChangeError();
                        };
                    }
                };
                return registrylookup2.filterFeatures(p_255945_);
            }
        };
    }

    public static enum MissingTagAccessPolicy {
        CREATE_NEW,
        FAIL;

    }

    public static interface Configurable
    extends CommandBuildContext {
        public void missingTagAccessPolicy(MissingTagAccessPolicy var1);
    }
}

