/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;

public class ScoreHolderArgument
implements ArgumentType<Result> {
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_SCORE_HOLDERS = (p_108221_, p_108222_) -> {
        StringReader stringreader = new StringReader(p_108222_.getInput());
        stringreader.setCursor(p_108222_.getStart());
        EntitySelectorParser entityselectorparser = new EntitySelectorParser(stringreader);
        try {
            entityselectorparser.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return entityselectorparser.fillSuggestions(p_108222_, p_171606_ -> SharedSuggestionProvider.suggest(((CommandSourceStack)p_108221_.getSource()).getOnlinePlayerNames(), p_171606_));
    };
    private static final Collection<String> EXAMPLES = Arrays.asList("Player", "0123", "*", "@e");
    private static final SimpleCommandExceptionType ERROR_NO_RESULTS = new SimpleCommandExceptionType((Message)Component.translatable("argument.scoreHolder.empty"));
    final boolean multiple;

    public ScoreHolderArgument(boolean p_108216_) {
        this.multiple = p_108216_;
    }

    public static String getName(CommandContext<CommandSourceStack> p_108224_, String p_108225_) throws CommandSyntaxException {
        return ScoreHolderArgument.getNames(p_108224_, p_108225_).iterator().next();
    }

    public static Collection<String> getNames(CommandContext<CommandSourceStack> p_108244_, String p_108245_) throws CommandSyntaxException {
        return ScoreHolderArgument.getNames(p_108244_, p_108245_, Collections::emptyList);
    }

    public static Collection<String> getNamesWithDefaultWildcard(CommandContext<CommandSourceStack> p_108247_, String p_108248_) throws CommandSyntaxException {
        return ScoreHolderArgument.getNames(p_108247_, p_108248_, ((CommandSourceStack)p_108247_.getSource()).getServer().getScoreboard()::getTrackedPlayers);
    }

    public static Collection<String> getNames(CommandContext<CommandSourceStack> p_108227_, String p_108228_, Supplier<Collection<String>> p_108229_) throws CommandSyntaxException {
        Collection<String> collection = ((Result)p_108227_.getArgument(p_108228_, Result.class)).getNames((CommandSourceStack)p_108227_.getSource(), p_108229_);
        if (collection.isEmpty()) {
            throw EntityArgument.NO_ENTITIES_FOUND.create();
        }
        return collection;
    }

    public static ScoreHolderArgument scoreHolder() {
        return new ScoreHolderArgument(false);
    }

    public static ScoreHolderArgument scoreHolders() {
        return new ScoreHolderArgument(true);
    }

    public Result parse(StringReader p_108219_) throws CommandSyntaxException {
        if (p_108219_.canRead() && p_108219_.peek() == '@') {
            EntitySelectorParser entityselectorparser = new EntitySelectorParser(p_108219_);
            EntitySelector entityselector = entityselectorparser.parse();
            if (!this.multiple && entityselector.getMaxResults() > 1) {
                throw EntityArgument.ERROR_NOT_SINGLE_ENTITY.create();
            }
            return new SelectorResult(entityselector);
        }
        int i = p_108219_.getCursor();
        while (p_108219_.canRead() && p_108219_.peek() != ' ') {
            p_108219_.skip();
        }
        String s = p_108219_.getString().substring(i, p_108219_.getCursor());
        if (s.equals("*")) {
            return (p_108231_, p_108232_) -> {
                Collection collection1 = (Collection)p_108232_.get();
                if (collection1.isEmpty()) {
                    throw ERROR_NO_RESULTS.create();
                }
                return collection1;
            };
        }
        Set<String> collection = Collections.singleton(s);
        return (p_108237_, p_108238_) -> collection;
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    @FunctionalInterface
    public static interface Result {
        public Collection<String> getNames(CommandSourceStack var1, Supplier<Collection<String>> var2) throws CommandSyntaxException;
    }

    public static class SelectorResult
    implements Result {
        private final EntitySelector selector;

        public SelectorResult(EntitySelector p_108256_) {
            this.selector = p_108256_;
        }

        @Override
        public Collection<String> getNames(CommandSourceStack p_108258_, Supplier<Collection<String>> p_108259_) throws CommandSyntaxException {
            List<? extends Entity> list = this.selector.findEntities(p_108258_);
            if (list.isEmpty()) {
                throw EntityArgument.NO_ENTITIES_FOUND.create();
            }
            ArrayList list1 = Lists.newArrayList();
            for (Entity entity : list) {
                list1.add(entity.getScoreboardName());
            }
            return list1;
        }
    }

    public static class Info
    implements ArgumentTypeInfo<ScoreHolderArgument, Template> {
        private static final byte FLAG_MULTIPLE = 1;

        @Override
        public void serializeToNetwork(Template p_233469_, FriendlyByteBuf p_233470_) {
            int i = 0;
            if (p_233469_.multiple) {
                i |= 1;
            }
            p_233470_.writeByte(i);
        }

        @Override
        public Template deserializeFromNetwork(FriendlyByteBuf p_233480_) {
            byte b0 = p_233480_.readByte();
            boolean flag = (b0 & 1) != 0;
            return new Template(flag);
        }

        @Override
        public void serializeToJson(Template p_233466_, JsonObject p_233467_) {
            p_233467_.addProperty("amount", p_233466_.multiple ? "multiple" : "single");
        }

        @Override
        public Template unpack(ScoreHolderArgument p_233472_) {
            return new Template(p_233472_.multiple);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<ScoreHolderArgument> {
            final boolean multiple;

            Template(boolean p_233487_) {
                this.multiple = p_233487_;
            }

            @Override
            public ScoreHolderArgument instantiate(CommandBuildContext p_233490_) {
                return new ScoreHolderArgument(this.multiple);
            }

            @Override
            public ArgumentTypeInfo<ScoreHolderArgument, ?> type() {
                return Info.this;
            }
        }
    }
}

