/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Iterators;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

public enum Direction implements StringRepresentable
{
    DOWN(0, 1, -1, "down", AxisDirection.NEGATIVE, Axis.Y, new Vec3i(0, -1, 0)),
    UP(1, 0, -1, "up", AxisDirection.POSITIVE, Axis.Y, new Vec3i(0, 1, 0)),
    NORTH(2, 3, 2, "north", AxisDirection.NEGATIVE, Axis.Z, new Vec3i(0, 0, -1)),
    SOUTH(3, 2, 0, "south", AxisDirection.POSITIVE, Axis.Z, new Vec3i(0, 0, 1)),
    WEST(4, 5, 1, "west", AxisDirection.NEGATIVE, Axis.X, new Vec3i(-1, 0, 0)),
    EAST(5, 4, 3, "east", AxisDirection.POSITIVE, Axis.X, new Vec3i(1, 0, 0));

    public static final StringRepresentable.EnumCodec<Direction> CODEC;
    public static final Codec<Direction> VERTICAL_CODEC;
    private final int data3d;
    private final int oppositeIndex;
    private final int data2d;
    private final String name;
    private final Axis axis;
    private final AxisDirection axisDirection;
    private final Vec3i normal;
    private static final Direction[] VALUES;
    private static final Direction[] BY_3D_DATA;
    private static final Direction[] BY_2D_DATA;

    private Direction(int p_122356_, int p_122357_, int p_122358_, String p_122359_, AxisDirection p_122360_, Axis p_122361_, Vec3i p_122362_) {
        this.data3d = p_122356_;
        this.data2d = p_122358_;
        this.oppositeIndex = p_122357_;
        this.name = p_122359_;
        this.axis = p_122361_;
        this.axisDirection = p_122360_;
        this.normal = p_122362_;
    }

    public static Direction[] orderedByNearest(Entity p_122383_) {
        Direction direction2;
        float f = p_122383_.getViewXRot(1.0f) * ((float)Math.PI / 180);
        float f1 = -p_122383_.getViewYRot(1.0f) * ((float)Math.PI / 180);
        float f2 = Mth.sin(f);
        float f3 = Mth.cos(f);
        float f4 = Mth.sin(f1);
        float f5 = Mth.cos(f1);
        boolean flag = f4 > 0.0f;
        boolean flag1 = f2 < 0.0f;
        boolean flag2 = f5 > 0.0f;
        float f6 = flag ? f4 : -f4;
        float f7 = flag1 ? -f2 : f2;
        float f8 = flag2 ? f5 : -f5;
        float f9 = f6 * f3;
        float f10 = f8 * f3;
        Direction direction = flag ? EAST : WEST;
        Direction direction1 = flag1 ? UP : DOWN;
        Direction direction3 = direction2 = flag2 ? SOUTH : NORTH;
        if (f6 > f8) {
            if (f7 > f9) {
                return Direction.makeDirectionArray(direction1, direction, direction2);
            }
            return f10 > f7 ? Direction.makeDirectionArray(direction, direction2, direction1) : Direction.makeDirectionArray(direction, direction1, direction2);
        }
        if (f7 > f10) {
            return Direction.makeDirectionArray(direction1, direction2, direction);
        }
        return f9 > f7 ? Direction.makeDirectionArray(direction2, direction, direction1) : Direction.makeDirectionArray(direction2, direction1, direction);
    }

    private static Direction[] makeDirectionArray(Direction p_122399_, Direction p_122400_, Direction p_122401_) {
        return new Direction[]{p_122399_, p_122400_, p_122401_, p_122401_.getOpposite(), p_122400_.getOpposite(), p_122399_.getOpposite()};
    }

    public static Direction rotate(Matrix4f p_254393_, Direction p_254252_) {
        Vec3i vec3i = p_254252_.getNormal();
        Vector4f vector4f = p_254393_.transform(new Vector4f((float)vec3i.getX(), (float)vec3i.getY(), (float)vec3i.getZ(), 0.0f));
        return Direction.getNearest(vector4f.x(), vector4f.y(), vector4f.z());
    }

    public static Collection<Direction> allShuffled(RandomSource p_235668_) {
        return Util.shuffledCopy(Direction.values(), p_235668_);
    }

    public static Stream<Direction> stream() {
        return Stream.of(VALUES);
    }

    public Quaternionf getRotation() {
        return switch (this) {
            case DOWN -> new Quaternionf().rotationX((float)Math.PI);
            case UP -> new Quaternionf();
            case NORTH -> new Quaternionf().rotationXYZ(1.5707964f, 0.0f, (float)Math.PI);
            case SOUTH -> new Quaternionf().rotationX(1.5707964f);
            case WEST -> new Quaternionf().rotationXYZ(1.5707964f, 0.0f, 1.5707964f);
            case EAST -> new Quaternionf().rotationXYZ(1.5707964f, 0.0f, -1.5707964f);
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public int get3DDataValue() {
        return this.data3d;
    }

    public int get2DDataValue() {
        return this.data2d;
    }

    public AxisDirection getAxisDirection() {
        return this.axisDirection;
    }

    public static Direction getFacingAxis(Entity p_175358_, Axis p_175359_) {
        return switch (p_175359_) {
            case Axis.X -> EAST.isFacingAngle(p_175358_.getViewYRot(1.0f)) ? EAST : WEST;
            case Axis.Z -> SOUTH.isFacingAngle(p_175358_.getViewYRot(1.0f)) ? SOUTH : NORTH;
            case Axis.Y -> p_175358_.getViewXRot(1.0f) < 0.0f ? UP : DOWN;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public Direction getOpposite() {
        return Direction.from3DDataValue(this.oppositeIndex);
    }

    public Direction getClockWise(Axis p_175363_) {
        return switch (p_175363_) {
            case Axis.X -> this != WEST && this != EAST ? this.getClockWiseX() : this;
            case Axis.Z -> this != NORTH && this != SOUTH ? this.getClockWiseZ() : this;
            case Axis.Y -> this != UP && this != DOWN ? this.getClockWise() : this;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public Direction getCounterClockWise(Axis p_175365_) {
        return switch (p_175365_) {
            case Axis.X -> this != WEST && this != EAST ? this.getCounterClockWiseX() : this;
            case Axis.Z -> this != NORTH && this != SOUTH ? this.getCounterClockWiseZ() : this;
            case Axis.Y -> this != UP && this != DOWN ? this.getCounterClockWise() : this;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public Direction getClockWise() {
        return switch (this) {
            case NORTH -> EAST;
            case SOUTH -> WEST;
            case WEST -> NORTH;
            case EAST -> SOUTH;
            default -> throw new IllegalStateException("Unable to get Y-rotated facing of " + String.valueOf(this));
        };
    }

    private Direction getClockWiseX() {
        return switch (this) {
            case DOWN -> SOUTH;
            case UP -> NORTH;
            case NORTH -> DOWN;
            case SOUTH -> UP;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + String.valueOf(this));
        };
    }

    private Direction getCounterClockWiseX() {
        return switch (this) {
            case DOWN -> NORTH;
            case UP -> SOUTH;
            case NORTH -> UP;
            case SOUTH -> DOWN;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + String.valueOf(this));
        };
    }

    private Direction getClockWiseZ() {
        return switch (this) {
            case DOWN -> WEST;
            case UP -> EAST;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + String.valueOf(this));
            case WEST -> UP;
            case EAST -> DOWN;
        };
    }

    private Direction getCounterClockWiseZ() {
        return switch (this) {
            case DOWN -> EAST;
            case UP -> WEST;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + String.valueOf(this));
            case WEST -> DOWN;
            case EAST -> UP;
        };
    }

    public Direction getCounterClockWise() {
        return switch (this) {
            case NORTH -> WEST;
            case SOUTH -> EAST;
            case WEST -> SOUTH;
            case EAST -> NORTH;
            default -> throw new IllegalStateException("Unable to get CCW facing of " + String.valueOf(this));
        };
    }

    public int getStepX() {
        return this.normal.getX();
    }

    public int getStepY() {
        return this.normal.getY();
    }

    public int getStepZ() {
        return this.normal.getZ();
    }

    public Vector3f step() {
        return new Vector3f((float)this.getStepX(), (float)this.getStepY(), (float)this.getStepZ());
    }

    public String getName() {
        return this.name;
    }

    public Axis getAxis() {
        return this.axis;
    }

    @Nullable
    public static Direction byName(@Nullable String p_122403_) {
        return CODEC.byName(p_122403_);
    }

    public static Direction from3DDataValue(int p_122377_) {
        return BY_3D_DATA[Mth.abs(p_122377_ % BY_3D_DATA.length)];
    }

    public static Direction from2DDataValue(int p_122408_) {
        return BY_2D_DATA[Mth.abs(p_122408_ % BY_2D_DATA.length)];
    }

    @Nullable
    public static Direction fromDelta(int p_278323_, int p_278296_, int p_278347_) {
        if (p_278323_ == 0) {
            if (p_278296_ == 0) {
                if (p_278347_ > 0) {
                    return SOUTH;
                }
                if (p_278347_ < 0) {
                    return NORTH;
                }
            } else if (p_278347_ == 0) {
                if (p_278296_ > 0) {
                    return UP;
                }
                return DOWN;
            }
        } else if (p_278296_ == 0 && p_278347_ == 0) {
            if (p_278323_ > 0) {
                return EAST;
            }
            return WEST;
        }
        return null;
    }

    public static Direction fromYRot(double p_122365_) {
        return Direction.from2DDataValue(Mth.floor(p_122365_ / 90.0 + 0.5) & 3);
    }

    public static Direction fromAxisAndDirection(Axis p_122388_, AxisDirection p_122389_) {
        return switch (p_122388_) {
            case Axis.X -> p_122389_ == AxisDirection.POSITIVE ? EAST : WEST;
            case Axis.Z -> p_122389_ == AxisDirection.POSITIVE ? SOUTH : NORTH;
            case Axis.Y -> p_122389_ == AxisDirection.POSITIVE ? UP : DOWN;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public float toYRot() {
        return (this.data2d & 3) * 90;
    }

    public static Direction getRandom(RandomSource p_235673_) {
        return Util.getRandom(VALUES, p_235673_);
    }

    public static Direction getNearest(double p_122367_, double p_122368_, double p_122369_) {
        return Direction.getNearest((float)p_122367_, (float)p_122368_, (float)p_122369_);
    }

    public static Direction getNearest(float p_122373_, float p_122374_, float p_122375_) {
        Direction direction = NORTH;
        float f = Float.MIN_VALUE;
        for (Direction direction1 : VALUES) {
            float f1 = p_122373_ * (float)direction1.normal.getX() + p_122374_ * (float)direction1.normal.getY() + p_122375_ * (float)direction1.normal.getZ();
            if (!(f1 > f)) continue;
            f = f1;
            direction = direction1;
        }
        return direction;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    private static DataResult<Direction> verifyVertical(Direction p_194529_) {
        return p_194529_.getAxis().isVertical() ? DataResult.success((Object)p_194529_) : DataResult.error(() -> "Expected a vertical direction");
    }

    public static Direction get(AxisDirection p_122391_, Axis p_122392_) {
        for (Direction direction : VALUES) {
            if (direction.getAxisDirection() != p_122391_ || direction.getAxis() != p_122392_) continue;
            return direction;
        }
        throw new IllegalArgumentException("No such direction: " + String.valueOf((Object)p_122391_) + " " + String.valueOf(p_122392_));
    }

    public Vec3i getNormal() {
        return this.normal;
    }

    public boolean isFacingAngle(float p_122371_) {
        float f = p_122371_ * ((float)Math.PI / 180);
        float f1 = -Mth.sin(f);
        float f2 = Mth.cos(f);
        return (float)this.normal.getX() * f1 + (float)this.normal.getZ() * f2 > 0.0f;
    }

    static {
        CODEC = StringRepresentable.fromEnum(Direction::values);
        VERTICAL_CODEC = ExtraCodecs.validate(CODEC, Direction::verifyVertical);
        VALUES = Direction.values();
        BY_3D_DATA = (Direction[])Arrays.stream(VALUES).sorted(Comparator.comparingInt(p_235687_ -> p_235687_.data3d)).toArray(Direction[]::new);
        BY_2D_DATA = (Direction[])Arrays.stream(VALUES).filter(p_235685_ -> p_235685_.getAxis().isHorizontal()).sorted(Comparator.comparingInt(p_235683_ -> p_235683_.data2d)).toArray(Direction[]::new);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Axis implements StringRepresentable,
    Predicate<Direction>
    {
        X("x"){

            @Override
            public int choose(int p_122496_, int p_122497_, int p_122498_) {
                return p_122496_;
            }

            @Override
            public double choose(double p_122492_, double p_122493_, double p_122494_) {
                return p_122492_;
            }
        }
        ,
        Y("y"){

            @Override
            public int choose(int p_122510_, int p_122511_, int p_122512_) {
                return p_122511_;
            }

            @Override
            public double choose(double p_122506_, double p_122507_, double p_122508_) {
                return p_122507_;
            }
        }
        ,
        Z("z"){

            @Override
            public int choose(int p_122524_, int p_122525_, int p_122526_) {
                return p_122526_;
            }

            @Override
            public double choose(double p_122520_, double p_122521_, double p_122522_) {
                return p_122522_;
            }
        };

        public static final Axis[] VALUES;
        public static final StringRepresentable.EnumCodec<Axis> CODEC;
        private final String name;

        private Axis(String p_122456_) {
            this.name = p_122456_;
        }

        @Nullable
        public static Axis byName(String p_122474_) {
            return CODEC.byName(p_122474_);
        }

        public String getName() {
            return this.name;
        }

        public boolean isVertical() {
            return this == Y;
        }

        public boolean isHorizontal() {
            return this == X || this == Z;
        }

        public String toString() {
            return this.name;
        }

        public static Axis getRandom(RandomSource p_235689_) {
            return Util.getRandom(VALUES, p_235689_);
        }

        @Override
        public boolean test(@Nullable Direction p_122472_) {
            return p_122472_ != null && p_122472_.getAxis() == this;
        }

        public Plane getPlane() {
            return switch (this) {
                case X, Z -> Plane.HORIZONTAL;
                case Y -> Plane.VERTICAL;
                default -> throw new IncompatibleClassChangeError();
            };
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public abstract int choose(int var1, int var2, int var3);

        public abstract double choose(double var1, double var3, double var5);

        static {
            VALUES = Axis.values();
            CODEC = StringRepresentable.fromEnum(Axis::values);
        }
    }

    public static enum AxisDirection {
        POSITIVE(1, "Towards positive"),
        NEGATIVE(-1, "Towards negative");

        private final int step;
        private final String name;

        private AxisDirection(int p_122538_, String p_122539_) {
            this.step = p_122538_;
            this.name = p_122539_;
        }

        public int getStep() {
            return this.step;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public AxisDirection opposite() {
            return this == POSITIVE ? NEGATIVE : POSITIVE;
        }
    }

    public static enum Plane implements Iterable<Direction>,
    Predicate<Direction>
    {
        HORIZONTAL(new Direction[]{NORTH, EAST, SOUTH, WEST}, new Axis[]{Axis.X, Axis.Z}),
        VERTICAL(new Direction[]{UP, DOWN}, new Axis[]{Axis.Y});

        private final Direction[] faces;
        private final Axis[] axis;

        private Plane(Direction[] p_122555_, Axis[] p_122556_) {
            this.faces = p_122555_;
            this.axis = p_122556_;
        }

        public Direction getRandomDirection(RandomSource p_235691_) {
            return Util.getRandom(this.faces, p_235691_);
        }

        public Axis getRandomAxis(RandomSource p_235693_) {
            return Util.getRandom(this.axis, p_235693_);
        }

        @Override
        public boolean test(@Nullable Direction p_122559_) {
            return p_122559_ != null && p_122559_.getAxis().getPlane() == this;
        }

        @Override
        public Iterator<Direction> iterator() {
            return Iterators.forArray((Object[])this.faces);
        }

        public Stream<Direction> stream() {
            return Arrays.stream(this.faces);
        }

        public List<Direction> shuffledCopy(RandomSource p_235695_) {
            return Util.shuffledCopy(this.faces, p_235695_);
        }
    }
}

