/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.Bootstrap;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class MappedRegistry<T>
implements WritableRegistry<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    final ResourceKey<? extends Registry<T>> key;
    private final ObjectList<Holder.Reference<T>> byId = new ObjectArrayList(256);
    private final Object2IntMap<T> toId = (Object2IntMap)Util.make(new Object2IntOpenCustomHashMap(Util.identityStrategy()), p_194539_ -> p_194539_.defaultReturnValue(-1));
    private final Map<ResourceLocation, Holder.Reference<T>> byLocation = new HashMap<ResourceLocation, Holder.Reference<T>>();
    private final Map<ResourceKey<T>, Holder.Reference<T>> byKey = new HashMap<ResourceKey<T>, Holder.Reference<T>>();
    private final Map<T, Holder.Reference<T>> byValue = new IdentityHashMap<T, Holder.Reference<T>>();
    private final Map<T, Lifecycle> lifecycles = new IdentityHashMap<T, Lifecycle>();
    private Lifecycle registryLifecycle;
    private volatile Map<TagKey<T>, HolderSet.Named<T>> tags = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>();
    private boolean frozen;
    @Nullable
    protected Map<T, Holder.Reference<T>> unregisteredIntrusiveHolders;
    @Nullable
    private List<Holder.Reference<T>> holdersInOrder;
    private int nextId;
    private final HolderLookup.RegistryLookup<T> lookup = new HolderLookup.RegistryLookup<T>(){

        @Override
        public ResourceKey<? extends Registry<? extends T>> key() {
            return MappedRegistry.this.key;
        }

        @Override
        public Lifecycle registryLifecycle() {
            return MappedRegistry.this.registryLifecycle();
        }

        @Override
        public Optional<Holder.Reference<T>> get(ResourceKey<T> p_255624_) {
            return MappedRegistry.this.getHolder(p_255624_);
        }

        @Override
        public Stream<Holder.Reference<T>> listElements() {
            return MappedRegistry.this.holders();
        }

        @Override
        public Optional<HolderSet.Named<T>> get(TagKey<T> p_256277_) {
            return MappedRegistry.this.getTag(p_256277_);
        }

        @Override
        public Stream<HolderSet.Named<T>> listTags() {
            return MappedRegistry.this.getTags().map(Pair::getSecond);
        }
    };
    private static final Set<ResourceLocation> KNOWN = new LinkedHashSet<ResourceLocation>();

    public MappedRegistry(ResourceKey<? extends Registry<T>> p_249899_, Lifecycle p_252249_) {
        this(p_249899_, p_252249_, false);
    }

    public MappedRegistry(ResourceKey<? extends Registry<T>> p_252132_, Lifecycle p_249215_, boolean p_251014_) {
        Bootstrap.checkBootstrapCalled(() -> "registry " + String.valueOf(p_252132_));
        this.key = p_252132_;
        this.registryLifecycle = p_249215_;
        if (p_251014_) {
            this.unregisteredIntrusiveHolders = new IdentityHashMap<T, Holder.Reference<T>>();
        }
    }

    @Override
    public ResourceKey<? extends Registry<T>> key() {
        return this.key;
    }

    public String toString() {
        return "Registry[" + String.valueOf(this.key) + " (" + String.valueOf(this.registryLifecycle) + ")]";
    }

    private List<Holder.Reference<T>> holdersInOrder() {
        if (this.holdersInOrder == null) {
            this.holdersInOrder = this.byId.stream().filter(Objects::nonNull).toList();
        }
        return this.holdersInOrder;
    }

    private void validateWrite() {
        if (this.frozen) {
            throw new IllegalStateException("Registry is already frozen");
        }
    }

    private void validateWrite(ResourceKey<T> p_205922_) {
        if (this.frozen) {
            throw new IllegalStateException("Registry is already frozen (trying to add key " + String.valueOf(p_205922_) + ")");
        }
    }

    public static Set<ResourceLocation> getKnownRegistries() {
        return Collections.unmodifiableSet(KNOWN);
    }

    protected final void markKnown() {
        KNOWN.add(this.key().location());
    }

    @Override
    public Holder.Reference<T> registerMapping(int p_256563_, ResourceKey<T> p_256594_, T p_256374_, Lifecycle p_256469_) {
        Holder.Reference reference;
        this.markKnown();
        this.validateWrite(p_256594_);
        Validate.notNull(p_256594_);
        Validate.notNull(p_256374_);
        if (this.byLocation.containsKey(p_256594_.location())) {
            Util.pauseInIde(new IllegalStateException("Adding duplicate key '" + String.valueOf(p_256594_) + "' to registry"));
        }
        if (this.byValue.containsKey(p_256374_)) {
            Util.pauseInIde(new IllegalStateException("Adding duplicate value '" + String.valueOf(p_256374_) + "' to registry"));
        }
        if (this.unregisteredIntrusiveHolders != null) {
            reference = this.unregisteredIntrusiveHolders.remove(p_256374_);
            if (reference == null) {
                throw new AssertionError((Object)("Missing intrusive holder for " + String.valueOf(p_256594_) + ":" + String.valueOf(p_256374_)));
            }
            reference.bindKey(p_256594_);
        } else {
            reference = this.byKey.computeIfAbsent(p_256594_, p_258168_ -> Holder.Reference.createStandAlone(this.holderOwner(), p_258168_));
            reference.bindValue(p_256374_);
        }
        this.byKey.put(p_256594_, reference);
        this.byLocation.put(p_256594_.location(), reference);
        this.byValue.put(p_256374_, reference);
        this.byId.size(Math.max(this.byId.size(), p_256563_ + 1));
        this.byId.set(p_256563_, (Object)reference);
        this.toId.put(p_256374_, p_256563_);
        if (this.nextId <= p_256563_) {
            this.nextId = p_256563_ + 1;
        }
        this.lifecycles.put(p_256374_, p_256469_);
        this.registryLifecycle = this.registryLifecycle.add(p_256469_);
        this.holdersInOrder = null;
        return reference;
    }

    @Override
    public Holder.Reference<T> register(ResourceKey<T> p_256252_, T p_256591_, Lifecycle p_256255_) {
        return this.registerMapping(this.nextId, (ResourceKey)p_256252_, (Object)p_256591_, p_256255_);
    }

    @Override
    @Nullable
    public ResourceLocation getKey(T p_122746_) {
        Holder.Reference<T> reference = this.byValue.get(p_122746_);
        return reference != null ? reference.key().location() : null;
    }

    @Override
    public Optional<ResourceKey<T>> getResourceKey(T p_122755_) {
        return Optional.ofNullable(this.byValue.get(p_122755_)).map(Holder.Reference::key);
    }

    @Override
    public int getId(@Nullable T p_122706_) {
        return this.toId.getInt(p_122706_);
    }

    @Override
    @Nullable
    public T get(@Nullable ResourceKey<T> p_122714_) {
        return MappedRegistry.getValueFromNullable(this.byKey.get(p_122714_));
    }

    @Override
    @Nullable
    public T byId(int p_122684_) {
        return p_122684_ >= 0 && p_122684_ < this.byId.size() ? (T)MappedRegistry.getValueFromNullable((Holder.Reference)this.byId.get(p_122684_)) : null;
    }

    @Override
    public Optional<Holder.Reference<T>> getHolder(int p_205907_) {
        return p_205907_ >= 0 && p_205907_ < this.byId.size() ? Optional.ofNullable((Holder.Reference)this.byId.get(p_205907_)) : Optional.empty();
    }

    @Override
    public Optional<Holder.Reference<T>> getHolder(ResourceKey<T> p_205905_) {
        return Optional.ofNullable(this.byKey.get(p_205905_));
    }

    @Override
    public Holder<T> wrapAsHolder(T p_263356_) {
        Holder.Reference<T> reference = this.byValue.get(p_263356_);
        return reference != null ? reference : Holder.direct(p_263356_);
    }

    Holder.Reference<T> getOrCreateHolderOrThrow(ResourceKey<T> p_248831_) {
        return this.byKey.computeIfAbsent(p_248831_, p_258169_ -> {
            if (this.unregisteredIntrusiveHolders != null) {
                throw new IllegalStateException("This registry can't create new holders without value");
            }
            this.validateWrite((ResourceKey<T>)p_258169_);
            return Holder.Reference.createStandAlone(this.holderOwner(), p_258169_);
        });
    }

    @Override
    public int size() {
        return this.byKey.size();
    }

    @Override
    public Lifecycle lifecycle(T p_122764_) {
        return this.lifecycles.get(p_122764_);
    }

    @Override
    public Lifecycle registryLifecycle() {
        return this.registryLifecycle;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.transform(this.holdersInOrder().iterator(), Holder::value);
    }

    @Override
    @Nullable
    public T get(@Nullable ResourceLocation p_122739_) {
        Holder.Reference<T> reference = this.byLocation.get(p_122739_);
        return MappedRegistry.getValueFromNullable(reference);
    }

    @Nullable
    private static <T> T getValueFromNullable(@Nullable Holder.Reference<T> p_205866_) {
        return p_205866_ != null ? (T)p_205866_.value() : null;
    }

    @Override
    public Set<ResourceLocation> keySet() {
        return Collections.unmodifiableSet(this.byLocation.keySet());
    }

    @Override
    public Set<ResourceKey<T>> registryKeySet() {
        return Collections.unmodifiableSet(this.byKey.keySet());
    }

    @Override
    public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
        return Collections.unmodifiableSet(Maps.transformValues(this.byKey, Holder::value).entrySet());
    }

    @Override
    public Stream<Holder.Reference<T>> holders() {
        return this.holdersInOrder().stream();
    }

    @Override
    public Stream<Pair<TagKey<T>, HolderSet.Named<T>>> getTags() {
        return this.tags.entrySet().stream().map(p_211060_ -> Pair.of((Object)((TagKey)p_211060_.getKey()), (Object)((HolderSet.Named)p_211060_.getValue())));
    }

    @Override
    public HolderSet.Named<T> getOrCreateTag(TagKey<T> p_205895_) {
        HolderSet.Named<T> named = this.tags.get(p_205895_);
        if (named == null) {
            named = this.createTag(p_205895_);
            IdentityHashMap<TagKey<T>, HolderSet.Named<T>> map = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.tags);
            map.put(p_205895_, named);
            this.tags = map;
        }
        return named;
    }

    private HolderSet.Named<T> createTag(TagKey<T> p_211068_) {
        return new HolderSet.Named<T>(this.holderOwner(), p_211068_);
    }

    @Override
    public Stream<TagKey<T>> getTagNames() {
        return this.tags.keySet().stream();
    }

    @Override
    public boolean isEmpty() {
        return this.byKey.isEmpty();
    }

    @Override
    public Optional<Holder.Reference<T>> getRandom(RandomSource p_235716_) {
        return Util.getRandomSafe(this.holdersInOrder(), p_235716_);
    }

    @Override
    public boolean containsKey(ResourceLocation p_122761_) {
        return this.byLocation.containsKey(p_122761_);
    }

    @Override
    public boolean containsKey(ResourceKey<T> p_175392_) {
        return this.byKey.containsKey(p_175392_);
    }

    @Deprecated
    public void unfreeze() {
        this.frozen = false;
    }

    @Override
    public Registry<T> freeze() {
        if (this.frozen) {
            return this;
        }
        this.frozen = true;
        List<ResourceLocation> list = this.byKey.entrySet().stream().filter(p_211055_ -> !((Holder.Reference)p_211055_.getValue()).isBound()).map(p_211794_ -> ((ResourceKey)p_211794_.getKey()).location()).sorted().toList();
        if (!list.isEmpty()) {
            throw new IllegalStateException("Unbound values in registry " + String.valueOf(this.key()) + ": " + String.valueOf(list));
        }
        if (this.unregisteredIntrusiveHolders != null && !this.unregisteredIntrusiveHolders.isEmpty()) {
            throw new IllegalStateException("Some intrusive holders were not registered: " + String.valueOf(this.unregisteredIntrusiveHolders.values()));
        }
        return this;
    }

    @Override
    public Holder.Reference<T> createIntrusiveHolder(T p_205915_) {
        if (this.unregisteredIntrusiveHolders == null) {
            throw new IllegalStateException("This registry can't create intrusive holders");
        }
        this.validateWrite();
        return this.unregisteredIntrusiveHolders.computeIfAbsent(p_205915_, p_258166_ -> Holder.Reference.createIntrusive(this.asLookup(), p_258166_));
    }

    @Override
    public Optional<HolderSet.Named<T>> getTag(TagKey<T> p_205909_) {
        return Optional.ofNullable(this.tags.get(p_205909_));
    }

    @Override
    public void bindTags(Map<TagKey<T>, List<Holder<T>>> p_205875_) {
        IdentityHashMap<Holder.Reference, List> map = new IdentityHashMap<Holder.Reference, List>();
        this.byKey.values().forEach(p_211801_ -> map.put((Holder.Reference)p_211801_, new ArrayList()));
        p_205875_.forEach((? super K p_211806_, ? super V p_211807_) -> {
            for (Holder holder : p_211807_) {
                if (!holder.canSerializeIn(this.asLookup())) {
                    throw new IllegalStateException("Can't create named set " + String.valueOf(p_211806_) + " containing value " + String.valueOf(holder) + " from outside registry " + String.valueOf(this));
                }
                if (!(holder instanceof Holder.Reference)) {
                    throw new IllegalStateException("Found direct holder " + String.valueOf(holder) + " value in tag " + String.valueOf(p_211806_));
                }
                Holder.Reference reference = (Holder.Reference)holder;
                ((List)map.get(reference)).add(p_211806_);
            }
        });
        Sets.SetView set = Sets.difference(this.tags.keySet(), p_205875_.keySet());
        if (!set.isEmpty()) {
            LOGGER.warn("Not all defined tags for registry {} are present in data pack: {}", this.key(), (Object)set.stream().map(p_211811_ -> p_211811_.location().toString()).sorted().collect(Collectors.joining(", ")));
        }
        IdentityHashMap<TagKey<T>, HolderSet.Named<T>> map1 = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.tags);
        p_205875_.forEach((? super K p_211797_, ? super V p_211798_) -> map1.computeIfAbsent((TagKey<T>)p_211797_, this::createTag).bind(p_211798_));
        map.forEach(Holder.Reference::bindTags);
        this.tags = map1;
    }

    @Override
    public void resetTags() {
        this.tags.values().forEach(p_211792_ -> p_211792_.bind(List.of()));
        this.byKey.values().forEach(p_211803_ -> p_211803_.bindTags(Set.of()));
    }

    @Override
    public HolderGetter<T> createRegistrationLookup() {
        this.validateWrite();
        return new HolderGetter<T>(){

            @Override
            public Optional<Holder.Reference<T>> get(ResourceKey<T> p_259097_) {
                return Optional.of(this.getOrThrow(p_259097_));
            }

            @Override
            public Holder.Reference<T> getOrThrow(ResourceKey<T> p_259750_) {
                return MappedRegistry.this.getOrCreateHolderOrThrow(p_259750_);
            }

            @Override
            public Optional<HolderSet.Named<T>> get(TagKey<T> p_259486_) {
                return Optional.of(this.getOrThrow(p_259486_));
            }

            @Override
            public HolderSet.Named<T> getOrThrow(TagKey<T> p_260298_) {
                return MappedRegistry.this.getOrCreateTag(p_260298_);
            }
        };
    }

    @Override
    public HolderOwner<T> holderOwner() {
        return this.lookup;
    }

    @Override
    public HolderLookup.RegistryLookup<T> asLookup() {
        return this.lookup;
    }
}

