/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.ForgeHooks;

public class RegistrySetBuilder {
    private final List<RegistryStub<?>> entries = new ArrayList();

    static <T> HolderGetter<T> wrapContextLookup(final HolderLookup.RegistryLookup<T> p_255625_) {
        return new EmptyTagLookup<T>(p_255625_){

            @Override
            public Optional<Holder.Reference<T>> get(ResourceKey<T> p_255765_) {
                return p_255625_.get(p_255765_);
            }
        };
    }

    public <T> RegistrySetBuilder add(ResourceKey<? extends Registry<T>> p_256446_, Lifecycle p_256394_, RegistryBootstrap<T> p_256638_) {
        this.entries.add(new RegistryStub<T>(p_256446_, p_256394_, p_256638_));
        return this;
    }

    public <T> RegistrySetBuilder add(ResourceKey<? extends Registry<T>> p_256261_, RegistryBootstrap<T> p_256010_) {
        return this.add(p_256261_, Lifecycle.stable(), p_256010_);
    }

    public List<? extends ResourceKey<? extends Registry<?>>> getEntryKeys() {
        return this.entries.stream().map(RegistryStub::key).toList();
    }

    private BuildState createState(RegistryAccess p_256400_) {
        BuildState registrysetbuilder$buildstate = BuildState.create(p_256400_, this.entries.stream().map(RegistryStub::key));
        this.entries.forEach(p_255629_ -> p_255629_.apply(registrysetbuilder$buildstate));
        return registrysetbuilder$buildstate;
    }

    public HolderLookup.Provider build(RegistryAccess p_256112_) {
        BuildState registrysetbuilder$buildstate = this.createState(p_256112_);
        Stream<HolderLookup.RegistryLookup> stream = p_256112_.registries().map(p_258195_ -> p_258195_.value().asLookup());
        Stream<HolderLookup.RegistryLookup> stream1 = this.entries.stream().map(p_255700_ -> p_255700_.collectChanges(registrysetbuilder$buildstate).buildAsLookup());
        HolderLookup.Provider holderlookup$provider = HolderLookup.Provider.create(Stream.concat(stream, stream1.peek(registrysetbuilder$buildstate::addOwner)));
        registrysetbuilder$buildstate.reportRemainingUnreferencedValues();
        registrysetbuilder$buildstate.throwOnError();
        return holderlookup$provider;
    }

    public HolderLookup.Provider buildPatch(RegistryAccess p_255676_, HolderLookup.Provider p_255900_) {
        BuildState registrysetbuilder$buildstate = this.createState(p_255676_);
        HashMap map = new HashMap();
        registrysetbuilder$buildstate.collectReferencedRegistries().forEach(p_272339_ -> map.put(p_272339_.key, p_272339_));
        this.entries.stream().map(p_272337_ -> p_272337_.collectChanges(registrysetbuilder$buildstate)).forEach(p_272341_ -> map.put(p_272341_.key, p_272341_));
        Stream<HolderLookup.RegistryLookup> stream = p_255676_.registries().map(p_258194_ -> p_258194_.value().asLookup());
        HolderLookup.Provider holderlookup$provider = HolderLookup.Provider.create(Stream.concat(stream, map.values().stream().map(RegistryContents::buildAsLookup).peek(registrysetbuilder$buildstate::addOwner)));
        registrysetbuilder$buildstate.fillMissingHolders(p_255900_);
        registrysetbuilder$buildstate.reportRemainingUnreferencedValues();
        registrysetbuilder$buildstate.throwOnError();
        return holderlookup$provider;
    }

    record RegistryStub<T>(ResourceKey<? extends Registry<T>> key, Lifecycle lifecycle, RegistryBootstrap<T> bootstrap) {
        void apply(BuildState p_256272_) {
            this.bootstrap.run(p_256272_.bootstapContext());
        }

        public RegistryContents<T> collectChanges(BuildState p_256416_) {
            HashMap map = new HashMap();
            Iterator<Map.Entry<ResourceKey<?>, RegisteredValue<?>>> iterator = p_256416_.registeredValues.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceKey<?>, RegisteredValue<?>> entry = iterator.next();
                ResourceKey<?> resourcekey = entry.getKey();
                if (!resourcekey.isFor(this.key)) continue;
                RegisteredValue<?> registeredvalue = entry.getValue();
                Holder.Reference<Object> reference = p_256416_.lookup.holders.remove(resourcekey);
                map.put(resourcekey, new ValueAndHolder(registeredvalue, Optional.ofNullable(reference)));
                iterator.remove();
            }
            return new RegistryContents(this.key, this.lifecycle, map);
        }
    }

    @FunctionalInterface
    public static interface RegistryBootstrap<T> {
        public void run(BootstapContext<T> var1);
    }

    record BuildState(CompositeOwner owner, UniversalLookup lookup, Map<ResourceLocation, HolderGetter<?>> registries, Map<ResourceKey<?>, RegisteredValue<?>> registeredValues, List<RuntimeException> errors) {
        public static BuildState create(RegistryAccess p_255995_, Stream<ResourceKey<? extends Registry<?>>> p_256495_) {
            CompositeOwner registrysetbuilder$compositeowner = new CompositeOwner();
            ArrayList<RuntimeException> list = new ArrayList<RuntimeException>();
            UniversalLookup registrysetbuilder$universallookup = new UniversalLookup(registrysetbuilder$compositeowner);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            p_255995_.registries().forEach(p_258197_ -> builder.put((Object)p_258197_.key().location(), ForgeHooks.wrapRegistryLookup(p_258197_.value().asLookup())));
            p_256495_.forEach(p_256603_ -> builder.put((Object)p_256603_.location(), (Object)registrysetbuilder$universallookup));
            return new BuildState(registrysetbuilder$compositeowner, registrysetbuilder$universallookup, (Map<ResourceLocation, HolderGetter<?>>)builder.build(), new HashMap(), (List<RuntimeException>)list);
        }

        public <T> BootstapContext<T> bootstapContext() {
            return new BootstapContext<T>(){

                @Override
                public Holder.Reference<T> register(ResourceKey<T> p_256176_, T p_256422_, Lifecycle p_255924_) {
                    RegisteredValue registeredvalue = registeredValues.put(p_256176_, new RegisteredValue(p_256422_, p_255924_));
                    if (registeredvalue != null) {
                        errors.add(new IllegalStateException("Duplicate registration for " + String.valueOf(p_256176_) + ", new=" + String.valueOf(p_256422_) + ", old=" + String.valueOf(registeredvalue.value)));
                    }
                    return lookup.getOrCreate(p_256176_);
                }

                @Override
                public <S> HolderGetter<S> lookup(ResourceKey<? extends Registry<? extends S>> p_255961_) {
                    return registries.getOrDefault(p_255961_.location(), lookup);
                }

                @Override
                public <S> Optional<HolderLookup.RegistryLookup<S>> registryLookup(ResourceKey<? extends Registry<? extends S>> registry) {
                    return Optional.ofNullable((HolderLookup.RegistryLookup)registries.get(registry.location()));
                }
            };
        }

        public void reportRemainingUnreferencedValues() {
            for (ResourceKey<Object> resourcekey : this.lookup.holders.keySet()) {
                this.errors.add(new IllegalStateException("Unreferenced key: " + String.valueOf(resourcekey)));
            }
            this.registeredValues.forEach((p_256143_, p_256662_) -> this.errors.add(new IllegalStateException("Orpaned value " + String.valueOf(p_256662_.value) + " for key " + String.valueOf(p_256143_))));
        }

        public void throwOnError() {
            if (!this.errors.isEmpty()) {
                IllegalStateException illegalstateexception = new IllegalStateException("Errors during registry creation");
                for (RuntimeException runtimeexception : this.errors) {
                    illegalstateexception.addSuppressed(runtimeexception);
                }
                throw illegalstateexception;
            }
        }

        public void addOwner(HolderOwner<?> p_256407_) {
            this.owner.add(p_256407_);
        }

        public void fillMissingHolders(HolderLookup.Provider p_255679_) {
            HashMap<ResourceLocation, Optional> map = new HashMap<ResourceLocation, Optional>();
            Iterator<Map.Entry<ResourceKey<Object>, Holder.Reference<Object>>> iterator = this.lookup.holders.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceKey<Object>, Holder.Reference<Object>> entry = iterator.next();
                ResourceKey<Object> resourcekey = entry.getKey();
                Holder.Reference<Object> reference = entry.getValue();
                map.computeIfAbsent(resourcekey.registry(), p_255896_ -> p_255679_.lookup(ResourceKey.createRegistryKey(p_255896_))).flatMap(p_256068_ -> p_256068_.get(resourcekey)).ifPresent(p_256030_ -> {
                    reference.bindValue(p_256030_.value());
                    iterator.remove();
                });
            }
        }

        public Stream<RegistryContents<?>> collectReferencedRegistries() {
            return this.lookup.holders.keySet().stream().map(ResourceKey::registry).distinct().map(p_272342_ -> new RegistryContents(ResourceKey.createRegistryKey(p_272342_), Lifecycle.stable(), Map.of()));
        }
    }

    record RegistryContents<T>(ResourceKey<? extends Registry<? extends T>> key, Lifecycle lifecycle, Map<ResourceKey<T>, ValueAndHolder<T>> values) {
        public HolderLookup.RegistryLookup<T> buildAsLookup() {
            return new HolderLookup.RegistryLookup<T>(){
                private final Map<ResourceKey<T>, Holder.Reference<T>> entries;
                {
                    this.entries = values.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, p_256193_ -> {
                        ValueAndHolder valueandholder = (ValueAndHolder)p_256193_.getValue();
                        Holder.Reference reference = valueandholder.holder().orElseGet(() -> Holder.Reference.createStandAlone(this, (ResourceKey)p_256193_.getKey()));
                        reference.bindValue(valueandholder.value().value());
                        return reference;
                    }));
                }

                @Override
                public ResourceKey<? extends Registry<? extends T>> key() {
                    return key;
                }

                @Override
                public Lifecycle registryLifecycle() {
                    return lifecycle;
                }

                @Override
                public Optional<Holder.Reference<T>> get(ResourceKey<T> p_255760_) {
                    return Optional.ofNullable(this.entries.get(p_255760_));
                }

                @Override
                public Stream<Holder.Reference<T>> listElements() {
                    return this.entries.values().stream();
                }

                @Override
                public Optional<HolderSet.Named<T>> get(TagKey<T> p_255810_) {
                    return Optional.empty();
                }

                @Override
                public Stream<HolderSet.Named<T>> listTags() {
                    return Stream.empty();
                }
            };
        }
    }

    record ValueAndHolder<T>(RegisteredValue<T> value, Optional<Holder.Reference<T>> holder) {
    }

    static class UniversalLookup
    extends EmptyTagLookup<Object> {
        final Map<ResourceKey<Object>, Holder.Reference<Object>> holders = new HashMap<ResourceKey<Object>, Holder.Reference<Object>>();

        public UniversalLookup(HolderOwner<Object> p_256629_) {
            super(p_256629_);
        }

        @Override
        public Optional<Holder.Reference<Object>> get(ResourceKey<Object> p_256303_) {
            return Optional.of(this.getOrCreate(p_256303_));
        }

        <T> Holder.Reference<T> getOrCreate(ResourceKey<T> p_256298_) {
            return this.holders.computeIfAbsent(p_256298_, p_256154_ -> Holder.Reference.createStandAlone(this.owner, p_256154_));
        }
    }

    record RegisteredValue<T>(T value, Lifecycle lifecycle) {
    }

    static abstract class EmptyTagLookup<T>
    implements HolderGetter<T> {
        protected final HolderOwner<T> owner;

        protected EmptyTagLookup(HolderOwner<T> p_256166_) {
            this.owner = p_256166_;
        }

        @Override
        public Optional<HolderSet.Named<T>> get(TagKey<T> p_256664_) {
            return Optional.of(HolderSet.emptyNamed(this.owner, p_256664_));
        }
    }

    static class CompositeOwner
    implements HolderOwner<Object> {
        private final Set<HolderOwner<?>> owners = Sets.newIdentityHashSet();

        CompositeOwner() {
        }

        @Override
        public boolean canSerializeIn(HolderOwner<Object> p_256333_) {
            return this.owners.contains(p_256333_);
        }

        public void add(HolderOwner<?> p_256361_) {
            this.owners.add(p_256361_);
        }
    }
}

