/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.RegistryLayer;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.registries.DataPackRegistriesHooks;

public class RegistrySynchronization {
    private static final Map<ResourceKey<? extends Registry<?>>, NetworkedRegistryData<?>> NETWORKABLE_REGISTRIES = Util.make(() -> {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        RegistrySynchronization.put(builder, Registries.BIOME, Biome.NETWORK_CODEC);
        RegistrySynchronization.put(builder, Registries.CHAT_TYPE, ChatType.CODEC);
        RegistrySynchronization.put(builder, Registries.TRIM_PATTERN, TrimPattern.DIRECT_CODEC);
        RegistrySynchronization.put(builder, Registries.TRIM_MATERIAL, TrimMaterial.DIRECT_CODEC);
        RegistrySynchronization.put(builder, Registries.DIMENSION_TYPE, DimensionType.DIRECT_CODEC);
        RegistrySynchronization.put(builder, Registries.DAMAGE_TYPE, DamageType.CODEC);
        return DataPackRegistriesHooks.grabNetworkableRegistries(builder);
    });
    public static final Codec<RegistryAccess> NETWORK_CODEC = RegistrySynchronization.makeNetworkCodec();

    private static <E> void put(ImmutableMap.Builder<ResourceKey<? extends Registry<?>>, NetworkedRegistryData<?>> p_251643_, ResourceKey<? extends Registry<E>> p_249195_, Codec<E> p_249212_) {
        p_251643_.put(p_249195_, new NetworkedRegistryData<E>(p_249195_, p_249212_));
    }

    private static Stream<RegistryAccess.RegistryEntry<?>> ownedNetworkableRegistries(RegistryAccess p_251842_) {
        return p_251842_.registries().filter(p_250129_ -> NETWORKABLE_REGISTRIES.containsKey(p_250129_.key()));
    }

    private static <E> DataResult<? extends Codec<E>> getNetworkCodec(ResourceKey<? extends Registry<E>> p_252190_) {
        return Optional.ofNullable(NETWORKABLE_REGISTRIES.get(p_252190_)).map(p_250582_ -> p_250582_.networkCodec()).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown or not serializable registry: " + String.valueOf(p_252190_)));
    }

    private static <E> Codec<RegistryAccess> makeNetworkCodec() {
        Codec codec = ResourceLocation.CODEC.xmap(ResourceKey::createRegistryKey, ResourceKey::location);
        Codec codec1 = codec.partialDispatch("type", p_258198_ -> DataResult.success(p_258198_.key()), p_250682_ -> RegistrySynchronization.getNetworkCodec(p_250682_).map(p_252116_ -> RegistryCodecs.networkCodec(p_250682_, Lifecycle.experimental(), p_252116_)));
        UnboundedMapCodec unboundedmapcodec = Codec.unboundedMap((Codec)codec, (Codec)codec1);
        return RegistrySynchronization.captureMap(unboundedmapcodec);
    }

    private static <K extends ResourceKey<? extends Registry<?>>, V extends Registry<?>> Codec<RegistryAccess> captureMap(UnboundedMapCodec<K, V> p_249934_) {
        return p_249934_.xmap(RegistryAccess.ImmutableRegistryAccess::new, p_251578_ -> (Map)RegistrySynchronization.ownedNetworkableRegistries(p_251578_).collect(ImmutableMap.toImmutableMap(p_250395_ -> p_250395_.key(), p_248951_ -> p_248951_.value())));
    }

    public static Stream<RegistryAccess.RegistryEntry<?>> networkedRegistries(LayeredRegistryAccess<RegistryLayer> p_259290_) {
        return RegistrySynchronization.ownedNetworkableRegistries(p_259290_.getAccessFrom(RegistryLayer.WORLDGEN));
    }

    public static Stream<RegistryAccess.RegistryEntry<?>> networkSafeRegistries(LayeredRegistryAccess<RegistryLayer> p_249066_) {
        Stream<RegistryAccess.RegistryEntry<?>> stream = p_249066_.getLayer(RegistryLayer.STATIC).registries();
        Stream<RegistryAccess.RegistryEntry<?>> stream1 = RegistrySynchronization.networkedRegistries(p_249066_);
        return Stream.concat(stream1, stream);
    }

    public record NetworkedRegistryData<E>(ResourceKey<? extends Registry<E>> key, Codec<E> networkCodec) {
    }
}

