/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.loot;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataResolver;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.slf4j.Logger;

public class LootTableProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackOutput.PathProvider pathProvider;
    private final Set<ResourceLocation> requiredTables;
    private final List<SubProviderEntry> subProviders;

    public LootTableProvider(PackOutput p_254123_, Set<ResourceLocation> p_254481_, List<SubProviderEntry> p_253798_) {
        this.pathProvider = p_254123_.createPathProvider(PackOutput.Target.DATA_PACK, "loot_tables");
        this.subProviders = p_253798_;
        this.requiredTables = p_254481_;
    }

    @Override
    public CompletableFuture<?> run(CachedOutput p_254060_) {
        final HashMap map = Maps.newHashMap();
        Object2ObjectOpenHashMap map1 = new Object2ObjectOpenHashMap();
        this.getTables().forEach(arg_0 -> LootTableProvider.lambda$run$1((Map)map1, map, arg_0));
        ValidationContext validationcontext = new ValidationContext(LootContextParamSets.ALL_PARAMS, new LootDataResolver(){

            @Override
            @Nullable
            public <T> T getElement(LootDataId<T> p_279283_) {
                return (T)(p_279283_.type() == LootDataType.TABLE ? (LootTable)map.get(p_279283_.location()) : null);
            }
        });
        this.validate(map, validationcontext);
        Multimap<String, String> multimap = validationcontext.getProblems();
        if (!multimap.isEmpty()) {
            multimap.forEach((p_124446_, p_124447_) -> LOGGER.warn("Found validation problem in {}: {}", p_124446_, p_124447_));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(p_278900_ -> {
            ResourceLocation resourcelocation1 = (ResourceLocation)p_278900_.getKey();
            LootTable loottable = (LootTable)p_278900_.getValue();
            Path path = this.pathProvider.json(resourcelocation1);
            return DataProvider.saveStable(p_254060_, LootDataType.TABLE.parser().toJsonTree((Object)loottable), path);
        }).toArray(CompletableFuture[]::new));
    }

    public List<SubProviderEntry> getTables() {
        return this.subProviders;
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationcontext) {
        for (ResourceLocation resourcelocation : Sets.difference(this.requiredTables, map.keySet())) {
            validationcontext.reportProblem("Missing built-in table: " + String.valueOf(resourcelocation));
        }
        map.forEach((p_278897_, p_278898_) -> p_278898_.validate(validationcontext.setParams(p_278898_.getParamSet()).enterElement("{" + String.valueOf(p_278897_) + "}", new LootDataId<LootTable>(LootDataType.TABLE, (ResourceLocation)p_278897_))));
    }

    @Override
    public final String getName() {
        return "Loot Tables";
    }

    private static /* synthetic */ void lambda$run$1(Map map1, Map map, SubProviderEntry p_288263_) {
        p_288263_.provider().get().generate((p_288259_, p_288260_) -> {
            ResourceLocation resourcelocation1 = map1.put(RandomSequence.seedForKey(p_288259_), p_288259_);
            if (resourcelocation1 != null) {
                Util.logAndPauseIfInIde("Loot table random sequence seed collision on " + String.valueOf(resourcelocation1) + " and " + String.valueOf(p_288259_));
            }
            p_288260_.setRandomSequence((ResourceLocation)p_288259_);
            if (map.put(p_288259_, p_288260_.setParamSet(p_288263_.paramSet).build()) != null) {
                throw new IllegalStateException("Duplicate loot table " + String.valueOf(p_288259_));
            }
        });
    }

    public record SubProviderEntry(Supplier<LootTableSubProvider> provider, LootContextParamSet paramSet) {
    }
}

