/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public interface RecipeBuilder {
    public static final ResourceLocation ROOT_RECIPE_ADVANCEMENT = new ResourceLocation("recipes/root");

    public RecipeBuilder unlockedBy(String var1, CriterionTriggerInstance var2);

    public RecipeBuilder group(@Nullable String var1);

    public Item getResult();

    public void save(Consumer<FinishedRecipe> var1, ResourceLocation var2);

    default public void save(Consumer<FinishedRecipe> p_176499_) {
        this.save(p_176499_, RecipeBuilder.getDefaultRecipeId(this.getResult()));
    }

    default public void save(Consumer<FinishedRecipe> p_176501_, String p_176502_) {
        ResourceLocation resourcelocation1 = new ResourceLocation(p_176502_);
        ResourceLocation resourcelocation = RecipeBuilder.getDefaultRecipeId(this.getResult());
        if (resourcelocation1.equals(resourcelocation)) {
            throw new IllegalStateException("Recipe " + p_176502_ + " should remove its 'save' argument as it is equal to default one");
        }
        this.save(p_176501_, resourcelocation1);
    }

    public static ResourceLocation getDefaultRecipeId(ItemLike p_176494_) {
        return BuiltInRegistries.ITEM.getKey(p_176494_.asItem());
    }
}

