/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.data.worldgen.placement.VillagePlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class SavannaVillagePools {
    public static final ResourceKey<StructureTemplatePool> START = Pools.createKey("village/savanna/town_centers");
    private static final ResourceKey<StructureTemplatePool> TERMINATORS_KEY = Pools.createKey("village/savanna/terminators");
    private static final ResourceKey<StructureTemplatePool> ZOMBIE_TERMINATORS_KEY = Pools.createKey("village/savanna/zombie/terminators");

    public static void bootstrap(BootstapContext<StructureTemplatePool> p_256198_) {
        HolderGetter<PlacedFeature> holdergetter = p_256198_.lookup(Registries.PLACED_FEATURE);
        Holder.Reference<PlacedFeature> holder = holdergetter.getOrThrow(VillagePlacements.ACACIA_VILLAGE);
        Holder.Reference<PlacedFeature> holder1 = holdergetter.getOrThrow(VillagePlacements.PILE_HAY_VILLAGE);
        Holder.Reference<PlacedFeature> holder2 = holdergetter.getOrThrow(VillagePlacements.PILE_MELON_VILLAGE);
        HolderGetter<StructureProcessorList> holdergetter1 = p_256198_.lookup(Registries.PROCESSOR_LIST);
        Holder.Reference<StructureProcessorList> holder3 = holdergetter1.getOrThrow(ProcessorLists.ZOMBIE_SAVANNA);
        Holder.Reference<StructureProcessorList> holder4 = holdergetter1.getOrThrow(ProcessorLists.STREET_SAVANNA);
        Holder.Reference<StructureProcessorList> holder5 = holdergetter1.getOrThrow(ProcessorLists.FARM_SAVANNA);
        HolderGetter<StructureTemplatePool> holdergetter2 = p_256198_.lookup(Registries.TEMPLATE_POOL);
        Holder.Reference<StructureTemplatePool> holder6 = holdergetter2.getOrThrow(Pools.EMPTY);
        Holder.Reference<StructureTemplatePool> holder7 = holdergetter2.getOrThrow(TERMINATORS_KEY);
        Holder.Reference<StructureTemplatePool> holder8 = holdergetter2.getOrThrow(ZOMBIE_TERMINATORS_KEY);
        p_256198_.register(START, new StructureTemplatePool(holder6, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/savanna/town_centers/savanna_meeting_point_1"), (Object)100), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/town_centers/savanna_meeting_point_2"), (Object)50), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/town_centers/savanna_meeting_point_3"), (Object)150), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/town_centers/savanna_meeting_point_4"), (Object)150), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/town_centers/savanna_meeting_point_1", holder3), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/town_centers/savanna_meeting_point_2", holder3), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/town_centers/savanna_meeting_point_3", holder3), (Object)3), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/town_centers/savanna_meeting_point_4", holder3), (Object)3)), StructureTemplatePool.Projection.RIGID));
        Pools.register(p_256198_, "village/savanna/streets", new StructureTemplatePool(holder7, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/savanna/streets/corner_01", holder4), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/streets/corner_03", holder4), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/streets/straight_02", holder4), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/streets/straight_04", holder4), (Object)7), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/streets/straight_05", holder4), (Object)3), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/streets/straight_06", holder4), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/streets/straight_08", holder4), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/streets/straight_09", holder4), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/streets/straight_10", holder4), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/streets/straight_11", holder4), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/streets/crossroad_02", holder4), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/streets/crossroad_03", holder4), (Object)2), (Object[])new Pair[]{Pair.of(StructurePoolElement.legacy("village/savanna/streets/crossroad_04", holder4), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/streets/crossroad_05", holder4), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/streets/crossroad_06", holder4), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/streets/crossroad_07", holder4), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/streets/split_01", holder4), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/streets/split_02", holder4), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/streets/turn_01", holder4), (Object)3)}), StructureTemplatePool.Projection.TERRAIN_MATCHING));
        Pools.register(p_256198_, "village/savanna/zombie/streets", new StructureTemplatePool(holder8, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/streets/corner_01", holder4), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/streets/corner_03", holder4), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/streets/straight_02", holder4), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/streets/straight_04", holder4), (Object)7), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/streets/straight_05", holder4), (Object)3), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/streets/straight_06", holder4), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/streets/straight_08", holder4), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/streets/straight_09", holder4), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/streets/straight_10", holder4), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/streets/straight_11", holder4), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/streets/crossroad_02", holder4), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/streets/crossroad_03", holder4), (Object)2), (Object[])new Pair[]{Pair.of(StructurePoolElement.legacy("village/savanna/zombie/streets/crossroad_04", holder4), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/zombie/streets/crossroad_05", holder4), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/zombie/streets/crossroad_06", holder4), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/zombie/streets/crossroad_07", holder4), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/zombie/streets/split_01", holder4), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/zombie/streets/split_02", holder4), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/zombie/streets/turn_01", holder4), (Object)3)}), StructureTemplatePool.Projection.TERRAIN_MATCHING));
        Pools.register(p_256198_, "village/savanna/houses", new StructureTemplatePool(holder7, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_small_house_1"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_small_house_2"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_small_house_3"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_small_house_4"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_small_house_5"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_small_house_6"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_small_house_7"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_small_house_8"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_medium_house_1"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_medium_house_2"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_butchers_shop_1"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_butchers_shop_2"), (Object)2), (Object[])new Pair[]{Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_tool_smith_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_fletcher_house_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_shepherd_1"), (Object)7), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_armorer_1"), (Object)1), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_fisher_cottage_1"), (Object)3), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_tannery_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_cartographer_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_library_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_mason_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_weaponsmith_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_weaponsmith_2"), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_temple_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_temple_2"), (Object)3), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_large_farm_1", holder5), (Object)4), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_large_farm_2", holder5), (Object)6), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_small_farm", holder5), (Object)4), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_animal_pen_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_animal_pen_2"), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_animal_pen_3"), (Object)2), Pair.of(StructurePoolElement.empty(), (Object)5)}), StructureTemplatePool.Projection.RIGID));
        Pools.register(p_256198_, "village/savanna/zombie/houses", new StructureTemplatePool(holder8, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/houses/savanna_small_house_1", holder3), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/houses/savanna_small_house_2", holder3), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/houses/savanna_small_house_3", holder3), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/houses/savanna_small_house_4", holder3), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/houses/savanna_small_house_5", holder3), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/houses/savanna_small_house_6", holder3), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/houses/savanna_small_house_7", holder3), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/houses/savanna_small_house_8", holder3), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/houses/savanna_medium_house_1", holder3), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/houses/savanna_medium_house_2", holder3), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_butchers_shop_1", holder3), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_butchers_shop_2", holder3), (Object)2), (Object[])new Pair[]{Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_tool_smith_1", holder3), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_fletcher_house_1", holder3), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_shepherd_1", holder3), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_armorer_1", holder3), (Object)1), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_fisher_cottage_1", holder3), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_tannery_1", holder3), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_cartographer_1", holder3), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_library_1", holder3), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_mason_1", holder3), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_weaponsmith_1", holder3), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_weaponsmith_2", holder3), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_temple_1", holder3), (Object)1), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_temple_2", holder3), (Object)3), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_large_farm_1", holder3), (Object)4), Pair.of(StructurePoolElement.legacy("village/savanna/zombie/houses/savanna_large_farm_2", holder3), (Object)4), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_small_farm", holder3), (Object)4), Pair.of(StructurePoolElement.legacy("village/savanna/houses/savanna_animal_pen_1", holder3), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/zombie/houses/savanna_animal_pen_2", holder3), (Object)2), Pair.of(StructurePoolElement.legacy("village/savanna/zombie/houses/savanna_animal_pen_3", holder3), (Object)2), Pair.of(StructurePoolElement.empty(), (Object)5)}), StructureTemplatePool.Projection.RIGID));
        p_256198_.register(TERMINATORS_KEY, new StructureTemplatePool(holder6, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/plains/terminators/terminator_01", holder4), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/plains/terminators/terminator_02", holder4), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/plains/terminators/terminator_03", holder4), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/plains/terminators/terminator_04", holder4), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/terminators/terminator_05", holder4), (Object)1)), StructureTemplatePool.Projection.TERRAIN_MATCHING));
        p_256198_.register(ZOMBIE_TERMINATORS_KEY, new StructureTemplatePool(holder6, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/plains/terminators/terminator_01", holder4), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/plains/terminators/terminator_02", holder4), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/plains/terminators/terminator_03", holder4), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/plains/terminators/terminator_04", holder4), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/terminators/terminator_05", holder4), (Object)1)), StructureTemplatePool.Projection.TERRAIN_MATCHING));
        Pools.register(p_256198_, "village/savanna/trees", new StructureTemplatePool(holder6, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.feature(holder), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(p_256198_, "village/savanna/decor", new StructureTemplatePool(holder6, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/savanna/savanna_lamp_post_01"), (Object)4), (Object)Pair.of(StructurePoolElement.feature(holder), (Object)4), (Object)Pair.of(StructurePoolElement.feature(holder1), (Object)4), (Object)Pair.of(StructurePoolElement.feature(holder2), (Object)1), (Object)Pair.of(StructurePoolElement.empty(), (Object)4)), StructureTemplatePool.Projection.RIGID));
        Pools.register(p_256198_, "village/savanna/zombie/decor", new StructureTemplatePool(holder6, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/savanna/savanna_lamp_post_01", holder3), (Object)4), (Object)Pair.of(StructurePoolElement.feature(holder), (Object)4), (Object)Pair.of(StructurePoolElement.feature(holder1), (Object)4), (Object)Pair.of(StructurePoolElement.feature(holder2), (Object)1), (Object)Pair.of(StructurePoolElement.empty(), (Object)4)), StructureTemplatePool.Projection.RIGID));
        Pools.register(p_256198_, "village/savanna/villagers", new StructureTemplatePool(holder6, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/savanna/villagers/nitwit"), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/villagers/baby"), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/villagers/unemployed"), (Object)10)), StructureTemplatePool.Projection.RIGID));
        Pools.register(p_256198_, "village/savanna/zombie/villagers", new StructureTemplatePool(holder6, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/villagers/nitwit"), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/savanna/zombie/villagers/unemployed"), (Object)10)), StructureTemplatePool.Projection.RIGID));
    }
}

