/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.data.worldgen.placement.VillagePlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class SnowyVillagePools {
    public static final ResourceKey<StructureTemplatePool> START = Pools.createKey("village/snowy/town_centers");
    private static final ResourceKey<StructureTemplatePool> TERMINATORS_KEY = Pools.createKey("village/snowy/terminators");

    public static void bootstrap(BootstapContext<StructureTemplatePool> p_256549_) {
        HolderGetter<PlacedFeature> holdergetter = p_256549_.lookup(Registries.PLACED_FEATURE);
        Holder.Reference<PlacedFeature> holder = holdergetter.getOrThrow(VillagePlacements.SPRUCE_VILLAGE);
        Holder.Reference<PlacedFeature> holder1 = holdergetter.getOrThrow(VillagePlacements.PILE_SNOW_VILLAGE);
        Holder.Reference<PlacedFeature> holder2 = holdergetter.getOrThrow(VillagePlacements.PILE_ICE_VILLAGE);
        HolderGetter<StructureProcessorList> holdergetter1 = p_256549_.lookup(Registries.PROCESSOR_LIST);
        Holder.Reference<StructureProcessorList> holder3 = holdergetter1.getOrThrow(ProcessorLists.STREET_SNOWY_OR_TAIGA);
        Holder.Reference<StructureProcessorList> holder4 = holdergetter1.getOrThrow(ProcessorLists.FARM_SNOWY);
        Holder.Reference<StructureProcessorList> holder5 = holdergetter1.getOrThrow(ProcessorLists.ZOMBIE_SNOWY);
        HolderGetter<StructureTemplatePool> holdergetter2 = p_256549_.lookup(Registries.TEMPLATE_POOL);
        Holder.Reference<StructureTemplatePool> holder6 = holdergetter2.getOrThrow(Pools.EMPTY);
        Holder.Reference<StructureTemplatePool> holder7 = holdergetter2.getOrThrow(TERMINATORS_KEY);
        p_256549_.register(START, new StructureTemplatePool(holder6, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/snowy/town_centers/snowy_meeting_point_1"), (Object)100), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/town_centers/snowy_meeting_point_2"), (Object)50), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/town_centers/snowy_meeting_point_3"), (Object)150), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/town_centers/snowy_meeting_point_1"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/town_centers/snowy_meeting_point_2"), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/town_centers/snowy_meeting_point_3"), (Object)3)), StructureTemplatePool.Projection.RIGID));
        Pools.register(p_256549_, "village/snowy/streets", new StructureTemplatePool(holder7, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/snowy/streets/corner_01", holder3), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/streets/corner_02", holder3), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/streets/corner_03", holder3), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/streets/square_01", holder3), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/streets/straight_01", holder3), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/streets/straight_02", holder3), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/streets/straight_03", holder3), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/streets/straight_04", holder3), (Object)7), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/streets/straight_06", holder3), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/streets/straight_08", holder3), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/streets/crossroad_02", holder3), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/streets/crossroad_03", holder3), (Object)2), (Object[])new Pair[]{Pair.of(StructurePoolElement.legacy("village/snowy/streets/crossroad_04", holder3), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/streets/crossroad_05", holder3), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/streets/crossroad_06", holder3), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/streets/turn_01", holder3), (Object)3)}), StructureTemplatePool.Projection.TERRAIN_MATCHING));
        Pools.register(p_256549_, "village/snowy/zombie/streets", new StructureTemplatePool(holder7, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/corner_01", holder3), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/corner_02", holder3), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/corner_03", holder3), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/square_01", holder3), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/straight_01", holder3), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/straight_02", holder3), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/straight_03", holder3), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/straight_04", holder3), (Object)7), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/straight_06", holder3), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/straight_08", holder3), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/crossroad_02", holder3), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/crossroad_03", holder3), (Object)2), (Object[])new Pair[]{Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/crossroad_04", holder3), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/crossroad_05", holder3), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/crossroad_06", holder3), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/zombie/streets/turn_01", holder3), (Object)3)}), StructureTemplatePool.Projection.TERRAIN_MATCHING));
        Pools.register(p_256549_, "village/snowy/houses", new StructureTemplatePool(holder7, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_small_house_1"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_small_house_2"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_small_house_3"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_small_house_4"), (Object)3), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_small_house_5"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_small_house_6"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_small_house_7"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_small_house_8"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_medium_house_1"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_medium_house_2"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_medium_house_3"), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_butchers_shop_1"), (Object)2), (Object[])new Pair[]{Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_butchers_shop_2"), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_tool_smith_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_fletcher_house_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_shepherds_house_1"), (Object)3), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_armorer_house_1"), (Object)1), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_armorer_house_2"), (Object)1), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_fisher_cottage"), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_tannery_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_cartographer_house_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_library_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_masons_house_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_masons_house_2"), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_weapon_smith_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_temple_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_farm_1", holder4), (Object)3), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_farm_2", holder4), (Object)3), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_animal_pen_1"), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_animal_pen_2"), (Object)2), Pair.of(StructurePoolElement.empty(), (Object)6)}), StructureTemplatePool.Projection.RIGID));
        Pools.register(p_256549_, "village/snowy/zombie/houses", new StructureTemplatePool(holder7, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/houses/snowy_small_house_1", holder5), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/houses/snowy_small_house_2", holder5), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/houses/snowy_small_house_3", holder5), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/houses/snowy_small_house_4", holder5), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/houses/snowy_small_house_5", holder5), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/houses/snowy_small_house_6", holder5), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/houses/snowy_small_house_7", holder5), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/houses/snowy_small_house_8", holder5), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/houses/snowy_medium_house_1", holder5), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/houses/snowy_medium_house_2", holder5), (Object)2), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/houses/snowy_medium_house_3", holder5), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_butchers_shop_1", holder5), (Object)2), (Object[])new Pair[]{Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_butchers_shop_2", holder5), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_tool_smith_1", holder5), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_fletcher_house_1", holder5), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_shepherds_house_1", holder5), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_armorer_house_1", holder5), (Object)1), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_armorer_house_2", holder5), (Object)1), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_fisher_cottage", holder5), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_tannery_1", holder5), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_cartographer_house_1", holder5), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_library_1", holder5), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_masons_house_1", holder5), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_masons_house_2", holder5), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_weapon_smith_1", holder5), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_temple_1", holder5), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_farm_1", holder5), (Object)3), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_farm_2", holder5), (Object)3), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_animal_pen_1", holder5), (Object)2), Pair.of(StructurePoolElement.legacy("village/snowy/houses/snowy_animal_pen_2", holder5), (Object)2), Pair.of(StructurePoolElement.empty(), (Object)6)}), StructureTemplatePool.Projection.RIGID));
        p_256549_.register(TERMINATORS_KEY, new StructureTemplatePool(holder6, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/plains/terminators/terminator_01", holder3), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/plains/terminators/terminator_02", holder3), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/plains/terminators/terminator_03", holder3), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/plains/terminators/terminator_04", holder3), (Object)1)), StructureTemplatePool.Projection.TERRAIN_MATCHING));
        Pools.register(p_256549_, "village/snowy/trees", new StructureTemplatePool(holder6, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.feature(holder), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(p_256549_, "village/snowy/decor", new StructureTemplatePool(holder6, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/snowy/snowy_lamp_post_01"), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/snowy_lamp_post_02"), (Object)4), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/snowy_lamp_post_03"), (Object)1), (Object)Pair.of(StructurePoolElement.feature(holder), (Object)4), (Object)Pair.of(StructurePoolElement.feature(holder1), (Object)4), (Object)Pair.of(StructurePoolElement.feature(holder2), (Object)1), (Object)Pair.of(StructurePoolElement.empty(), (Object)9)), StructureTemplatePool.Projection.RIGID));
        Pools.register(p_256549_, "village/snowy/zombie/decor", new StructureTemplatePool(holder6, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/snowy/snowy_lamp_post_01", holder5), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/snowy_lamp_post_02", holder5), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/snowy_lamp_post_03", holder5), (Object)1), (Object)Pair.of(StructurePoolElement.feature(holder), (Object)4), (Object)Pair.of(StructurePoolElement.feature(holder1), (Object)4), (Object)Pair.of(StructurePoolElement.feature(holder2), (Object)4), (Object)Pair.of(StructurePoolElement.empty(), (Object)7)), StructureTemplatePool.Projection.RIGID));
        Pools.register(p_256549_, "village/snowy/villagers", new StructureTemplatePool(holder6, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/snowy/villagers/nitwit"), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/villagers/baby"), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/villagers/unemployed"), (Object)10)), StructureTemplatePool.Projection.RIGID));
        Pools.register(p_256549_, "village/snowy/zombie/villagers", new StructureTemplatePool(holder6, (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/villagers/nitwit"), (Object)1), (Object)Pair.of(StructurePoolElement.legacy("village/snowy/zombie/villagers/unemployed"), (Object)10)), StructureTemplatePool.Projection.RIGID));
    }
}

