/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;

public class NbtAccounter {
    public static final NbtAccounter UNLIMITED = new NbtAccounter(0L){

        @Override
        public void accountBytes(long p_128927_) {
        }
    };
    private final long quota;
    private long usage;

    public NbtAccounter(long p_128922_) {
        this.quota = p_128922_;
    }

    public void accountBytes(long p_263515_) {
        this.usage += p_263515_;
        if (this.usage > this.quota) {
            throw new RuntimeException("Tried to read NBT tag that was too big; tried to allocate: " + this.usage + "bytes where max allowed: " + this.quota);
        }
    }

    public String readUTF(String data) {
        this.accountBytes(2L);
        if (data == null) {
            return data;
        }
        int len = data.length();
        int utflen = 0;
        for (int i = 0; i < len; ++i) {
            char c = data.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        this.accountBytes(utflen);
        return data;
    }

    @VisibleForTesting
    public long getUsage() {
        return this.usage;
    }
}

