/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import javax.annotation.Nullable;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.util.SignatureValidator;

@FunctionalInterface
public interface SignedMessageValidator {
    public static final SignedMessageValidator ACCEPT_UNSIGNED = p_252109_ -> !p_252109_.hasSignature();
    public static final SignedMessageValidator REJECT_ALL = p_251793_ -> false;

    public boolean updateAndValidate(PlayerChatMessage var1);

    public static class KeyBased
    implements SignedMessageValidator {
        private final SignatureValidator validator;
        @Nullable
        private PlayerChatMessage lastMessage;
        private boolean isChainValid = true;

        public KeyBased(SignatureValidator p_241517_) {
            this.validator = p_241517_;
        }

        private boolean validateChain(PlayerChatMessage p_250412_) {
            if (p_250412_.equals(this.lastMessage)) {
                return true;
            }
            return this.lastMessage == null || p_250412_.link().isDescendantOf(this.lastMessage.link());
        }

        @Override
        public boolean updateAndValidate(PlayerChatMessage p_251182_) {
            boolean bl = this.isChainValid = this.isChainValid && p_251182_.verify(this.validator) && this.validateChain(p_251182_);
            if (!this.isChainValid) {
                return false;
            }
            this.lastMessage = p_251182_;
            return true;
        }
    }
}

