/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import io.netty.util.AttributeKey;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.BundleDelimiterPacket;
import net.minecraft.network.protocol.BundlePacket;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;

public interface BundlerInfo {
    public static final AttributeKey<Provider> BUNDLER_PROVIDER = AttributeKey.valueOf((String)"bundler");
    public static final int BUNDLE_SIZE_LIMIT = 4096;
    public static final BundlerInfo EMPTY = new BundlerInfo(){

        @Override
        public void unbundlePacket(Packet<?> p_265538_, Consumer<Packet<?>> p_265064_) {
            p_265064_.accept(p_265538_);
        }

        @Override
        @Nullable
        public Bundler startPacketBundling(Packet<?> p_265749_) {
            return null;
        }
    };

    public static <T extends PacketListener, P extends BundlePacket<T>> BundlerInfo createForPacket(final Class<P> p_265438_, final Function<Iterable<Packet<T>>, P> p_265627_, final BundleDelimiterPacket<T> p_265373_) {
        return new BundlerInfo(){

            @Override
            public void unbundlePacket(Packet<?> p_265337_, Consumer<Packet<?>> p_265615_) {
                if (p_265337_.getClass() == p_265438_) {
                    BundlePacket p = (BundlePacket)p_265337_;
                    p_265615_.accept(p_265373_);
                    p.subPackets().forEach(p_265615_);
                    p_265615_.accept(p_265373_);
                } else {
                    p_265615_.accept(p_265337_);
                }
            }

            @Override
            @Nullable
            public Bundler startPacketBundling(Packet<?> p_265097_) {
                return p_265097_ == p_265373_ ? new Bundler(){
                    private final List<Packet<T>> bundlePackets = new ArrayList();

                    @Override
                    @Nullable
                    public Packet<?> addPacket(Packet<?> p_265205_) {
                        if (p_265205_ == p_265373_) {
                            return (Packet)p_265627_.apply(this.bundlePackets);
                        }
                        if (this.bundlePackets.size() >= 4096) {
                            throw new IllegalStateException("Too many packets in a bundle");
                        }
                        this.bundlePackets.add(p_265205_);
                        return null;
                    }
                } : null;
            }
        };
    }

    public void unbundlePacket(Packet<?> var1, Consumer<Packet<?>> var2);

    @Nullable
    public Bundler startPacketBundling(Packet<?> var1);

    public static interface Provider {
        public BundlerInfo getBundlerInfo(PacketFlow var1);
    }

    public static interface Bundler {
        @Nullable
        public Packet<?> addPacket(Packet<?> var1);
    }
}

