/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;

public class ClientboundSetEquipmentPacket
implements Packet<ClientGamePacketListener> {
    private static final byte CONTINUE_MASK = -128;
    private final int entity;
    private final List<Pair<EquipmentSlot, ItemStack>> slots;

    public ClientboundSetEquipmentPacket(int p_133202_, List<Pair<EquipmentSlot, ItemStack>> p_133203_) {
        this.entity = p_133202_;
        this.slots = p_133203_;
    }

    public ClientboundSetEquipmentPacket(FriendlyByteBuf p_179297_) {
        byte i;
        this.entity = p_179297_.readVarInt();
        EquipmentSlot[] aequipmentslot = EquipmentSlot.values();
        this.slots = Lists.newArrayList();
        do {
            i = p_179297_.readByte();
            EquipmentSlot equipmentslot = aequipmentslot[i & 0x7F];
            ItemStack itemstack = p_179297_.readItem();
            this.slots.add((Pair<EquipmentSlot, ItemStack>)Pair.of((Object)((Object)equipmentslot), (Object)itemstack));
        } while ((i & 0xFFFFFF80) != 0);
    }

    @Override
    public void write(FriendlyByteBuf p_133212_) {
        p_133212_.writeVarInt(this.entity);
        int i = this.slots.size();
        for (int j = 0; j < i; ++j) {
            Pair<EquipmentSlot, ItemStack> pair = this.slots.get(j);
            EquipmentSlot equipmentslot = (EquipmentSlot)((Object)pair.getFirst());
            boolean flag = j != i - 1;
            int k = equipmentslot.ordinal();
            p_133212_.writeByte(flag ? k | 0xFFFFFF80 : k);
            p_133212_.writeItem((ItemStack)pair.getSecond());
        }
    }

    @Override
    public void handle(ClientGamePacketListener p_133209_) {
        p_133209_.handleSetEquipment(this);
    }

    public int getEntity() {
        return this.entity;
    }

    public List<Pair<EquipmentSlot, ItemStack>> getSlots() {
        return this.slots;
    }
}

