/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class ClientboundUpdateAttributesPacket
implements Packet<ClientGamePacketListener> {
    private final int entityId;
    private final List<AttributeSnapshot> attributes;

    public ClientboundUpdateAttributesPacket(int p_133580_, Collection<AttributeInstance> p_133581_) {
        this.entityId = p_133580_;
        this.attributes = Lists.newArrayList();
        for (AttributeInstance attributeinstance : p_133581_) {
            this.attributes.add(new AttributeSnapshot(attributeinstance.getAttribute(), attributeinstance.getBaseValue(), attributeinstance.getModifiers()));
        }
    }

    public ClientboundUpdateAttributesPacket(FriendlyByteBuf p_179447_) {
        this.entityId = p_179447_.readVarInt();
        this.attributes = p_179447_.readList(p_258211_ -> {
            ResourceLocation resourcelocation = p_258211_.readResourceLocation();
            Attribute attribute = BuiltInRegistries.ATTRIBUTE.get(resourcelocation);
            double d0 = p_258211_.readDouble();
            List<AttributeModifier> list = p_258211_.readList(p_179457_ -> new AttributeModifier(p_179457_.readUUID(), "Unknown synced attribute modifier", p_179457_.readDouble(), AttributeModifier.Operation.fromValue(p_179457_.readByte())));
            return new AttributeSnapshot(attribute, d0, list);
        });
    }

    @Override
    public void write(FriendlyByteBuf p_133590_) {
        p_133590_.writeVarInt(this.entityId);
        p_133590_.writeCollection(this.attributes, (p_258212_, p_258213_) -> {
            p_258212_.writeResourceLocation(BuiltInRegistries.ATTRIBUTE.getKey(p_258213_.getAttribute()));
            p_258212_.writeDouble(p_258213_.getBase());
            p_258212_.writeCollection(p_258213_.getModifiers(), (p_179449_, p_179450_) -> {
                p_179449_.writeUUID(p_179450_.getId());
                p_179449_.writeDouble(p_179450_.getAmount());
                p_179449_.writeByte(p_179450_.getOperation().toValue());
            });
        });
    }

    @Override
    public void handle(ClientGamePacketListener p_133587_) {
        p_133587_.handleUpdateAttributes(this);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public List<AttributeSnapshot> getValues() {
        return this.attributes;
    }

    public static class AttributeSnapshot {
        private final Attribute attribute;
        private final double base;
        private final Collection<AttributeModifier> modifiers;

        public AttributeSnapshot(Attribute p_179459_, double p_179460_, Collection<AttributeModifier> p_179461_) {
            this.attribute = p_179459_;
            this.base = p_179460_;
            this.modifiers = p_179461_;
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public double getBase() {
            return this.base;
        }

        public Collection<AttributeModifier> getModifiers() {
            return this.modifiers;
        }
    }
}

