/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.resources.ResourceLocation;

public class ServerboundSeenAdvancementsPacket
implements Packet<ServerGamePacketListener> {
    private final Action action;
    @Nullable
    private final ResourceLocation tab;

    public ServerboundSeenAdvancementsPacket(Action p_134434_, @Nullable ResourceLocation p_134435_) {
        this.action = p_134434_;
        this.tab = p_134435_;
    }

    public static ServerboundSeenAdvancementsPacket openedTab(Advancement p_134443_) {
        return new ServerboundSeenAdvancementsPacket(Action.OPENED_TAB, p_134443_.getId());
    }

    public static ServerboundSeenAdvancementsPacket closedScreen() {
        return new ServerboundSeenAdvancementsPacket(Action.CLOSED_SCREEN, null);
    }

    public ServerboundSeenAdvancementsPacket(FriendlyByteBuf p_179744_) {
        this.action = p_179744_.readEnum(Action.class);
        this.tab = this.action == Action.OPENED_TAB ? p_179744_.readResourceLocation() : null;
    }

    @Override
    public void write(FriendlyByteBuf p_134446_) {
        p_134446_.writeEnum(this.action);
        if (this.action == Action.OPENED_TAB) {
            p_134446_.writeResourceLocation(this.tab);
        }
    }

    @Override
    public void handle(ServerGamePacketListener p_134441_) {
        p_134441_.handleSeenAdvancements(this);
    }

    public Action getAction() {
        return this.action;
    }

    @Nullable
    public ResourceLocation getTab() {
        return this.tab;
    }

    public static enum Action {
        OPENED_TAB,
        CLOSED_SCREEN;

    }
}

