/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.login;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.login.ClientLoginPacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.ICustomPacket;
import org.jetbrains.annotations.Nullable;

public class ClientboundCustomQueryPacket
implements Packet<ClientLoginPacketListener>,
ICustomPacket<ClientboundCustomQueryPacket> {
    private static final int MAX_PAYLOAD_SIZE = 0x100000;
    private final int transactionId;
    private final ResourceLocation identifier;
    private final FriendlyByteBuf data;

    public ClientboundCustomQueryPacket(int p_179806_, ResourceLocation p_179807_, FriendlyByteBuf p_179808_) {
        this.transactionId = p_179806_;
        this.identifier = p_179807_;
        this.data = p_179808_;
    }

    public ClientboundCustomQueryPacket(FriendlyByteBuf p_179810_) {
        this.transactionId = p_179810_.readVarInt();
        this.identifier = p_179810_.readResourceLocation();
        int i = p_179810_.readableBytes();
        if (i < 0 || i > 0x100000) {
            throw new IllegalArgumentException("Payload may not be larger than 1048576 bytes");
        }
        this.data = new FriendlyByteBuf(p_179810_.readBytes(i));
    }

    @Override
    public void write(FriendlyByteBuf p_134757_) {
        p_134757_.writeVarInt(this.transactionId);
        p_134757_.writeResourceLocation(this.identifier);
        p_134757_.writeBytes(this.data.slice());
    }

    @Override
    public void handle(ClientLoginPacketListener p_134754_) {
        p_134754_.handleCustomQuery(this);
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public FriendlyByteBuf getData() {
        return this.data;
    }

    @Override
    public int getIndex() {
        return this.getTransactionId();
    }

    @Override
    public ResourceLocation getName() {
        return this.getIdentifier();
    }

    @Override
    @Nullable
    public FriendlyByteBuf getInternalData() {
        return this.getData();
    }
}

